/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.bulkhead;

import org.apache.safeguard.api.bulkhead.BulkheadBuilder;
import org.apache.safeguard.api.bulkhead.BulkheadDefinition;
import org.apache.safeguard.impl.bulkhead.BulkheadDefinitionImpl;
import org.apache.safeguard.impl.bulkhead.BulkheadManagerImpl;

public class BulkheadBuilderImpl
implements BulkheadBuilder {
    private final String name;
    private final BulkheadManagerImpl bulkheadManager;
    private int maxWaitingExecutions;
    private int maxConcurrentExecutions;
    private boolean asynchronous = false;

    BulkheadBuilderImpl(String name, BulkheadManagerImpl bulkheadManager) {
        this.name = name;
        this.bulkheadManager = bulkheadManager;
    }

    public BulkheadBuilder withMaxConcurrency(int maxConcurrency) {
        this.maxConcurrentExecutions = maxConcurrency;
        return this;
    }

    public BulkheadBuilder withMaxWaiting(int overflowCapacity) {
        this.maxWaitingExecutions = overflowCapacity;
        return this;
    }

    public BulkheadBuilder asynchronous() {
        this.asynchronous = true;
        return this;
    }

    public BulkheadDefinition build() {
        BulkheadDefinitionImpl definition = new BulkheadDefinitionImpl(this.maxConcurrentExecutions, this.maxWaitingExecutions, this.asynchronous);
        this.bulkheadManager.register(this.name, definition);
        return definition;
    }
}

