/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.api.ExecutionManager;
import org.apache.safeguard.api.bulkhead.BulkheadManager;
import org.apache.safeguard.api.circuitbreaker.CircuitBreakerManager;
import org.apache.safeguard.api.retry.RetryManager;
import org.apache.safeguard.impl.bulkhead.BulkheadManagerImpl;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerManager;
import org.apache.safeguard.impl.config.MicroprofileAnnotationMapper;
import org.apache.safeguard.impl.executionPlans.ExecutionPlanFactory;
import org.apache.safeguard.impl.retry.FailsafeRetryManager;

@Vetoed
public class FailsafeExecutionManager
implements ExecutionManager {
    private final MicroprofileAnnotationMapper mapper;
    private final BulkheadManager bulkheadManager;
    private final CircuitBreakerManager circuitBreakerManager;
    private final RetryManager retryManager;
    private final ExecutionPlanFactory executionPlanFactory;

    public FailsafeExecutionManager() {
        FailsafeCircuitBreakerManager circuitBreakerManager = new FailsafeCircuitBreakerManager();
        FailsafeRetryManager retryManager = new FailsafeRetryManager();
        BulkheadManagerImpl bulkheadManager = new BulkheadManagerImpl();
        this.mapper = MicroprofileAnnotationMapper.getInstance();
        this.executionPlanFactory = new ExecutionPlanFactory(circuitBreakerManager, retryManager, bulkheadManager, this.mapper);
        this.circuitBreakerManager = circuitBreakerManager;
        this.retryManager = retryManager;
        this.bulkheadManager = bulkheadManager;
    }

    public FailsafeExecutionManager(MicroprofileAnnotationMapper mapper, BulkheadManagerImpl bulkheadManager, FailsafeCircuitBreakerManager circuitBreakerManager, FailsafeRetryManager retryManager, ExecutionPlanFactory executionPlanFactory) {
        this.mapper = mapper;
        this.bulkheadManager = bulkheadManager;
        this.circuitBreakerManager = circuitBreakerManager;
        this.retryManager = retryManager;
        this.executionPlanFactory = executionPlanFactory;
    }

    public Object execute(InvocationContext invocationContext) {
        Method method = invocationContext.getMethod();
        return this.executionPlanFactory.locateExecutionPlan(method).execute(() -> ((InvocationContext)invocationContext).proceed(), invocationContext);
    }

    public <T> T execute(String name, Callable<T> callable) {
        return this.executionPlanFactory.locateExecutionPlan(name, null, false).execute(callable, null);
    }

    public <T> T executeAsync(String name, Callable<T> callable) {
        return this.executionPlanFactory.locateExecutionPlan(name, null, true).execute(callable, null);
    }

    public <T> T executeAsync(String name, Callable<T> callable, Duration timeout) {
        return this.executionPlanFactory.locateExecutionPlan(name, timeout, true).execute(callable, null);
    }

    public ExecutionPlanFactory getExecutionPlanFactory() {
        return this.executionPlanFactory;
    }

    public CircuitBreakerManager getCircuitBreakerManager() {
        return this.circuitBreakerManager;
    }

    public RetryManager getRetryManager() {
        return this.retryManager;
    }

    public BulkheadManager getBulkheadManager() {
        return this.bulkheadManager;
    }
}

