/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.principal;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import org.apache.tomee.microprofile.jwt.ParseException;
import org.apache.tomee.microprofile.jwt.config.JWTAuthContextInfo;
import org.apache.tomee.microprofile.jwt.principal.JWTCallerPrincipal;

public abstract class JWTCallerPrincipalFactory {
    private static JWTCallerPrincipalFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JWTCallerPrincipalFactory instance() {
        if (instance != null) return instance;
        Class<JWTCallerPrincipalFactory> clazz = JWTCallerPrincipalFactory.class;
        synchronized (JWTCallerPrincipalFactory.class) {
            JWTCallerPrincipalFactory newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = JWTCallerPrincipalFactory.class.getClassLoader();
            }
            if ((newInstance = JWTCallerPrincipalFactory.loadSpi(cl)) == null && cl != JWTCallerPrincipalFactory.class.getClassLoader()) {
                cl = JWTCallerPrincipalFactory.class.getClassLoader();
                newInstance = JWTCallerPrincipalFactory.loadSpi(cl);
            }
            if (newInstance == null) {
                throw new IllegalStateException("No JWTCallerPrincipalFactory implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static JWTCallerPrincipalFactory loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        JWTCallerPrincipalFactory instance = JWTCallerPrincipalFactory.loadSpi(cl.getParent());
        if (instance == null) {
            ServiceLoader<JWTCallerPrincipalFactory> sl = ServiceLoader.load(JWTCallerPrincipalFactory.class, cl);
            URL u = cl.getResource("/META-INF/services/org.apache.tomee.microprofile.jwt.JWTCallerPrincipalFactory");
            System.out.printf("JWTCallerPrincipalFactory, cl=%s, u=%s, sl=%s\n", cl, u, sl);
            try {
                for (JWTCallerPrincipalFactory spi : sl) {
                    if (instance != null) {
                        throw new IllegalStateException("Multiple JWTCallerPrincipalFactory implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName());
                    }
                    System.out.printf("sl=%s, loaded=%s\n", sl, spi);
                    instance = spi;
                }
            }
            catch (Throwable e) {
                System.err.printf("Warning: %s\n", e.getMessage());
            }
        }
        return instance;
    }

    public static void setInstance(JWTCallerPrincipalFactory resolver) {
        instance = resolver;
    }

    public abstract JWTCallerPrincipal parse(String var1, JWTAuthContextInfo var2) throws ParseException;
}

