/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import org.apache.tomee.microprofile.jwt.cdi.ClaimInjectionPoint;
import org.apache.tomee.microprofile.jwt.cdi.ClaimValueWrapper;
import org.apache.tomee.microprofile.jwt.cdi.MPJWTCDIExtension;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Vetoed
public class ClaimBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Logger logger = Logger.getLogger(MPJWTCDIExtension.class.getName());
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    @Inject
    private Jsonb jsonb;
    private final BeanManager bm;
    private final Class rawType;
    private final Set<Type> types;
    private final String id;
    private final Class<? extends Annotation> scope;
    private static final String TMP = "tmp";

    public ClaimBean(BeanManager bm, Type type) {
        this.bm = bm;
        this.types = new HashSet<Type>();
        this.types.add(type);
        this.rawType = this.getRawType(type);
        this.id = "ClaimBean_" + this.types;
        this.scope = Dependent.class;
    }

    private Class getRawType(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType paramType = (ParameterizedType)ParameterizedType.class.cast(type);
            return (Class)Class.class.cast(paramType.getRawType());
        }
        throw new UnsupportedOperationException("Unsupported type " + type);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return this.rawType;
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(T instance, CreationalContext<T> context) {
        logger.finest("Destroying CDI Bean for type " + this.types.iterator().next());
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public T create(CreationalContext<T> context) {
        logger.finest("Creating CDI Bean for type " + this.types.iterator().next());
        InjectionPoint ip = (InjectionPoint)this.bm.getInjectableReference((InjectionPoint)new ClaimInjectionPoint(this), context);
        if (ip == null) {
            throw new IllegalStateException("Could not retrieve InjectionPoint for type " + this.types.iterator().next());
        }
        Annotated annotated = ip.getAnnotated();
        Claim claim = (Claim)annotated.getAnnotation(Claim.class);
        final String key = ClaimBean.getClaimKey(claim);
        logger.finest(String.format("Found Claim injection with name=%s and for %s", key, ip.toString()));
        if (ParameterizedType.class.isInstance(annotated.getBaseType())) {
            ParameterizedType paramType = (ParameterizedType)ParameterizedType.class.cast(annotated.getBaseType());
            Type rawType = paramType.getRawType();
            if (Class.class.isInstance(rawType) && paramType.getActualTypeArguments().length == 1) {
                Class rawTypeClass = (Class)rawType;
                if (rawTypeClass.isAssignableFrom(Provider.class)) {
                    Type providerType = paramType.getActualTypeArguments()[0];
                    if (ParameterizedType.class.isInstance(providerType) && this.isOptional((ParameterizedType)ParameterizedType.class.cast(providerType))) {
                        return (T)Optional.ofNullable(this.getClaimValue(key));
                    }
                    return this.getClaimValue(key);
                }
                if (rawTypeClass.isAssignableFrom(Instance.class)) {
                    Type instanceType = paramType.getActualTypeArguments()[0];
                    if (ParameterizedType.class.isInstance(instanceType) && this.isOptional((ParameterizedType)ParameterizedType.class.cast(instanceType))) {
                        return (T)Optional.ofNullable(this.getClaimValue(key));
                    }
                    return this.getClaimValue(key);
                }
                if (rawTypeClass.isAssignableFrom(ClaimValue.class)) {
                    Type claimValueType = paramType.getActualTypeArguments()[0];
                    ClaimValueWrapper claimValueWrapper = new ClaimValueWrapper(key);
                    if (ParameterizedType.class.isInstance(claimValueType) && this.isOptional((ParameterizedType)ParameterizedType.class.cast(claimValueType))) {
                        claimValueWrapper.setValue(new Supplier(){

                            public Object get() {
                                Object claimValue = ClaimBean.this.getClaimValue(key);
                                return Optional.ofNullable(claimValue);
                            }
                        });
                    } else if (ParameterizedType.class.isInstance(claimValueType) && this.isSet((ParameterizedType)ParameterizedType.class.cast(claimValueType))) {
                        claimValueWrapper.setValue(new Supplier(){

                            public Object get() {
                                Object claimValue = ClaimBean.this.getClaimValue(key);
                                return claimValue;
                            }
                        });
                    } else if (ParameterizedType.class.isInstance(claimValueType) && this.isList((ParameterizedType)ParameterizedType.class.cast(claimValueType))) {
                        claimValueWrapper.setValue(new Supplier(){

                            public Object get() {
                                Object claimValue = ClaimBean.this.getClaimValue(key);
                                return claimValue;
                            }
                        });
                    } else if (Class.class.isInstance(claimValueType)) {
                        claimValueWrapper.setValue(new Supplier(){

                            public Object get() {
                                Object claimValue = ClaimBean.this.getClaimValue(key);
                                return claimValue;
                            }
                        });
                    } else {
                        throw new IllegalArgumentException("Unsupported ClaimValue type " + claimValueType.toString());
                    }
                    return (T)claimValueWrapper;
                }
                if (rawTypeClass.isAssignableFrom(Optional.class)) {
                    return this.getClaimValue(key);
                }
                if (rawTypeClass.isAssignableFrom(Set.class)) {
                    return this.getClaimValue(key);
                }
                if (rawTypeClass.isAssignableFrom(List.class)) {
                    return this.getClaimValue(key);
                }
            }
        } else {
            if (annotated.getBaseType().getTypeName().startsWith("javax.json.Json")) {
                return (T)this.toJson(key);
            }
            if (((Class)ip.getType()).isEnum()) {
                try {
                    return (T)((Class)ip.getType()).getMethod("valueOf", String.class).invoke(null, this.getClaimValue(key).toString());
                }
                catch (Exception exception) {
                }
            } else {
                return this.getClaimValue(key);
            }
        }
        throw new IllegalStateException("Unhandled Claim type " + annotated.getBaseType());
    }

    public static String getClaimKey(Claim claim) {
        return claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
    }

    private T getClaimValue(String name) {
        Bean bean = this.bm.resolve(this.bm.getBeans(JsonWebToken.class, new Annotation[0]));
        JsonWebToken jsonWebToken = null;
        if (RequestScoped.class.equals((Object)bean.getScope())) {
            jsonWebToken = (JsonWebToken)JsonWebToken.class.cast(this.bm.getReference(bean, JsonWebToken.class, null));
        }
        if (jsonWebToken == null || !bean.getScope().equals(RequestScoped.class)) {
            logger.warning(String.format("Can't retrieve claim %s. No active principal.", name));
            return null;
        }
        Optional claimValue = jsonWebToken.claim(name);
        logger.finest(String.format("Found ClaimValue=%s for name=%s", claimValue, name));
        return claimValue.orElse(null);
    }

    private JsonValue toJson(String name) {
        T claimValue = this.getClaimValue(name);
        return this.wrapValue(claimValue);
    }

    private JsonValue wrapValue(Object value) {
        JsonValue jsonValue = null;
        if (JsonValue.class.isInstance(value)) {
            jsonValue = (JsonValue)JsonValue.class.cast(value);
        } else if (String.class.isInstance(value)) {
            jsonValue = Json.createObjectBuilder().add(TMP, value.toString()).build().getJsonString(TMP);
        } else if (Number.class.isInstance(value)) {
            Number number = (Number)Number.class.cast(value);
            jsonValue = Long.class.isInstance(number) || Integer.class.isInstance(number) ? Json.createObjectBuilder().add(TMP, number.longValue()).build().getJsonNumber(TMP) : Json.createObjectBuilder().add(TMP, number.doubleValue()).build().getJsonNumber(TMP);
        } else if (Boolean.class.isInstance(value)) {
            Boolean flag = (Boolean)Boolean.class.cast(value);
            jsonValue = flag != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (Collection.class.isInstance(value)) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            Collection list = (Collection)Collection.class.cast(value);
            for (Object element : list) {
                if (String.class.isInstance(element)) {
                    arrayBuilder.add(element.toString());
                    continue;
                }
                JsonValue jvalue = this.wrapValue(element);
                arrayBuilder.add(jvalue);
            }
            jsonValue = arrayBuilder.build();
        } else if (Map.class.isInstance(value)) {
            jsonValue = (JsonValue)this.jsonb.fromJson(this.jsonb.toJson(value), JsonObject.class);
        }
        return jsonValue;
    }

    private boolean isOptional(ParameterizedType type) {
        return ((Class)type.getRawType()).isAssignableFrom(Optional.class);
    }

    private boolean isSet(ParameterizedType type) {
        return ((Class)type.getRawType()).isAssignableFrom(Set.class);
    }

    private boolean isList(ParameterizedType type) {
        return ((Class)type.getRawType()).isAssignableFrom(List.class);
    }

    static {
        QUALIFIERS.add((Annotation)((Object)new ClaimLiteral()));
    }

    private static class ClaimLiteral
    extends AnnotationLiteral<Claim>
    implements Claim {
        private ClaimLiteral() {
        }

        public String value() {
            return "";
        }

        public Claims standard() {
            return Claims.UNKNOWN;
        }
    }
}

