/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.tomee.microprofile.jwt.ParseException;
import org.apache.tomee.microprofile.jwt.config.JWTAuthContextInfo;
import org.apache.tomee.microprofile.jwt.principal.JWTCallerPrincipalFactory;
import org.eclipse.microprofile.jwt.JsonWebToken;

@WebFilter(asyncSupported=true, urlPatterns={"/*"})
public class MPJWTFilter
implements Filter {
    @Inject
    private Instance<JWTAuthContextInfo> authContextInfo;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block4: {
            if (this.authContextInfo.isUnsatisfied()) {
                chain.doFilter(request, response);
                return;
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            try {
                chain.doFilter((ServletRequest)new MPJWTServletRequestWrapper(httpServletRequest, (JWTAuthContextInfo)this.authContextInfo.get()), response);
            }
            catch (Exception e) {
                MPJWTException jwtException;
                if (MPJWTException.class.isInstance(e)) {
                    jwtException = (MPJWTException)MPJWTException.class.cast(e);
                    ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(jwtException.getStatus(), jwtException.getMessage());
                }
                if (!MPJWTException.class.isInstance(e.getCause())) break block4;
                jwtException = (MPJWTException)MPJWTException.class.cast(e.getCause());
                ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(jwtException.getStatus(), jwtException.getMessage());
            }
        }
    }

    public void destroy() {
    }

    private static Function<HttpServletRequest, JsonWebToken> token(final HttpServletRequest httpServletRequest, final JWTAuthContextInfo authContextInfo) {
        return new Function<HttpServletRequest, JsonWebToken>(){
            private JsonWebToken jsonWebToken;

            @Override
            public JsonWebToken apply(HttpServletRequest request) {
                if (this.jsonWebToken != null) {
                    return this.jsonWebToken;
                }
                String authorizationHeader = httpServletRequest.getHeader("Authorization");
                if (authorizationHeader == null || authorizationHeader.isEmpty()) {
                    throw new MissingAuthorizationHeaderException();
                }
                if (!authorizationHeader.toLowerCase(Locale.ENGLISH).startsWith("bearer ")) {
                    throw new BadAuthorizationPrefixException(authorizationHeader);
                }
                String token = authorizationHeader.substring("bearer ".length());
                try {
                    this.jsonWebToken = MPJWTFilter.validate(token, authContextInfo);
                }
                catch (ParseException e) {
                    throw new InvalidTokenException(token, e);
                }
                return this.jsonWebToken;
            }
        };
    }

    private static JsonWebToken validate(String bearerToken, JWTAuthContextInfo authContextInfo) throws ParseException {
        JWTCallerPrincipalFactory factory = JWTCallerPrincipalFactory.instance();
        return factory.parse(bearerToken, authContextInfo);
    }

    @Provider
    public static class MPJWTExceptionMapper
    implements ExceptionMapper<MPJWTException> {
        public Response toResponse(MPJWTException exception) {
            return Response.status((int)exception.getStatus()).entity((Object)exception.getMessage()).build();
        }
    }

    private static class InvalidTokenException
    extends MPJWTException {
        private final String token;

        public InvalidTokenException(String token, Throwable cause) {
            super(cause);
            this.token = token;
        }

        @Override
        public int getStatus() {
            return 401;
        }

        @Override
        public String getMessage() {
            return "Invalid or not parsable JWT " + this.token;
        }
    }

    private static class BadAuthorizationPrefixException
    extends MPJWTException {
        private String authorizationHeader;

        public BadAuthorizationPrefixException(String authorizationHeader) {
            this.authorizationHeader = authorizationHeader;
        }

        @Override
        public int getStatus() {
            return 401;
        }

        @Override
        public String getMessage() {
            return "Authorization header does not use the Bearer prefix. Can't validate header " + this.authorizationHeader;
        }
    }

    private static class MissingAuthorizationHeaderException
    extends MPJWTException {
        private MissingAuthorizationHeaderException() {
        }

        @Override
        public int getStatus() {
            return 401;
        }

        @Override
        public String getMessage() {
            return "No authorization header provided. Can't validate the JWT.";
        }
    }

    private static abstract class MPJWTException
    extends RuntimeException {
        public MPJWTException() {
        }

        public MPJWTException(Throwable cause) {
            super(cause);
        }

        public abstract int getStatus();

        @Override
        public abstract String getMessage();
    }

    public static class MPJWTServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final Function<HttpServletRequest, JsonWebToken> tokenFunction;
        private final HttpServletRequest request;

        public MPJWTServletRequestWrapper(final HttpServletRequest request, JWTAuthContextInfo authContextInfo) {
            super(request);
            this.request = request;
            this.tokenFunction = MPJWTFilter.token(request, authContextInfo);
            request.setAttribute(JsonWebToken.class.getName(), this.tokenFunction);
            request.setAttribute("javax.security.auth.subject.callable", (Object)new Callable<Subject>(){

                @Override
                public Subject call() throws Exception {
                    LinkedHashSet<JsonWebToken> principals = new LinkedHashSet<JsonWebToken>();
                    JsonWebToken namePrincipal = (JsonWebToken)tokenFunction.apply(request);
                    principals.add(namePrincipal);
                    principals.addAll(namePrincipal.getGroups().stream().map(new Function<String, Principal>(){

                        @Override
                        public Principal apply(final String role) {
                            return new Principal(){

                                @Override
                                public String getName() {
                                    return role;
                                }
                            };
                        }
                    }).collect(Collectors.toList()));
                    return new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
                }
            });
        }

        public Principal getUserPrincipal() {
            return (Principal)this.tokenFunction.apply(this.request);
        }

        public boolean isUserInRole(String role) {
            JsonWebToken jsonWebToken = this.tokenFunction.apply(this.request);
            return jsonWebToken.getGroups().contains(role);
        }

        public String getAuthType() {
            return "MP-JWT";
        }
    }
}

