/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.api.config;

import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.TreeSet;
import javax.annotation.Priority;

public abstract class ConfigFacade {
    private static ConfigFacade INSTANCE;

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract long getLong(String var1, long var2);

    public abstract int getInt(String var1, int var2);

    public abstract double getDouble(String var1, double var2);

    public abstract ChronoUnit getChronoUnit(String var1, ChronoUnit var2);

    public abstract Class<? extends Throwable>[] getThrowableClasses(String var1, Class<? extends Throwable>[] var2);

    public static ConfigFacade getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ConfigFacade.load();
        }
        return INSTANCE;
    }

    public static void setInstance(ConfigFacade configFacade) {
        INSTANCE = configFacade;
    }

    private static ConfigFacade load() {
        ServiceLoader<ConfigFacade> configFacades = ServiceLoader.load(ConfigFacade.class);
        TreeSet<ConfigFacade> configFacedSet = new TreeSet<ConfigFacade>(Comparator.comparingInt(c -> {
            Priority p = c.getClass().getAnnotation(Priority.class);
            return p == null ? 1 : p.value();
        }));
        for (ConfigFacade facade : configFacades) {
            configFacedSet.add(facade);
        }
        return (ConfigFacade)configFacedSet.first();
    }
}

