/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import java.util.Locale;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.SimpleConnectionManager;
import org.apache.openejb.resource.activemq.jms2.TomEEConnectionFactory;
import org.apache.openejb.resource.activemq.jms2.TomEEManagedConnection;
import org.apache.openejb.resource.activemq.jms2.TomEERAConnectionFactory;

public class TomEEManagedConnectionFactory
extends ActiveMQManagedConnectionFactory {
    private static final long serialVersionUID = 1L;
    private TransactionSupport.TransactionSupportLevel transactionSupportLevel;

    public Object createConnectionFactory(ConnectionManager manager) throws ResourceException {
        TomEERAConnectionFactory factory = new TomEERAConnectionFactory(this, manager, this.getInfo());
        factory.setTransactionSupport(this.transactionSupportLevel);
        return factory;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory((ConnectionManager)new SimpleConnectionManager());
    }

    protected ActiveMQConnectionFactory createConnectionFactory(ActiveMQConnectionRequestInfo connectionRequestInfo, MessageActivationSpec activationSpec) {
        TomEEConnectionFactory connectionFactory = new TomEEConnectionFactory();
        connectionRequestInfo.configure((ActiveMQConnectionFactory)connectionFactory, activationSpec);
        return connectionFactory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ActiveMQConnectionRequestInfo amqInfo = ActiveMQConnectionRequestInfo.class.isInstance(connectionRequestInfo) ? (ActiveMQConnectionRequestInfo)ActiveMQConnectionRequestInfo.class.cast(connectionRequestInfo) : this.getInfo();
        try {
            return new TomEEManagedConnection(subject, this.makeConnection(amqInfo), amqInfo, this.transactionSupportLevel);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create connection.", (Throwable)e);
        }
    }

    public boolean equals(Object object) {
        return object != null && ((Object)((Object)this)).getClass().isInstance(object) && ((ActiveMQManagedConnectionFactory)object).getInfo().equals((Object)this.getInfo());
    }

    public String getTransactionSupport() {
        switch (this.transactionSupportLevel) {
            case XATransaction: {
                return "xa";
            }
            case LocalTransaction: {
                return "local";
            }
            case NoTransaction: {
                return "none";
            }
        }
        return null;
    }

    public void setTransactionSupport(String transactionSupport) {
        if (transactionSupport == null) {
            throw new IllegalArgumentException("transactionSupport cannot be not null");
        }
        switch (transactionSupport.toLowerCase(Locale.ENGLISH)) {
            case "xa": {
                this.transactionSupportLevel = TransactionSupport.TransactionSupportLevel.XATransaction;
                break;
            }
            case "local": {
                this.transactionSupportLevel = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                break;
            }
            case "none": {
                this.transactionSupportLevel = TransactionSupport.TransactionSupportLevel.NoTransaction;
                break;
            }
            default: {
                throw new IllegalArgumentException("transactionSupport must be xa, local, or none:" + transactionSupport);
            }
        }
    }
}

