/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.local;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.openejb.resource.jdbc.managed.local.Key;
import org.apache.openejb.resource.jdbc.managed.local.LocalXAResource;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ManagedConnection
implements InvocationHandler {
    private final TransactionManager transactionManager;
    private final Key key;
    private final TransactionSynchronizationRegistry registry;
    protected XAResource xaResource;
    protected Connection delegate;
    protected XAConnection xaConnection;
    private Transaction currentTransaction;
    private boolean closed;

    public ManagedConnection(CommonDataSource ds, TransactionManager txMgr, TransactionSynchronizationRegistry txRegistry, String user, String password) {
        this.transactionManager = txMgr;
        this.registry = txRegistry;
        this.closed = false;
        this.key = new Key(ds, user, password);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.xaResource == null) {
            this.newConnection();
        }
        return this.xaResource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mtdName = method.getName();
        if ("toString".equals(mtdName)) {
            return "ManagedConnection{" + this.delegate + "}";
        }
        if ("hashCode".equals(mtdName)) {
            return this.hashCode();
        }
        if ("equals".equals(mtdName)) {
            InvocationHandler handler;
            return args[0] == this || (handler = this.unwrapHandler(args[0])) == this || this.delegate != null && this.delegate.equals(this.unwrapDelegate(args[0], handler));
        }
        if (Wrapper.class == method.getDeclaringClass() && args.length == 1 && Connection.class == args[0]) {
            if ("isWrapperFor".equals(mtdName)) {
                return true;
            }
            if ("unwrap".equals(mtdName)) {
                return this.delegate;
            }
        }
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                if ("close".equals(mtdName)) {
                    if (this.delegate == null) {
                        return this.close();
                    }
                    this.closeConnection(true);
                    return null;
                }
                if ("isClosed".equals(mtdName) && this.closed) {
                    return true;
                }
                if (this.delegate == null) {
                    this.newConnection();
                }
                return ManagedConnection.invoke(method, this.delegate, args);
            }
            if (this.currentTransaction != null && ManagedConnection.isUnderTransaction(this.currentTransaction.getStatus())) {
                if (!this.currentTransaction.equals(transaction)) {
                    throw new SQLException("Connection can not be used while enlisted in another transaction");
                }
                return this.invokeUnderTransaction(method, args);
            }
            int transactionStatus = transaction.getStatus();
            if (ManagedConnection.isUnderTransaction(transactionStatus)) {
                block30: {
                    Connection connection = (Connection)Connection.class.cast(this.registry.getResource((Object)this.key));
                    if (connection == null && this.delegate == null) {
                        this.newConnection();
                        this.currentTransaction = transaction;
                        try {
                            if (!transaction.enlistResource(this.getXAResource())) {
                                this.closeConnection(true);
                                throw new SQLException("Unable to enlist connection in transaction: enlistResource returns 'false'.");
                            }
                        }
                        catch (RollbackException rollbackException) {
                        }
                        catch (SystemException e) {
                            throw new SQLException("Unable to enlist connection the transaction", e);
                        }
                        this.registry.putResource((Object)this.key, proxy);
                        transaction.registerSynchronization((Synchronization)new ClosingSynchronization());
                        if (this.xaConnection == null) {
                            try {
                                this.setAutoCommit(false);
                            }
                            catch (SQLException xae) {
                                String message = "Can't set auto commit to false cause the XA datasource doesn't support it, this is likely an issue";
                                Logger logger = Logger.getInstance(LogCategory.OPENEJB_RESOURCE_JDBC, ManagedConnection.class);
                                if (logger.isDebugEnabled()) {
                                    logger.warning("Can't set auto commit to false cause the XA datasource doesn't support it, this is likely an issue", xae);
                                    break block30;
                                }
                                logger.warning("Can't set auto commit to false cause the XA datasource doesn't support it, this is likely an issue");
                            }
                        }
                    } else if (this.delegate == null) {
                        ManagedConnection managedConnection = (ManagedConnection)ManagedConnection.class.cast(Proxy.getInvocationHandler(connection));
                        this.delegate = managedConnection.delegate;
                        this.xaConnection = managedConnection.xaConnection;
                        this.xaResource = managedConnection.xaResource;
                    }
                }
                return this.invokeUnderTransaction(method, args);
            }
            if ("isClosed".equals(mtdName) && this.closed) {
                return true;
            }
            if ("close".equals(mtdName)) {
                return this.close();
            }
            if (this.delegate == null) {
                this.newConnection();
            }
            return ManagedConnection.invoke(method, this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private InvocationHandler unwrapHandler(Object arg) {
        if (arg == null || !Proxy.isProxyClass(arg.getClass())) {
            return null;
        }
        return Proxy.getInvocationHandler(arg);
    }

    private Object unwrapDelegate(Object arg, InvocationHandler handler) {
        return handler != null && ManagedConnection.class.isInstance(handler) ? ((ManagedConnection)ManagedConnection.class.cast((Object)handler)).delegate : arg;
    }

    protected Object newConnection() throws SQLException {
        Object connection;
        Object object = DataSource.class.isInstance(this.key.getDs()) ? (this.key.getUser() == null ? ((DataSource)DataSource.class.cast(this.key.getDs())).getConnection() : ((DataSource)DataSource.class.cast(this.key.getDs())).getConnection(this.key.getUser(), this.key.getPwd())) : (connection = this.key.getUser() == null ? ((XADataSource)XADataSource.class.cast(this.key.getDs())).getXAConnection() : ((XADataSource)XADataSource.class.cast(this.key.getDs())).getXAConnection(this.key.getUser(), this.key.getPwd()));
        if (XAConnection.class.isInstance(connection)) {
            this.xaConnection = (XAConnection)XAConnection.class.cast(connection);
            this.xaResource = this.xaConnection.getXAResource();
            this.delegate = this.xaConnection.getConnection();
        } else {
            this.delegate = (Connection)Connection.class.cast(connection);
            this.xaResource = new LocalXAResource(this.delegate);
        }
        return connection;
    }

    protected void setAutoCommit(boolean value) throws SQLException {
        if (this.delegate == null) {
            this.newConnection();
        }
        this.delegate.setAutoCommit(value);
    }

    private static Object invoke(Method method, Connection delegate, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    private Object invokeUnderTransaction(Method method, Object[] args) throws Exception {
        String mtdName = method.getName();
        if ("setAutoCommit".equals(mtdName) || "commit".equals(mtdName) || "rollback".equals(mtdName) || "setSavepoint".equals(mtdName) || "setReadOnly".equals(mtdName)) {
            throw ManagedConnection.forbiddenCall(mtdName);
        }
        if ("close".equals(mtdName)) {
            return this.close();
        }
        if ("isClosed".equals(mtdName) && this.closed) {
            return true;
        }
        return method.invoke((Object)this.delegate, args);
    }

    private Object close() {
        this.closed = true;
        return null;
    }

    public static boolean isUnderTransaction(int status) {
        return status == 0 || status == 1;
    }

    private static SQLException forbiddenCall(String mtdName) {
        return new SQLException("can't call " + mtdName + " when the connection is JtaManaged");
    }

    private void closeConnection(boolean force) {
        if (!force && this.closed) {
            return;
        }
        try {
            if (this.xaConnection != null) {
                this.xaConnection.close();
            } else if (this.delegate != null && !this.delegate.isClosed()) {
                this.delegate.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.close();
        }
    }

    private class ClosingSynchronization
    implements Synchronization {
        private ClosingSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ManagedConnection.this.closeConnection(true);
        }
    }
}

