/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.NamingException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProvider2;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.element.ListEntries;
import org.apache.myfaces.config.element.ListEntry;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.ManagedProperty;
import org.apache.myfaces.config.element.MapEntries;
import org.apache.myfaces.config.element.MapEntry;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.util.ContainerUtils;

public class ManagedBeanBuilder {
    private static Logger log = Logger.getLogger(ManagedBeanBuilder.class.getName());
    private RuntimeConfig _runtimeConfig;
    public static final String REQUEST = "request";
    public static final String VIEW = "view";
    public static final String APPLICATION = "application";
    public static final String SESSION = "session";
    public static final String NONE = "none";
    private static final Comparator<String> SCOPE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.equalsIgnoreCase(o2)) {
                return 0;
            }
            if (o1.equalsIgnoreCase(ManagedBeanBuilder.NONE)) {
                return 1;
            }
            if (o1.equalsIgnoreCase(ManagedBeanBuilder.APPLICATION)) {
                if (o2.equalsIgnoreCase(ManagedBeanBuilder.NONE)) {
                    return -1;
                }
                return 1;
            }
            if (o1.equalsIgnoreCase(ManagedBeanBuilder.SESSION)) {
                if (o2.equalsIgnoreCase(ManagedBeanBuilder.REQUEST) || o2.equalsIgnoreCase(ManagedBeanBuilder.VIEW)) {
                    return 1;
                }
                return -1;
            }
            if (o1.equalsIgnoreCase(ManagedBeanBuilder.VIEW)) {
                if (o2.equalsIgnoreCase(ManagedBeanBuilder.REQUEST)) {
                    return 1;
                }
                return -1;
            }
            if (o1.equalsIgnoreCase(ManagedBeanBuilder.REQUEST)) {
                return -1;
            }
            throw new IllegalArgumentException(o1 + " is not a valid scope");
        }
    };

    public Object buildManagedBean(FacesContext facesContext, ManagedBean beanConfiguration) throws FacesException {
        try {
            ExternalContext externalContext = facesContext.getExternalContext();
            LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory(externalContext).getLifecycleProvider(externalContext);
            Object bean = lifecycleProvider.newInstance(beanConfiguration.getManagedBeanClassName());
            switch (beanConfiguration.getInitMode()) {
                case 1: {
                    try {
                        this.initializeProperties(facesContext, beanConfiguration, bean);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(e.getMessage() + " for bean '" + beanConfiguration.getManagedBeanName() + "' check the configuration to make sure all properties " + "correspond with get/set methods", e);
                    }
                }
                case 2: {
                    if (!(bean instanceof Map)) {
                        throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a Map.");
                    }
                    this.initializeMap(facesContext, beanConfiguration.getMapEntries(), (Map)bean);
                    break;
                }
                case 3: {
                    if (!(bean instanceof List)) {
                        throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a List.");
                    }
                    this.initializeList(facesContext, beanConfiguration.getListEntries(), (List)bean);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown managed bean type " + bean.getClass().getName() + " for managed bean " + beanConfiguration.getManagedBeanName() + '.');
                }
            }
            if (lifecycleProvider instanceof LifecycleProvider2) {
                ((LifecycleProvider2)lifecycleProvider).postConstruct(bean);
            }
            return bean;
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FacesException((Throwable)e);
        }
        catch (NamingException e) {
            throw new FacesException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void initializeProperties(FacesContext facesContext, ManagedBean beanConfiguration, Object bean) {
        ELResolver elResolver = facesContext.getApplication().getELResolver();
        ELContext elContext = facesContext.getELContext();
        for (ManagedProperty managedProperty : beanConfiguration.getManagedProperties()) {
            Object value = null;
            switch (managedProperty.getType()) {
                case 4: {
                    if (PropertyUtils.isReadable((Object)bean, (String)managedProperty.getPropertyName())) {
                        value = elResolver.getValue(elContext, bean, (Object)managedProperty.getPropertyName());
                    }
                    Object object = value = value == null ? new ArrayList() : value;
                    if (value instanceof List) {
                        this.initializeList(facesContext, managedProperty.getListEntries(), (List)value);
                        break;
                    }
                    if (value != null && value.getClass().isArray()) {
                        int i;
                        int length = Array.getLength(value);
                        ArrayList<Object> temp = new ArrayList<Object>(length);
                        for (i = 0; i < length; ++i) {
                            temp.add(Array.get(value, i));
                        }
                        this.initializeList(facesContext, managedProperty.getListEntries(), temp);
                        value = Array.newInstance(value.getClass().getComponentType(), temp.size());
                        length = temp.size();
                        for (i = 0; i < length; ++i) {
                            Array.set(value, i, temp.get(i));
                        }
                        break;
                    }
                    value = new ArrayList();
                    this.initializeList(facesContext, managedProperty.getListEntries(), (List)value);
                    break;
                }
                case 1: {
                    if (PropertyUtils.isReadable((Object)bean, (String)managedProperty.getPropertyName())) {
                        value = elResolver.getValue(elContext, bean, (Object)managedProperty.getPropertyName());
                    }
                    Object object = value = value == null ? new HashMap() : value;
                    if (!(value instanceof Map)) {
                        value = new HashMap();
                    }
                    this.initializeMap(facesContext, managedProperty.getMapEntries(), (Map)value);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (!this.isInValidScope(facesContext, managedProperty, beanConfiguration)) {
                        throw new FacesException("Property " + managedProperty.getPropertyName() + " references object in a scope with shorter lifetime than the target scope " + beanConfiguration.getManagedBeanScope());
                    }
                    value = managedProperty.getRuntimeValue(facesContext);
                    break;
                }
                default: {
                    throw new FacesException("unknown ManagedProperty type: " + managedProperty.getType());
                }
            }
            Class propertyClass = null;
            propertyClass = managedProperty.getPropertyClass() == null ? elResolver.getType(elContext, bean, (Object)managedProperty.getPropertyName()) : ClassUtils.simpleJavaTypeToClass(managedProperty.getPropertyClass());
            if (null == propertyClass) {
                throw new IllegalArgumentException("unable to find the type of property " + managedProperty.getPropertyName());
            }
            Object coercedValue = ManagedBeanBuilder.coerceToType(facesContext, value, propertyClass);
            elResolver.setValue(elContext, bean, (Object)managedProperty.getPropertyName(), coercedValue);
        }
    }

    public static <T> T coerceToType(FacesContext facesContext, Object value, Class<? extends T> desiredClass) {
        if (value == null) {
            return null;
        }
        try {
            ExpressionFactory expFactory = facesContext.getApplication().getExpressionFactory();
            return (T)expFactory.coerceToType(value, desiredClass);
        }
        catch (ELException e) {
            String message = "Cannot coerce " + value.getClass().getName() + " to " + desiredClass.getName();
            log.log(Level.SEVERE, message, e);
            throw new FacesException(message, (Throwable)e);
        }
    }

    private boolean isInValidScope(FacesContext facesContext, ManagedProperty property, ManagedBean beanConfiguration) {
        if (!property.isValueReference()) {
            return true;
        }
        String targetScope = null;
        if (beanConfiguration.isManagedBeanScopeValueExpression()) {
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                return true;
            }
            targetScope = this.getNarrowestScope(facesContext, beanConfiguration.getManagedBeanScopeValueExpression(facesContext).getExpressionString());
            if (targetScope == null) {
                return true;
            }
        } else {
            targetScope = beanConfiguration.getManagedBeanScope();
            if (targetScope == null) {
                targetScope = NONE;
            }
        }
        if (targetScope.equalsIgnoreCase(REQUEST)) {
            return true;
        }
        String valueScope = this.getNarrowestScope(facesContext, property.getValueBinding(facesContext).getExpressionString());
        if (valueScope == null) {
            return true;
        }
        return SCOPE_COMPARATOR.compare(targetScope, valueScope) <= 0;
    }

    private String getNarrowestScope(FacesContext facesContext, String valueExpression) {
        List<String> expressions = this.extractExpressions(valueExpression);
        String narrowestScope = expressions.size() == 1 ? NONE : APPLICATION;
        boolean scopeFound = false;
        for (String expression : expressions) {
            String valueScope = this.getScope(facesContext, expression);
            if (valueScope == null) continue;
            scopeFound = true;
            if (SCOPE_COMPARATOR.compare(valueScope, narrowestScope) >= 0) continue;
            narrowestScope = valueScope;
        }
        return scopeFound ? narrowestScope : null;
    }

    private String getScope(FacesContext facesContext, String expression) {
        Map viewMap;
        String beanName = this.getFirstSegment(expression);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (beanName.equalsIgnoreCase("requestScope")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("sessionScope")) {
            return SESSION;
        }
        if (beanName.equalsIgnoreCase("applicationScope")) {
            return APPLICATION;
        }
        if (beanName.equalsIgnoreCase("cookie")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("facesContext")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("header")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("headerValues")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("param")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase("paramValues")) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase(REQUEST)) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase(VIEW)) {
            return REQUEST;
        }
        if (beanName.equalsIgnoreCase(APPLICATION)) {
            return APPLICATION;
        }
        if (beanName.equalsIgnoreCase("initParam")) {
            return APPLICATION;
        }
        boolean startup = externalContext instanceof StartupServletExternalContextImpl;
        if (!startup) {
            if (externalContext.getRequestMap().get(beanName) != null) {
                return REQUEST;
            }
            if (externalContext.getSessionMap().get(beanName) != null) {
                return SESSION;
            }
        }
        if (externalContext.getApplicationMap().get(beanName) != null) {
            return APPLICATION;
        }
        if (facesContext.getViewRoot() != null && (viewMap = facesContext.getViewRoot().getViewMap(!startup)) != null && viewMap.get(beanName) != null) {
            return VIEW;
        }
        ManagedBean mbc = this.getRuntimeConfig(facesContext).getManagedBean(beanName);
        if (mbc != null) {
            if (mbc.isManagedBeanScopeValueExpression()) {
                if (facesContext.isProjectStage(ProjectStage.Production)) {
                    return null;
                }
                String scopeExpression = mbc.getManagedBeanScopeValueExpression(facesContext).getExpressionString();
                return this.getNarrowestScope(facesContext, scopeExpression);
            }
            return mbc.getManagedBeanScope();
        }
        return null;
    }

    private String getFirstSegment(String expression) {
        int indexDot = expression.indexOf(46);
        int indexBracket = expression.indexOf(91);
        if (indexBracket < 0) {
            return indexDot < 0 ? expression : expression.substring(0, indexDot);
        }
        if (indexDot < 0) {
            return expression.substring(0, indexBracket);
        }
        return expression.substring(0, Math.min(indexDot, indexBracket));
    }

    private List<String> extractExpressions(String expressionString) {
        ArrayList<String> expressions = new ArrayList<String>();
        for (String expression : expressionString.split("\\#\\{")) {
            int index = expression.indexOf(125);
            if (index < 0) continue;
            expressions.add(expression.substring(0, index));
        }
        return expressions;
    }

    private void initializeMap(FacesContext facesContext, MapEntries mapEntries, Map<? super Object, ? super Object> map) {
        Application application = facesContext.getApplication();
        Class keyClass = mapEntries.getKeyClass() == null ? String.class : ClassUtils.simpleJavaTypeToClass(mapEntries.getKeyClass());
        Class valueClass = mapEntries.getValueClass() == null ? String.class : ClassUtils.simpleJavaTypeToClass(mapEntries.getValueClass());
        ExpressionFactory expFactory = application.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        Iterator<? extends MapEntry> iterator = mapEntries.getMapEntries();
        while (iterator.hasNext()) {
            ValueExpression valueExpression;
            MapEntry entry = iterator.next();
            Object key = entry.getKey();
            if (ContainerUtils.isValueReference((String)key)) {
                valueExpression = expFactory.createValueExpression(elContext, (String)key, Object.class);
                key = valueExpression.getValue(elContext);
            }
            if (entry.isNullValue()) {
                map.put(ManagedBeanBuilder.coerceToType(facesContext, key, keyClass), null);
                continue;
            }
            Object value = entry.getValue();
            if (ContainerUtils.isValueReference((String)value)) {
                valueExpression = expFactory.createValueExpression(elContext, (String)value, Object.class);
                value = valueExpression.getValue(elContext);
            }
            map.put(ManagedBeanBuilder.coerceToType(facesContext, key, keyClass), ManagedBeanBuilder.coerceToType(facesContext, value, valueClass));
        }
    }

    private void initializeList(FacesContext facesContext, ListEntries listEntries, List<? super Object> list) {
        Application application = facesContext.getApplication();
        Class valueClass = listEntries.getValueClass() == null ? String.class : ClassUtils.simpleJavaTypeToClass(listEntries.getValueClass());
        ExpressionFactory expFactory = application.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        Iterator<? extends ListEntry> iterator = listEntries.getListEntries();
        while (iterator.hasNext()) {
            ListEntry entry = iterator.next();
            if (entry.isNullValue()) {
                list.add(null);
                continue;
            }
            Object value = entry.getValue();
            if (ContainerUtils.isValueReference((String)value)) {
                ValueExpression valueExpression = expFactory.createValueExpression(elContext, (String)value, Object.class);
                value = valueExpression.getValue(elContext);
            }
            list.add(ManagedBeanBuilder.coerceToType(facesContext, value, valueClass));
        }
    }

    private RuntimeConfig getRuntimeConfig(FacesContext facesContext) {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this._runtimeConfig;
    }
}

