/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import org.apache.batchee.container.Controller;
import org.apache.batchee.container.ThreadRootController;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.ExecutionTransitioner;
import org.apache.batchee.container.impl.controller.chunk.ExceptionConfig;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ListenerFactory;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.apache.batchee.spi.PersistenceManagerService;

public abstract class JobThreadRootController
implements ThreadRootController {
    private static final Logger LOGGER = Logger.getLogger(JobThreadRootController.class.getName());
    protected final RuntimeJobExecution jobExecution;
    protected final JobContextImpl jobContext;
    protected final long rootJobExecutionId;
    protected final long jobInstanceId;
    private final ListenerFactory listenerFactory;
    protected final ModelNavigator<JSLJob> jobNavigator;
    protected final JobStatusManagerService jobStatusService;
    protected final PersistenceManagerService persistenceService;
    protected final ServicesManager manager;
    protected StepContextImpl parentStepContext = null;
    private ExecutionTransitioner transitioner;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;

    public JobThreadRootController(RuntimeJobExecution jobExecution, long rootJobExecutionId, ServicesManager servicesManager) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.rootJobExecutionId = rootJobExecutionId;
        this.jobInstanceId = jobExecution.getInstanceId();
        this.jobStatusService = servicesManager.service(JobStatusManagerService.class);
        this.persistenceService = servicesManager.service(PersistenceManagerService.class);
        this.jobNavigator = jobExecution.getJobNavigator();
        this.manager = servicesManager;
        JSLJob jobModel = jobExecution.getJobNavigator().getRootModelElement();
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        this.listenerFactory = new ListenerFactory(servicesManager.service(BatchArtifactFactory.class), jobModel, injectionRef, jobExecution);
        jobExecution.setListenerFactory(this.listenerFactory);
    }

    public JobThreadRootController(RuntimeJobExecution jobExecution, BlockingQueue<PartitionDataWrapper> analyzerQueue, ServicesManager servicesManager) {
        this(jobExecution, jobExecution.getExecutionId(), servicesManager);
        this.analyzerQueue = analyzerQueue;
    }

    @Override
    public ExecutionStatus originateExecutionOnThread() {
        ExecutionStatus retVal = null;
        try {
            if (!this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.markJobStarted();
                this.jobListenersBeforeJob();
                this.transitioner = new ExecutionTransitioner(this.jobExecution, this.rootJobExecutionId, this.jobNavigator, this.analyzerQueue, this.manager);
                this.transitioner.setParentStepContext(this.parentStepContext);
                retVal = this.transitioner.doExecutionLoop();
                ExtendedBatchStatus extBatchStatus = retVal.getExtendedBatchStatus();
                switch (extBatchStatus) {
                    case JSL_STOP: {
                        this.jslStop();
                        break;
                    }
                    case JSL_FAIL: {
                        this.updateJobBatchStatus(BatchStatus.FAILED);
                        break;
                    }
                    case EXCEPTION_THROWN: {
                        this.updateJobBatchStatus(BatchStatus.FAILED);
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            this.batchStatusFailedFromException();
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
        }
        this.endOfJob();
        return retVal;
    }

    protected void jslStop() {
        String restartOn = this.jobContext.getRestartOn();
        this.batchStatusStopping();
        this.jobStatusService.updateJobStatusFromJSLStop(this.jobInstanceId, restartOn);
    }

    protected void markJobStarted() {
        this.updateJobBatchStatus(BatchStatus.STARTED);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.jobExecution.setLastUpdateTime(timestamp);
        this.jobExecution.setStartTime(timestamp);
        this.persistenceService.markJobStarted(this.jobExecution.getExecutionId(), timestamp);
    }

    protected void endOfJob() {
        try {
            this.jobListenersAfterJob();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.batchStatusFailedFromException();
        }
        this.transitionToFinalBatchStatus();
        if (this.jobContext.getExitStatus() == null) {
            this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
        }
        this.persistJobBatchAndExitStatus();
    }

    private void persistJobBatchAndExitStatus() {
        BatchStatus batchStatus = this.jobContext.getBatchStatus();
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.jobStatusService.updateJobBatchStatus(this.jobInstanceId, batchStatus);
        this.jobStatusService.updateJobExecutionStatus(this.jobExecution.getInstanceId(), this.jobContext.getBatchStatus(), this.jobContext.getExitStatus());
        if (!(batchStatus.equals((Object)BatchStatus.COMPLETED) || batchStatus.equals((Object)BatchStatus.STOPPED) || batchStatus.equals((Object)BatchStatus.FAILED))) {
            throw new IllegalStateException("Not expected to encounter batchStatus of " + batchStatus + " at this point.  Aborting.");
        }
        this.jobExecution.setEndTime(timestamp);
        this.persistenceService.updateWithFinalExecutionStatusesAndTimestamps(this.jobExecution.getExecutionId(), batchStatus, this.jobContext.getExitStatus(), timestamp);
    }

    private void transitionToFinalBatchStatus() {
        BatchStatus currentBatchStatus = this.jobContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
            this.updateJobBatchStatus(BatchStatus.COMPLETED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
            this.updateJobBatchStatus(BatchStatus.STOPPED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
            this.updateJobBatchStatus(BatchStatus.FAILED);
        } else {
            throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
        }
    }

    protected void updateJobBatchStatus(BatchStatus batchStatus) {
        this.jobContext.setBatchStatus(batchStatus);
    }

    protected void batchStatusStopping() {
        this.updateJobBatchStatus(BatchStatus.STOPPING);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.jobExecution.setLastUpdateTime(timestamp);
        this.persistenceService.updateBatchStatusOnly(this.jobExecution.getExecutionId(), BatchStatus.STOPPING, timestamp);
    }

    @Override
    public void stop() {
        if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTING) || this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTED)) {
            Controller stoppableElementController;
            this.batchStatusStopping();
            if (this.transitioner != null && (stoppableElementController = this.transitioner.getCurrentStoppableElementController()) != null) {
                stoppableElementController.stop();
            }
        }
    }

    protected void jobListenersBeforeJob() {
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        List<JobListener> jobListeners = this.listenerFactory.getJobListeners(injectionRef);
        for (JobListener listenerProxy : jobListeners) {
            try {
                listenerProxy.beforeJob();
            }
            catch (Exception e) {
                ExceptionConfig.wrapBatchException(e);
            }
        }
    }

    private void jobListenersAfterJob() {
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        List<JobListener> jobListeners = this.listenerFactory.getJobListeners(injectionRef);
        for (JobListener listenerProxy : jobListeners) {
            try {
                listenerProxy.afterJob();
            }
            catch (Exception e) {
                ExceptionConfig.wrapBatchException(e);
            }
        }
    }

    protected void batchStatusFailedFromException() {
        this.updateJobBatchStatus(BatchStatus.FAILED);
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        return this.transitioner.getStepExecIds();
    }

    @Override
    public void setParentStepContext(StepContextImpl parentStepContext) {
        this.parentStepContext = parentStepContext;
    }
}

