/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import javax.json.JsonNumber;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import org.apache.johnzon.mapper.JohnzonReaderHandler;

public class ReaderHandler {
    private final boolean johnzon;

    private ReaderHandler(boolean johnzon) {
        this.johnzon = johnzon;
    }

    public static ReaderHandler create(JsonReaderFactory readerFactory) {
        if (readerFactory.getClass().getName().equals("org.apache.johnzon.core.JsonReaderFactoryImpl")) {
            return new ReaderHandler(true);
        }
        return new ReaderHandler(false);
    }

    public JsonValue read(JsonReader reader) {
        if (this.johnzon) {
            return JohnzonReaderHandler.read(reader);
        }
        return reader.read();
    }

    public boolean isJsonLong(JsonNumber number) {
        if (this.johnzon) {
            return JohnzonReaderHandler.isLong(number);
        }
        return false;
    }
}

