/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.executor;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.util.ClassLoaderAwareHandler;
import org.apache.batchee.spi.BatchThreadPoolService;

public abstract class AbstractThreadPoolService
implements BatchThreadPoolService {
    protected ExecutorService executorService;

    protected abstract ExecutorService newExecutorService(Properties var1);

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
        this.executorService = this.newExecutorService(batchConfig);
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        this.executorService.shutdownNow();
        this.executorService = null;
    }

    @Override
    public void executeTask(Runnable work, Object config) {
        this.executorService.execute(ClassLoaderAwareHandler.runnableLoaderAware(work));
    }

    public String toString() {
        return this.getClass().getName();
    }
}

