/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(BasicDataSourceFactory.class);
    private static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    private static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    private static final String PROP_CACHESTATE = "cacheState";
    private static final String PROP_DRIVERCLASSNAME = "driverClassName";
    private static final String PROP_LIFO = "lifo";
    private static final String PROP_MAXTOTAL = "maxTotal";
    private static final String PROP_MAXIDLE = "maxIdle";
    private static final String PROP_MINIDLE = "minIdle";
    private static final String PROP_INITIALSIZE = "initialSize";
    private static final String PROP_MAXWAITMILLIS = "maxWaitMillis";
    private static final String PROP_TESTONCREATE = "testOnCreate";
    private static final String PROP_TESTONBORROW = "testOnBorrow";
    private static final String PROP_TESTONRETURN = "testOnReturn";
    private static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    private static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_SOFTMINEVICTABLEIDLETIMEMILLIS = "softMinEvictableIdleTimeMillis";
    private static final String PROP_EVICTIONPOLICYCLASSNAME = "evictionPolicyClassName";
    private static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_VALIDATIONQUERY = "validationQuery";
    private static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    private static final String PROP_JMX_NAME = "jmxName";
    private static final String PROP_CONNECTIONINITSQLS = "connectionInitSqls";
    private static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVEABANDONEDONBORROW = "removeAbandonedOnBorrow";
    private static final String PROP_REMOVEABANDONEDONMAINTENANCE = "removeAbandonedOnMaintenance";
    private static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOGABANDONED = "logAbandoned";
    private static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    private static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    private static final String PROP_MAXCONNLIFETIMEMILLIS = "maxConnLifetimeMillis";
    private static final String PROP_LOGEXPIREDCONNECTIONS = "logExpiredConnections";
    private static final String PROP_ROLLBACK_ON_RETURN = "rollbackOnReturn";
    private static final String PROP_ENABLE_AUTOCOMMIT_ON_RETURN = "enableAutoCommitOnReturn";
    private static final String PROP_DEFAULT_QUERYTIMEOUT = "defaultQueryTimeout";
    private static final String PROP_FASTFAIL_VALIDATION = "fastFailValidation";
    private static final String PROP_DISCONNECTION_SQL_CODES = "disconnectionSqlCodes";
    private static final String NUPROP_MAXACTIVE = "maxActive";
    private static final String NUPROP_REMOVEABANDONED = "removeAbandoned";
    private static final String NUPROP_MAXWAIT = "maxWait";
    private static final String SILENTPROP_FACTORY = "factory";
    private static final String SILENTPROP_SCOPE = "scope";
    private static final String SILENTPROP_SINGLETON = "singleton";
    private static final String SILENTPROP_AUTH = "auth";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "cacheState", "driverClassName", "lifo", "maxTotal", "maxIdle", "minIdle", "initialSize", "maxWaitMillis", "testOnCreate", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "softMinEvictableIdleTimeMillis", "evictionPolicyClassName", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "connectionInitSqls", "accessToUnderlyingConnectionAllowed", "removeAbandonedOnBorrow", "removeAbandonedOnMaintenance", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties", "maxConnLifetimeMillis", "logExpiredConnections", "rollbackOnReturn", "enableAutoCommitOnReturn", "defaultQueryTimeout", "fastFailValidation", "disconnectionSqlCodes"};
    private static final Map<String, String> NUPROP_WARNTEXT = new LinkedHashMap<String, String>();
    private static final List<String> SILENT_PROPERTIES;

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<String> infoMessages = new ArrayList<String>();
        this.validatePropertyNames(ref, name, warnings, infoMessages);
        for (String warning : warnings) {
            log.warn((Object)warning);
        }
        for (String infoMessage : infoMessages) {
            log.info((Object)infoMessage);
        }
        Properties properties = new Properties();
        for (String propertyName : ALL_PROPERTIES) {
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return BasicDataSourceFactory.createDataSource(properties);
    }

    private void validatePropertyNames(Reference ref, Name name, List<String> warnings, List<String> infoMessages) {
        String nameString;
        List<String> allPropsAsList = Arrays.asList(ALL_PROPERTIES);
        String string = nameString = name != null ? "Name = " + name.toString() + " " : "";
        if (NUPROP_WARNTEXT != null && !NUPROP_WARNTEXT.keySet().isEmpty()) {
            for (String propertyName : NUPROP_WARNTEXT.keySet()) {
                RefAddr ra = ref.get(propertyName);
                if (ra == null || allPropsAsList.contains(ra.getType())) continue;
                StringBuilder stringBuilder = new StringBuilder(nameString);
                String propertyValue = ra.getContent().toString();
                stringBuilder.append(NUPROP_WARNTEXT.get(propertyName)).append(" You have set value of \"").append(propertyValue).append("\" for \"").append(propertyName).append("\" property, which is being ignored.");
                warnings.add(stringBuilder.toString());
            }
        }
        Enumeration<RefAddr> allRefAddrs = ref.getAll();
        while (allRefAddrs.hasMoreElements()) {
            RefAddr ra = allRefAddrs.nextElement();
            String propertyName = ra.getType();
            if (allPropsAsList.contains(propertyName) || NUPROP_WARNTEXT.keySet().contains(propertyName) || SILENT_PROPERTIES.contains(propertyName)) continue;
            String propertyValue = ra.getContent().toString();
            StringBuilder stringBuilder = new StringBuilder(nameString);
            stringBuilder.append("Ignoring unknown property: ").append("value of \"").append(propertyValue).append("\" for \"").append(propertyName).append("\" property");
            infoMessages.add(stringBuilder.toString());
        }
    }

    public static BasicDataSource createDataSource(Properties properties) throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        String value = null;
        value = properties.getProperty(PROP_DEFAULTAUTOCOMMIT);
        if (value != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTREADONLY)) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTTRANSACTIONISOLATION)) != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + value);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((value = properties.getProperty(PROP_DEFAULTCATALOG)) != null) {
            dataSource.setDefaultCatalog(value);
        }
        if ((value = properties.getProperty(PROP_CACHESTATE)) != null) {
            dataSource.setCacheState(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DRIVERCLASSNAME)) != null) {
            dataSource.setDriverClassName(value);
        }
        if ((value = properties.getProperty(PROP_LIFO)) != null) {
            dataSource.setLifo(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAXTOTAL)) != null) {
            dataSource.setMaxTotal(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXIDLE)) != null) {
            dataSource.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINIDLE)) != null) {
            dataSource.setMinIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITIALSIZE)) != null) {
            dataSource.setInitialSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXWAITMILLIS)) != null) {
            dataSource.setMaxWaitMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TESTONCREATE)) != null) {
            dataSource.setTestOnCreate(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TESTONBORROW)) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TESTONRETURN)) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            dataSource.setMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_SOFTMINEVICTABLEIDLETIMEMILLIS)) != null) {
            dataSource.setSoftMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_EVICTIONPOLICYCLASSNAME)) != null) {
            dataSource.setEvictionPolicyClassName(value);
        }
        if ((value = properties.getProperty(PROP_TESTWHILEIDLE)) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_PASSWORD)) != null) {
            dataSource.setPassword(value);
        }
        if ((value = properties.getProperty(PROP_URL)) != null) {
            dataSource.setUrl(value);
        }
        if ((value = properties.getProperty(PROP_USERNAME)) != null) {
            dataSource.setUsername(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY)) != null) {
            dataSource.setValidationQuery(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY_TIMEOUT)) != null) {
            dataSource.setValidationQueryTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONEDONBORROW)) != null) {
            dataSource.setRemoveAbandonedOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONEDONMAINTENANCE)) != null) {
            dataSource.setRemoveAbandonedOnMaintenance(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONEDTIMEOUT)) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_LOGABANDONED)) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            dataSource.setPoolPreparedStatements(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
            dataSource.setMaxOpenPreparedStatements(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONINITSQLS)) != null) {
            dataSource.setConnectionInitSqls(BasicDataSourceFactory.parseList(value, ';'));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONPROPERTIES)) != null) {
            Properties p = BasicDataSourceFactory.getProperties(value);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                dataSource.addConnectionProperty(propertyName, p.getProperty(propertyName));
            }
        }
        if ((value = properties.getProperty(PROP_MAXCONNLIFETIMEMILLIS)) != null) {
            dataSource.setMaxConnLifetimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_LOGEXPIREDCONNECTIONS)) != null) {
            dataSource.setLogExpiredConnections(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_JMX_NAME)) != null) {
            dataSource.setJmxName(value);
        }
        if ((value = properties.getProperty(PROP_ENABLE_AUTOCOMMIT_ON_RETURN)) != null) {
            dataSource.setEnableAutoCommitOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_ROLLBACK_ON_RETURN)) != null) {
            dataSource.setRollbackOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULT_QUERYTIMEOUT)) != null) {
            dataSource.setDefaultQueryTimeout(Integer.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_FASTFAIL_VALIDATION)) != null) {
            dataSource.setFastFailValidation(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DISCONNECTION_SQL_CODES)) != null) {
            dataSource.setDisconnectionSqlCodes(BasicDataSourceFactory.parseList(value, ','));
        }
        if (dataSource.getInitialSize() > 0) {
            dataSource.getLogWriter();
        }
        return dataSource;
    }

    private static Properties getProperties(String propText) throws Exception {
        Properties p = new Properties();
        if (propText != null) {
            p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes(StandardCharsets.ISO_8859_1)));
        }
        return p;
    }

    private static Collection<String> parseList(String value, char delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(value, Character.toString(delimiter));
        ArrayList<String> tokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    static {
        NUPROP_WARNTEXT.put(NUPROP_MAXACTIVE, "Property maxActive is not used in DBCP2, use maxTotal instead. maxTotal default value is 8.");
        NUPROP_WARNTEXT.put(NUPROP_REMOVEABANDONED, "Property removeAbandoned is not used in DBCP2, use one or both of removeAbandonedOnBorrow or removeAbandonedOnMaintenance instead. Both have default value set to false.");
        NUPROP_WARNTEXT.put(NUPROP_MAXWAIT, "Property maxWait is not used in DBCP2 , use maxWaitMillis instead. maxWaitMillis default value is -1.");
        SILENT_PROPERTIES = new ArrayList<String>();
        SILENT_PROPERTIES.add(SILENTPROP_FACTORY);
        SILENT_PROPERTIES.add(SILENTPROP_SCOPE);
        SILENT_PROPERTIES.add(SILENTPROP_SINGLETON);
        SILENT_PROPERTIES.add(SILENTPROP_AUTH);
    }
}

