/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.BaseContextMap;
import com.sun.faces.context.ExternalContextImpl;
import com.sun.faces.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;

public class RequestParameterMap
extends BaseContextMap<String> {
    private String namingContainerId;
    private final boolean namespaceParameters;
    private final ServletRequest request;
    private boolean inspectedParameterNames = false;

    public RequestParameterMap(ServletRequest request) {
        this.request = request;
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.namespaceParameters = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    @Override
    public String get(Object key) {
        Util.notNull("key", key);
        if (!this.inspectedParameterNames) {
            this.inspectedParameterNames = true;
            this.request.getParameterNames();
        }
        String mapKey = key.toString();
        String mapValue = null;
        if (this.namespaceParameters) {
            mapValue = this.request.getParameter(this.getNamingContainerId() + mapKey);
        }
        if (mapValue == null) {
            mapValue = this.request.getParameter(mapKey);
        }
        return mapValue;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    protected String getNamingContainerId() {
        if (null == this.namingContainerId) {
            FacesContext context = FacesContext.getCurrentInstance();
            UIViewRoot viewRoot = context.getViewRoot();
            if (viewRoot == null) {
                Application application = context.getApplication();
                viewRoot = (UIViewRoot)application.createComponent("javax.faces.ViewRoot");
            }
            this.namingContainerId = viewRoot instanceof NamingContainer ? viewRoot.getContainerClientId(context) : "";
        }
        return this.namingContainerId;
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public boolean containsKey(Object key) {
        boolean containsKey = false;
        String mapKey = key.toString();
        if (this.namespaceParameters) {
            boolean bl = containsKey = this.request.getParameter(this.getNamingContainerId() + mapKey) != null;
        }
        if (!containsKey) {
            containsKey = this.request.getParameter(mapKey) != null;
        }
        return containsKey;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ExternalContextImpl.theUnmodifiableMapClass && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.request.hashCode();
        Iterator<Map.Entry<String, String>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += ((Object)i.next()).hashCode();
        }
        return hashCode;
    }

    @Override
    protected Iterator<Map.Entry<String, String>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this, this.request.getParameterNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this, this.request.getParameterNames());
    }

    @Override
    protected Iterator<String> getValueIterator() {
        return new BaseContextMap.ValueIterator(this, this.request.getParameterNames());
    }
}

