/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ejb.EJBLocalObject;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.core.cmp.CmpUtil;
import org.apache.openejb.jee.CmpField;
import org.apache.openejb.jee.CmpVersion;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbRelation;
import org.apache.openejb.jee.EjbRelationshipRole;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.Multiplicity;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.Query;
import org.apache.openejb.jee.RelationshipRoleSource;
import org.apache.openejb.jee.Relationships;
import org.apache.openejb.jee.jpa.AttributeOverride;
import org.apache.openejb.jee.jpa.Attributes;
import org.apache.openejb.jee.jpa.Basic;
import org.apache.openejb.jee.jpa.CascadeType;
import org.apache.openejb.jee.jpa.Entity;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.GeneratedValue;
import org.apache.openejb.jee.jpa.GenerationType;
import org.apache.openejb.jee.jpa.Id;
import org.apache.openejb.jee.jpa.IdClass;
import org.apache.openejb.jee.jpa.ManyToMany;
import org.apache.openejb.jee.jpa.ManyToOne;
import org.apache.openejb.jee.jpa.MappedSuperclass;
import org.apache.openejb.jee.jpa.Mapping;
import org.apache.openejb.jee.jpa.NamedQuery;
import org.apache.openejb.jee.jpa.OneToMany;
import org.apache.openejb.jee.jpa.OneToOne;
import org.apache.openejb.jee.jpa.RelationField;
import org.apache.openejb.jee.jpa.Transient;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.TransactionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.QueryMethod;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Strings;
import org.apache.xbean.finder.ResourceFinder;

class CmpJpaConversion
implements DynamicDeployer {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, CmpJpaConversion.class);
    private static final String CMP_PERSISTENCE_UNIT_NAME = "cmp";
    private static final Set<String> ENHANCED_FIELDS = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("pcInheritedFieldCount", "pcFieldNames", "pcFieldTypes", "pcFieldFlags", "pcPCSuperclass", "pcStateManager", "class$Ljava$lang$String", "class$Ljava$lang$Integer", "class$Lcom$sun$ts$tests$common$ejb$wrappers$CMP11Wrapper", "pcDetachedState", "serialVersionUID")));
    public static final String GENERATED_ORM_XML = "META-INF/openejb-cmp-generated-orm.xml";

    CmpJpaConversion() {
    }

    private static EntityMappings readEntityMappings(String location, AppModule appModule) {
        try {
            URL url = new ResourceFinder("", appModule.getClassLoader()).getResource(location);
            if (url == null) {
                return null;
            }
            return (EntityMappings)JaxbJavaee.unmarshal(EntityMappings.class, (InputStream)IO.read(url));
        }
        catch (Exception exp) {
            LOGGER.error("Unable to read entity mappings from " + location, exp);
            return null;
        }
    }

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        if (!this.hasCmpEntities(appModule)) {
            return appModule;
        }
        EntityMappings cmpMappings = appModule.getCmpMappings();
        if (cmpMappings == null) {
            cmpMappings = new EntityMappings();
            cmpMappings.setVersion("1.0");
            appModule.setCmpMappings(cmpMappings);
        }
        HashSet<String> definedMappedClasses = new HashSet<String>();
        PersistenceUnit cmpPersistenceUnit = this.findCmpPersistenceUnit(appModule);
        if (cmpPersistenceUnit != null && cmpPersistenceUnit.getMappingFile() != null && cmpPersistenceUnit.getMappingFile().size() > 0) {
            for (String mappingFile : cmpPersistenceUnit.getMappingFile()) {
                EntityMappings entityMappings = CmpJpaConversion.readEntityMappings(mappingFile, appModule);
                if (entityMappings == null) continue;
                definedMappedClasses.addAll(entityMappings.getEntityMap().keySet());
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
                if (!CmpJpaConversion.isCmpEntity(enterpriseBean)) continue;
                this.processEntityBean(ejbModule, definedMappedClasses, cmpMappings, (EntityBean)enterpriseBean);
            }
            Relationships relationships = ejbJar.getRelationships();
            if (relationships != null) {
                TreeMap<String, Entity> entitiesByEjbName = new TreeMap<String, Entity>();
                for (Entity entity : cmpMappings.getEntity()) {
                    entitiesByEjbName.put(entity.getEjbName(), entity);
                }
                for (EjbRelation relation : relationships.getEjbRelation()) {
                    this.processRelationship(entitiesByEjbName, relation);
                }
            }
            EntityMappings userMappings = this.getUserEntityMappings(ejbModule);
            for (Entity mapping : userMappings.getEntity()) {
                LOGGER.warning("openejb-cmp-orm.xml mapping ignored: module=" + ejbModule.getModuleId() + ":  <entity class=\"" + mapping.getClazz() + "\">");
            }
            for (Entity mapping : userMappings.getMappedSuperclass()) {
                LOGGER.warning("openejb-cmp-orm.xml mapping ignored: module=" + ejbModule.getModuleId() + ":  <mapped-superclass class=\"" + mapping.getClazz() + "\">");
            }
        }
        if (!cmpMappings.getEntity().isEmpty()) {
            boolean generatedOrmXmlProvided;
            PersistenceUnit persistenceUnit = this.getCmpPersistenceUnit(appModule);
            boolean bl = generatedOrmXmlProvided = appModule.getClassLoader().getResource(GENERATED_ORM_XML) != null;
            if (!persistenceUnit.getMappingFile().contains(GENERATED_ORM_XML)) {
                if (generatedOrmXmlProvided) {
                    LOGGER.warning("App module " + appModule.getModuleId() + " provides " + GENERATED_ORM_XML + ", but does not specify it using <mapping-file> in persistence.xml for the CMP persistence unit, and it may conflict with the generated mapping file. Consider renaming the file and explicitly referencing it in persistence.xml");
                }
                persistenceUnit.getMappingFile().add(GENERATED_ORM_XML);
            } else if (generatedOrmXmlProvided) {
                LOGGER.warning("App module " + appModule.getModuleId() + " provides " + GENERATED_ORM_XML + " and additionally " + cmpMappings.getEntity().size() + "mappings have been generated. Consider renaming the " + GENERATED_ORM_XML + " in your deployment archive to avoid any conflicts.");
            }
            for (Entity entity : cmpMappings.getEntity()) {
                if (persistenceUnit.getClazz().contains(entity.getClazz())) continue;
                persistenceUnit.getClazz().add(entity.getClazz());
            }
        }
        for (Entity entity : appModule.getCmpMappings().getEntity()) {
            if (entity.getAttributes() == null || !entity.getAttributes().isEmpty()) continue;
            entity.setAttributes(null);
        }
        return appModule;
    }

    private PersistenceUnit getCmpPersistenceUnit(AppModule appModule) {
        PersistenceUnit persistenceUnit = this.findCmpPersistenceUnit(appModule);
        if (persistenceUnit == null) {
            persistenceUnit = new PersistenceUnit();
            persistenceUnit.setName(CMP_PERSISTENCE_UNIT_NAME);
            persistenceUnit.setTransactionType(TransactionType.JTA);
            Properties properties = new Properties();
            String property = SystemInstance.get().getProperty("openejb.cmp.openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true, Indexes=false, IgnoreErrors=true)");
            if (property != null && !property.isEmpty()) {
                properties.setProperty("openjpa.jdbc.SynchronizeMappings", property);
            }
            properties.setProperty("openjpa.Log", "DefaultLevel=INFO");
            persistenceUnit.setProperties(properties);
            Persistence persistence = new Persistence();
            persistence.setVersion("1.0");
            persistence.getPersistenceUnit().add(persistenceUnit);
            PersistenceModule persistenceModule = new PersistenceModule(appModule, this.getPersistenceModuleId(appModule), persistence);
            appModule.addPersistenceModule(persistenceModule);
        }
        return persistenceUnit;
    }

    private PersistenceUnit findCmpPersistenceUnit(AppModule appModule) {
        PersistenceUnit persistenceUnit = null;
        block0: for (PersistenceModule persistenceModule : appModule.getPersistenceModules()) {
            Persistence persistence = persistenceModule.getPersistence();
            for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                if (!CMP_PERSISTENCE_UNIT_NAME.equals(unit.getName())) continue;
                persistenceUnit = unit;
                continue block0;
            }
        }
        return persistenceUnit;
    }

    private String getPersistenceModuleId(AppModule appModule) {
        if (appModule.getModuleId() != null) {
            return appModule.getModuleUri() != null ? appModule.getModuleUri().toString() : appModule.getModuleId();
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            if (ejbModule.getModuleId() == null) continue;
            return ejbModule.getModuleUri() != null ? ejbModule.getModuleUri().toString() : ejbModule.getModuleId();
        }
        throw new IllegalStateException("Comp must be in an ejb module, this one has none: " + appModule);
    }

    private boolean hasCmpEntities(AppModule appModule) {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                if (!CmpJpaConversion.isCmpEntity(bean)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCmpEntity(EnterpriseBean bean) {
        return bean instanceof EntityBean && ((EntityBean)bean).getPersistenceType() == PersistenceType.CONTAINER;
    }

    private void processRelationship(Map<String, Entity> entitiesByEjbName, EjbRelation relation) throws OpenEJBException {
        boolean rightIsOne;
        List roles = relation.getEjbRelationshipRole();
        if (roles.size() != 2) {
            return;
        }
        EjbRelationshipRole leftRole = (EjbRelationshipRole)roles.get(0);
        RelationshipRoleSource leftRoleSource = leftRole.getRelationshipRoleSource();
        String leftEjbName = leftRoleSource == null ? null : leftRoleSource.getEjbName();
        Entity leftEntity = entitiesByEjbName.get(leftEjbName);
        EjbRelationshipRole rightRole = (EjbRelationshipRole)roles.get(1);
        RelationshipRoleSource rightRoleSource = rightRole.getRelationshipRoleSource();
        String rightEjbName = rightRoleSource == null ? null : rightRoleSource.getEjbName();
        Entity rightEntity = entitiesByEjbName.get(rightEjbName);
        if (leftEntity == null && rightEntity == null) {
            return;
        }
        if (leftEntity == null) {
            throw new OpenEJBException("Role source " + leftEjbName + " defined in relationship role " + relation.getEjbRelationName() + "::" + leftRole.getEjbRelationshipRoleName() + " not found");
        }
        if (rightEntity == null) {
            throw new OpenEJBException("Role source " + rightEjbName + " defined in relationship role " + relation.getEjbRelationName() + "::" + rightRole.getEjbRelationshipRoleName() + " not found");
        }
        Attributes rightAttributes = rightEntity.getAttributes();
        Map rightRelationships = rightAttributes.getRelationshipFieldMap();
        Attributes leftAttributes = leftEntity.getAttributes();
        Map leftRelationships = leftAttributes.getRelationshipFieldMap();
        String leftFieldName = null;
        boolean leftSynthetic = false;
        if (leftRole.getCmrField() != null) {
            leftFieldName = leftRole.getCmrField().getCmrFieldName();
        } else {
            leftFieldName = rightEntity.getName() + "_" + rightRole.getCmrField().getCmrFieldName();
            leftSynthetic = true;
        }
        boolean leftIsOne = leftRole.getMultiplicity() == Multiplicity.ONE;
        String rightFieldName = null;
        boolean rightSynthetic = false;
        if (rightRole.getCmrField() != null) {
            rightFieldName = rightRole.getCmrField().getCmrFieldName();
        } else {
            rightFieldName = leftEntity.getName() + "_" + leftRole.getCmrField().getCmrFieldName();
            rightSynthetic = true;
        }
        boolean bl = rightIsOne = rightRole.getMultiplicity() == Multiplicity.ONE;
        if (leftIsOne && rightIsOne) {
            OneToOne leftOneToOne = null;
            leftOneToOne = new OneToOne();
            leftOneToOne.setName(leftFieldName);
            leftOneToOne.setSyntheticField(leftSynthetic);
            this.setCascade(rightRole, (RelationField)leftOneToOne);
            this.addRelationship(leftOneToOne, leftRelationships, leftAttributes.getOneToOne());
            OneToOne rightOneToOne = null;
            rightOneToOne = new OneToOne();
            rightOneToOne.setName(rightFieldName);
            rightOneToOne.setSyntheticField(rightSynthetic);
            rightOneToOne.setMappedBy(leftFieldName);
            this.setCascade(leftRole, (RelationField)rightOneToOne);
            this.addRelationship(rightOneToOne, rightRelationships, rightAttributes.getOneToOne());
            leftOneToOne.setRelatedField((RelationField)rightOneToOne);
            rightOneToOne.setRelatedField((RelationField)leftOneToOne);
        } else if (leftIsOne && !rightIsOne) {
            OneToMany leftOneToMany = null;
            leftOneToMany = new OneToMany();
            leftOneToMany.setName(leftFieldName);
            leftOneToMany.setSyntheticField(leftSynthetic);
            leftOneToMany.setMappedBy(rightFieldName);
            this.setCascade(rightRole, (RelationField)leftOneToMany);
            this.addRelationship(leftOneToMany, leftRelationships, leftAttributes.getOneToMany());
            ManyToOne rightManyToOne = null;
            rightManyToOne = new ManyToOne();
            rightManyToOne.setName(rightFieldName);
            rightManyToOne.setSyntheticField(rightSynthetic);
            this.setCascade(leftRole, (RelationField)rightManyToOne);
            this.addRelationship(rightManyToOne, rightRelationships, rightAttributes.getManyToOne());
            leftOneToMany.setRelatedField((RelationField)rightManyToOne);
            rightManyToOne.setRelatedField((RelationField)leftOneToMany);
        } else if (!leftIsOne && rightIsOne) {
            ManyToOne leftManyToOne = null;
            leftManyToOne = new ManyToOne();
            leftManyToOne.setName(leftFieldName);
            leftManyToOne.setSyntheticField(leftSynthetic);
            this.setCascade(rightRole, (RelationField)leftManyToOne);
            this.addRelationship(leftManyToOne, leftRelationships, leftAttributes.getManyToOne());
            OneToMany rightOneToMany = null;
            rightOneToMany = new OneToMany();
            rightOneToMany.setName(rightFieldName);
            rightOneToMany.setSyntheticField(rightSynthetic);
            rightOneToMany.setMappedBy(leftFieldName);
            this.setCascade(leftRole, (RelationField)rightOneToMany);
            this.addRelationship(rightOneToMany, rightRelationships, rightAttributes.getOneToMany());
            leftManyToOne.setRelatedField((RelationField)rightOneToMany);
            rightOneToMany.setRelatedField((RelationField)leftManyToOne);
        } else if (!leftIsOne && !rightIsOne) {
            ManyToMany leftManyToMany = null;
            leftManyToMany = new ManyToMany();
            leftManyToMany.setName(leftFieldName);
            leftManyToMany.setSyntheticField(leftSynthetic);
            this.setCascade(rightRole, (RelationField)leftManyToMany);
            this.addRelationship(leftManyToMany, leftRelationships, leftAttributes.getManyToMany());
            ManyToMany rightManyToMany = null;
            rightManyToMany = new ManyToMany();
            rightManyToMany.setName(rightFieldName);
            rightManyToMany.setSyntheticField(rightSynthetic);
            rightManyToMany.setMappedBy(leftFieldName);
            this.setCascade(leftRole, (RelationField)rightManyToMany);
            this.addRelationship(rightManyToMany, rightRelationships, rightAttributes.getManyToMany());
            leftManyToMany.setRelatedField((RelationField)rightManyToMany);
            rightManyToMany.setRelatedField((RelationField)leftManyToMany);
        }
    }

    private <R extends RelationField> R addRelationship(R relationship, Map<String, RelationField> existing, List<R> relationships) {
        Object r = null;
        try {
            r = existing.get(relationship.getKey());
        }
        catch (ClassCastException e) {
            return relationship;
        }
        if (r == null) {
            r = relationship;
            relationships.add(relationship);
        }
        return (R)r;
    }

    private void processEntityBean(EjbModule ejbModule, Collection<String> ignoreClasses, EntityMappings entityMappings, EntityBean bean) {
        if (!this.addPersistenceContextRef(bean)) {
            return;
        }
        Class ejbClass = CmpJpaConversion.loadClass(ejbModule.getClassLoader(), bean.getEjbClass());
        String jpaEntityClassName = CmpUtil.getCmpImplClassName(bean.getAbstractSchemaName(), ejbClass.getName());
        EntityMappings userMappings = this.getUserEntityMappings(ejbModule);
        for (Class clazz = ejbClass; clazz != null; clazz = clazz.getSuperclass()) {
            MappedSuperclass mappedSuperclass = this.removeMappedSuperclass(userMappings, clazz.getName());
            if (mappedSuperclass == null) continue;
            entityMappings.getMappedSuperclass().add(mappedSuperclass);
        }
        if (ignoreClasses.contains(jpaEntityClassName)) {
            return;
        }
        Entity entity = this.removeEntity(userMappings, jpaEntityClassName);
        if (entity != null) {
            entity.setXmlMetadataComplete(true);
            entityMappings.getEntity().add(entity);
            return;
        }
        if (entity == null) {
            entity = new Entity(jpaEntityClassName);
        }
        if (entity.getAttributes() == null) {
            entity.setAttributes(new Attributes());
        }
        entityMappings.getEntity().add(entity);
        entity.setDescription(ejbModule.getModuleId() + "#" + bean.getEjbName());
        String entityName = bean.getAbstractSchemaName();
        entity.setName(entityName);
        entity.setEjbName(bean.getEjbName());
        ClassLoader classLoader = ejbModule.getClassLoader();
        Collection<MappedSuperclass> mappedSuperclasses = bean.getCmpVersion() == CmpVersion.CMP2 ? this.mapClass2x((Mapping)entity, bean, classLoader) : this.mapClass1x(bean.getEjbClass(), (Mapping)entity, bean, classLoader);
        if (mappedSuperclasses != null) {
            for (MappedSuperclass mappedSuperclass : mappedSuperclasses) {
                entityMappings.getMappedSuperclass().add(mappedSuperclass);
            }
        }
        for (Query query : bean.getQuery()) {
            NamedQuery namedQuery = new NamedQuery();
            org.apache.openejb.jee.QueryMethod queryMethod = query.getQueryMethod();
            StringBuilder name = new StringBuilder();
            name.append(entityName).append(".").append(queryMethod.getMethodName());
            if (queryMethod.getMethodParams() != null && !queryMethod.getMethodParams().getMethodParam().isEmpty()) {
                name.append('(');
                boolean first = true;
                for (String methodParam : queryMethod.getMethodParams().getMethodParam()) {
                    if (!first) {
                        name.append(",");
                    }
                    name.append(methodParam);
                    first = false;
                }
                name.append(')');
            }
            namedQuery.setName(name.toString());
            namedQuery.setQuery(query.getEjbQl());
            entity.getNamedQuery().add(namedQuery);
        }
        OpenejbJar openejbJar = ejbModule.getOpenejbJar();
        EjbDeployment ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
        if (ejbDeployment != null) {
            for (org.apache.openejb.jee.oejb3.Query query : ejbDeployment.getQuery()) {
                NamedQuery namedQuery = new NamedQuery();
                QueryMethod queryMethod = query.getQueryMethod();
                StringBuilder name = new StringBuilder();
                name.append(entityName).append(".").append(queryMethod.getMethodName());
                if (queryMethod.getMethodParams() != null && !queryMethod.getMethodParams().getMethodParam().isEmpty()) {
                    name.append('(');
                    boolean first = true;
                    for (String methodParam : queryMethod.getMethodParams().getMethodParam()) {
                        if (!first) {
                            name.append(",");
                        }
                        name.append(methodParam);
                        first = false;
                    }
                    name.append(')');
                }
                namedQuery.setName(name.toString());
                namedQuery.setQuery(query.getObjectQl());
                entity.getNamedQuery().add(namedQuery);
            }
        }
    }

    private Entity removeEntity(EntityMappings userMappings, String className) {
        Entity entity = (Entity)userMappings.getEntityMap().get(className);
        if (entity != null) {
            userMappings.getEntityMap().remove(entity.getKey());
        }
        return entity;
    }

    private MappedSuperclass removeMappedSuperclass(EntityMappings userMappings, String className) {
        MappedSuperclass mappedSuperclass = (MappedSuperclass)userMappings.getMappedSuperclassMap().get(className);
        if (mappedSuperclass != null) {
            userMappings.getMappedSuperclassMap().remove(mappedSuperclass.getKey());
        }
        return mappedSuperclass;
    }

    private EntityMappings getUserEntityMappings(EjbModule ejbModule) {
        Object o = ejbModule.getAltDDs().get("openejb-cmp-orm.xml");
        if (o instanceof EntityMappings) {
            return (EntityMappings)o;
        }
        return new EntityMappings();
    }

    private Collection<MappedSuperclass> mapClass2x(Mapping mapping, EntityBean bean, ClassLoader classLoader) {
        TreeSet<String> allFields = new TreeSet<String>();
        for (CmpField cmpField : bean.getCmpField()) {
            allFields.add(cmpField.getFieldName());
        }
        Class<?> beanClass = null;
        try {
            beanClass = classLoader.loadClass(bean.getEjbClass());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Map<String, MappedSuperclass> superclassByField = this.mapFields(beanClass, allFields);
        for (Method method : beanClass.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE) || EJBLocalObject.class.isAssignableFrom(method.getReturnType()) || Collection.class.isAssignableFrom(method.getReturnType()) || Map.class.isAssignableFrom(method.getReturnType())) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                name = name.substring("get".length(), name.length());
            } else {
                if (!name.startsWith("is") || method.getReturnType() != Boolean.TYPE) continue;
                name = name.substring("is".length(), name.length());
            }
            name = Strings.lcfirst(name);
            if (allFields.contains(name)) continue;
            allFields.add(name);
            bean.addCmpField(name);
        }
        HashSet<String> primaryKeyFields = new HashSet<String>();
        if (bean.getPrimkeyField() != null) {
            String fieldName = bean.getPrimkeyField();
            MappedSuperclass superclass = superclassByField.get(fieldName);
            if (superclass != null) {
                superclass.addField((org.apache.openejb.jee.jpa.Field)new Id(fieldName));
                mapping.addField((org.apache.openejb.jee.jpa.Field)new AttributeOverride(fieldName));
            } else {
                mapping.addField((org.apache.openejb.jee.jpa.Field)new Id(fieldName));
            }
            primaryKeyFields.add(fieldName);
        } else if ("java.lang.Object".equals(bean.getPrimKeyClass())) {
            String fieldName = "OpenEJB_pk";
            Id field = new Id("OpenEJB_pk");
            field.setGeneratedValue(new GeneratedValue(GenerationType.AUTO));
            mapping.addField((org.apache.openejb.jee.jpa.Field)field);
            primaryKeyFields.add("OpenEJB_pk");
        } else if (bean.getPrimKeyClass() != null) {
            Class<?> pkClass = null;
            try {
                pkClass = classLoader.loadClass(bean.getPrimKeyClass());
                MappedSuperclass idclass = null;
                for (Field pkField : pkClass.getFields()) {
                    String pkFieldName = pkField.getName();
                    int modifiers = pkField.getModifiers();
                    if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || !allFields.contains(pkFieldName)) continue;
                    MappedSuperclass superclass = superclassByField.get(pkFieldName);
                    if (superclass != null) {
                        superclass.addField((org.apache.openejb.jee.jpa.Field)new Id(pkFieldName));
                        mapping.addField((org.apache.openejb.jee.jpa.Field)new AttributeOverride(pkFieldName));
                        idclass = this.resolveIdClass(idclass, superclass, beanClass);
                    } else {
                        mapping.addField((org.apache.openejb.jee.jpa.Field)new Id(pkFieldName));
                    }
                    primaryKeyFields.add(pkFieldName);
                }
                if (idclass != null) {
                    idclass.setIdClass(new IdClass(bean.getPrimKeyClass()));
                } else {
                    mapping.setIdClass(new IdClass(bean.getPrimKeyClass()));
                }
            }
            catch (ClassNotFoundException e) {
                throw (IllegalStateException)new IllegalStateException("Could not find entity primary key class " + bean.getPrimKeyClass()).initCause(e);
            }
        }
        for (CmpField cmpField : bean.getCmpField()) {
            if (primaryKeyFields.contains(cmpField.getFieldName())) continue;
            String string = cmpField.getFieldName();
            MappedSuperclass superclass = superclassByField.get(string);
            if (superclass != null) {
                superclass.addField((org.apache.openejb.jee.jpa.Field)new Basic(string));
                mapping.addField((org.apache.openejb.jee.jpa.Field)new AttributeOverride(string));
                continue;
            }
            mapping.addField((org.apache.openejb.jee.jpa.Field)new Basic(string));
        }
        return new HashSet<MappedSuperclass>(superclassByField.values());
    }

    private Collection<MappedSuperclass> mapClass1x(String ejbClassName, Mapping mapping, EntityBean bean, ClassLoader classLoader) {
        MappedSuperclass superclass;
        String fieldName;
        Class ejbClass = CmpJpaConversion.loadClass(classLoader, ejbClassName);
        TreeSet<String> allFields = new TreeSet<String>();
        for (CmpField cmpField : bean.getCmpField()) {
            allFields.add(cmpField.getFieldName());
        }
        Map<String, MappedSuperclass> superclassByField = this.mapFields(ejbClass, allFields);
        HashSet<String> primaryKeyFields = new HashSet<String>();
        if (bean.getPrimkeyField() != null) {
            fieldName = bean.getPrimkeyField();
            superclass = superclassByField.get(fieldName);
            if (superclass == null) {
                throw new IllegalStateException("Primary key field " + fieldName + " is not defined in class " + ejbClassName + " or any super classes");
            }
            superclass.addField((org.apache.openejb.jee.jpa.Field)new Id(fieldName));
            mapping.addField((org.apache.openejb.jee.jpa.Field)new AttributeOverride(fieldName));
            primaryKeyFields.add(fieldName);
        } else if ("java.lang.Object".equals(bean.getPrimKeyClass())) {
            fieldName = "OpenEJB_pk";
            Id field = new Id("OpenEJB_pk");
            field.setGeneratedValue(new GeneratedValue(GenerationType.AUTO));
            mapping.addField((org.apache.openejb.jee.jpa.Field)field);
        } else if (bean.getPrimKeyClass() != null) {
            Class<?> pkClass = null;
            try {
                pkClass = classLoader.loadClass(bean.getPrimKeyClass());
                superclass = null;
                MappedSuperclass idclass = null;
                for (Field pkField : pkClass.getFields()) {
                    String fieldName2 = pkField.getName();
                    int modifiers = pkField.getModifiers();
                    if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || !allFields.contains(fieldName2)) continue;
                    superclass = superclassByField.get(fieldName2);
                    if (superclass == null) {
                        throw new IllegalStateException("Primary key field " + fieldName2 + " is not defined in class " + ejbClassName + " or any super classes");
                    }
                    superclass.addField((org.apache.openejb.jee.jpa.Field)new Id(fieldName2));
                    mapping.addField((org.apache.openejb.jee.jpa.Field)new AttributeOverride(fieldName2));
                    primaryKeyFields.add(fieldName2);
                    idclass = this.resolveIdClass(idclass, superclass, ejbClass);
                }
                if (idclass != null) {
                    idclass.setIdClass(new IdClass(bean.getPrimKeyClass()));
                }
            }
            catch (ClassNotFoundException e) {
                throw (IllegalStateException)new IllegalStateException("Could not find entity primary key class " + bean.getPrimKeyClass()).initCause(e);
            }
        }
        for (CmpField cmpField : bean.getCmpField()) {
            String fieldName3 = cmpField.getFieldName();
            if (primaryKeyFields.contains(fieldName3)) continue;
            MappedSuperclass superclass2 = superclassByField.get(fieldName3);
            if (superclass2 == null) {
                throw new IllegalStateException("CMP field " + fieldName3 + " is not defined in class " + ejbClassName + " or any super classes");
            }
            superclass2.addField((org.apache.openejb.jee.jpa.Field)new Basic(fieldName3));
            mapping.addField((org.apache.openejb.jee.jpa.Field)new AttributeOverride(fieldName3));
        }
        return new HashSet<MappedSuperclass>(superclassByField.values());
    }

    private MappedSuperclass resolveIdClass(MappedSuperclass idclass, MappedSuperclass current, Class ejbClass) {
        String currentClassName;
        if (idclass == null) {
            return current;
        }
        String idClassName = idclass.getClazz();
        if (idClassName.equals(currentClassName = current.getClazz())) {
            return idclass;
        }
        for (Class clazz = ejbClass; clazz != null; clazz = clazz.getSuperclass()) {
            String name = clazz.getName();
            if (name.equals(currentClassName)) {
                return current;
            }
            if (!name.equals(idClassName)) continue;
            return idclass;
        }
        return idclass;
    }

    private static Class loadClass(ClassLoader classLoader, String className) {
        Class<?> ejbClass = null;
        try {
            ejbClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return ejbClass;
    }

    private Map<String, MappedSuperclass> mapFields(Class clazz, Set<String> persistantFields) {
        persistantFields = new TreeSet<String>(persistantFields);
        TreeMap<String, MappedSuperclass> fields = new TreeMap<String, MappedSuperclass>();
        while (!persistantFields.isEmpty() && !clazz.equals(Object.class)) {
            MappedSuperclass superclass = new MappedSuperclass(clazz.getName());
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                String fieldName = field.getName();
                if (persistantFields.contains(fieldName)) {
                    fields.put(fieldName, superclass);
                    persistantFields.remove(fieldName);
                    continue;
                }
                if (ENHANCED_FIELDS.contains(fieldName)) continue;
                Transient transientField = new Transient(fieldName);
                superclass.addField((org.apache.openejb.jee.jpa.Field)transientField);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private boolean addPersistenceContextRef(EntityBean bean) {
        if (bean.getPersistenceContextRefMap().containsKey("java:comp/env/openejb/cmp")) {
            return false;
        }
        PersistenceContextRef persistenceContextRef = new PersistenceContextRef();
        persistenceContextRef.setName("java:comp/env/openejb/cmp");
        persistenceContextRef.setPersistenceUnitName(CMP_PERSISTENCE_UNIT_NAME);
        bean.getPersistenceContextRef().add(persistenceContextRef);
        return true;
    }

    private void setCascade(EjbRelationshipRole role, RelationField field) {
        if (role.getCascadeDelete()) {
            CascadeType cascadeType = new CascadeType();
            cascadeType.setCascadeAll(true);
            field.setCascade(cascadeType);
        }
    }
}

