/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.compiler.CompilationMessageHolder;
import com.sun.faces.facelets.compiler.CompilationMessageHolderImpl;
import com.sun.faces.facelets.compiler.CompilationUnit;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.ImplementationUnit;
import com.sun.faces.facelets.compiler.InterfaceUnit;
import com.sun.faces.facelets.compiler.NamespaceManager;
import com.sun.faces.facelets.compiler.NamespaceUnit;
import com.sun.faces.facelets.compiler.RemoveUnit;
import com.sun.faces.facelets.compiler.TagUnit;
import com.sun.faces.facelets.compiler.TextUnit;
import com.sun.faces.facelets.compiler.TrimmedTagUnit;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.util.FacesLogger;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagDecorator;
import javax.faces.view.facelets.TagException;

final class CompilationManager {
    private static final Logger log = FacesLogger.FACELETS_COMPILER.getLogger();
    private final Compiler compiler;
    private final TagLibrary tagLibrary;
    private final TagDecorator tagDecorator;
    private final NamespaceManager namespaceManager;
    private final Stack<CompilationUnit> units;
    private int tagId;
    private boolean finished;
    private final String alias;
    private CompilationMessageHolder messageHolder = null;
    private WebConfiguration config;
    private InterfaceUnit interfaceUnit;

    public CompilationManager(String alias, Compiler compiler) {
        this.alias = alias;
        this.compiler = compiler;
        this.tagDecorator = compiler.createTagDecorator();
        this.tagLibrary = compiler.createTagLibrary(this.getCompilationMessageHolder());
        this.namespaceManager = new NamespaceManager();
        this.tagId = 0;
        this.finished = false;
        this.units = new Stack();
        this.units.push(new CompilationUnit());
        this.config = WebConfiguration.getInstance();
    }

    private InterfaceUnit getInterfaceUnit() {
        return this.interfaceUnit;
    }

    public CompilationMessageHolder getCompilationMessageHolder() {
        if (null == this.messageHolder) {
            this.messageHolder = new CompilationMessageHolderImpl();
        }
        return this.messageHolder;
    }

    public String getAlias() {
        return this.alias;
    }

    public WebConfiguration getWebConfiguration() {
        return this.config;
    }

    public void setCompilationMessageHolder(CompilationMessageHolder messageHolder) {
        this.messageHolder = messageHolder;
    }

    private void setInterfaceUnit(InterfaceUnit interfaceUnit) {
        this.interfaceUnit = interfaceUnit;
    }

    public void writeInstruction(String value) {
        TextUnit unit;
        if (this.finished) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            unit = (TextUnit)this.currentUnit();
        } else {
            unit = new TextUnit(this.alias, this.nextTagId());
            this.startUnit(unit);
        }
        unit.writeInstruction(value);
    }

    public void writeText(String value) {
        TextUnit unit;
        if (this.finished) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            unit = (TextUnit)this.currentUnit();
        } else {
            unit = new TextUnit(this.alias, this.nextTagId());
            this.startUnit(unit);
        }
        unit.write(value);
    }

    public void writeComment(String text) {
        TextUnit unit;
        if (this.compiler.isTrimmingComments()) {
            return;
        }
        if (this.finished) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            unit = (TextUnit)this.currentUnit();
        } else {
            unit = new TextUnit(this.alias, this.nextTagId());
            this.startUnit(unit);
        }
        unit.writeComment(text);
    }

    public void writeWhitespace(String text) {
        if (!this.compiler.isTrimmingWhitespace()) {
            this.writeText(text);
        }
    }

    private String nextTagId() {
        return Integer.toHexString(Math.abs(this.alias.hashCode() ^ 13 * this.tagId++));
    }

    public void pushTag(Tag orig) {
        if (this.finished) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tag Pushed: " + orig);
        }
        Tag t = this.tagDecorator.decorate(orig);
        String[] qname = this.determineQName(t);
        t = this.trimAttributes(t);
        boolean handled = false;
        if (CompilationManager.isTrimmed(qname[0], qname[1])) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Composition Found, Popping Parent Tags");
            }
            CompilationUnit viewRootUnit = this.getViewRootUnitFromStack(this.units);
            this.units.clear();
            NamespaceUnit nsUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(nsUnit);
            if (viewRootUnit != null) {
                this.currentUnit().addChild(viewRootUnit);
            }
            this.startUnit(new TrimmedTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()));
            if (log.isLoggable(Level.FINE)) {
                log.fine("New Namespace and [Trimmed] TagUnit pushed");
            }
        } else if (CompilationManager.isImplementation(qname[0], qname[1])) {
            InterfaceUnit iface;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Composite Component Implementation Found, Popping Parent Tags");
            }
            if (null == (iface = this.getInterfaceUnit())) {
                throw new TagException(orig, "Unable to find interface for implementation.");
            }
            this.units.clear();
            NamespaceUnit nsUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(nsUnit);
            this.currentUnit().addChild(iface);
            this.startUnit(new ImplementationUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()));
            if (log.isLoggable(Level.FINE)) {
                log.fine("New Namespace and ImplementationUnit pushed");
            }
        } else if (CompilationManager.isRemove(qname[0], qname[1])) {
            this.units.push(new RemoveUnit());
        } else if (this.tagLibrary.containsTagHandler(qname[0], qname[1])) {
            if (CompilationManager.isInterface(qname[0], qname[1])) {
                InterfaceUnit iface = new InterfaceUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId());
                this.setInterfaceUnit(iface);
                this.startUnit(iface);
            } else {
                this.startUnit(new TagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()));
            }
        } else {
            TextUnit unit;
            if (this.tagLibrary.containsNamespace(qname[0], t)) {
                throw new TagException(orig, "Tag Library supports namespace: " + qname[0] + ", but no tag was defined for name: " + qname[1]);
            }
            if (this.currentUnit() instanceof TextUnit) {
                unit = (TextUnit)this.currentUnit();
            } else {
                unit = new TextUnit(this.alias, this.nextTagId());
                this.startUnit(unit);
            }
            unit.startTag(t);
        }
    }

    public void popTag() {
        CompilationUnit t;
        if (this.finished) {
            return;
        }
        CompilationUnit unit = this.currentUnit();
        if (unit instanceof TextUnit) {
            t = (TextUnit)unit;
            if (t.isClosed()) {
                this.finishUnit();
            } else {
                t.endTag();
                return;
            }
        }
        if ((unit = this.currentUnit()) instanceof TagUnit && (t = (TagUnit)unit) instanceof TrimmedTagUnit) {
            this.finished = true;
            return;
        }
        this.finishUnit();
    }

    public void popNamespace(String ns) {
        this.namespaceManager.popNamespace(ns);
        if (this.currentUnit() instanceof NamespaceUnit) {
            this.finishUnit();
        }
    }

    public void pushNamespace(String prefix, String uri) {
        NamespaceUnit unit;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Namespace Pushed " + prefix + ": " + uri);
        }
        boolean alreadyPresent = this.namespaceManager.getNamespace(prefix) != null;
        this.namespaceManager.pushNamespace(prefix, uri);
        if (this.currentUnit() instanceof NamespaceUnit && !alreadyPresent) {
            unit = (NamespaceUnit)this.currentUnit();
        } else {
            unit = new NamespaceUnit(this.tagLibrary);
            this.startUnit(unit);
        }
        unit.setNamespace(prefix, uri);
    }

    public FaceletHandler createFaceletHandler() {
        return ((CompilationUnit)this.units.get(0)).createFaceletHandler();
    }

    private CompilationUnit currentUnit() {
        if (!this.units.isEmpty()) {
            return this.units.peek();
        }
        return null;
    }

    private void finishUnit() {
        CompilationUnit unit = this.units.pop();
        unit.finishNotify(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished Unit: " + unit);
        }
    }

    private void startUnit(CompilationUnit unit) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting Unit: " + unit + " and adding it to parent: " + this.currentUnit());
        }
        this.currentUnit().addChild(unit);
        this.units.push(unit);
        unit.startNotify(this);
    }

    private Tag trimAttributes(Tag tag) {
        Tag t = this.trimJSFCAttribute(tag);
        t = this.trimNSAttributes(t);
        return t;
    }

    protected static boolean isRemove(String ns, String name) {
        return ("http://java.sun.com/jsf/facelets".equals(ns) || "http://xmlns.jcp.org/jsf/facelets".equals(ns)) && "remove".equals(name);
    }

    protected static boolean isTrimmed(String ns, String name) {
        boolean matchInUILibrary = !(!"http://java.sun.com/jsf/facelets".equals(ns) && !"http://xmlns.jcp.org/jsf/facelets".equals(ns) || !"composition".equals(name) && !"component".equals(name));
        return matchInUILibrary;
    }

    protected static boolean isImplementation(String ns, String name) {
        boolean matchInCompositeLibrary = ("http://java.sun.com/jsf/composite".equals(ns) || "http://xmlns.jcp.org/jsf/composite".equals(ns)) && "implementation".equals(name);
        return matchInCompositeLibrary;
    }

    protected static boolean isInterface(String ns, String name) {
        boolean matchInCompositeLibrary = ("http://java.sun.com/jsf/composite".equals(ns) || "http://xmlns.jcp.org/jsf/composite".equals(ns)) && "interface".equals(name);
        return matchInCompositeLibrary;
    }

    private String[] determineQName(Tag tag) {
        TagAttribute attr = tag.getAttributes().get("jsfc");
        if (attr != null) {
            String localName;
            String namespace;
            String value;
            int c;
            if (log.isLoggable(Level.FINE)) {
                log.fine(attr + " JSF Facelet Compile Directive Found");
            }
            if ((c = (value = attr.getValue()).indexOf(58)) == -1) {
                namespace = this.namespaceManager.getNamespace("");
                localName = value;
            } else {
                String prefix = value.substring(0, c);
                namespace = this.namespaceManager.getNamespace(prefix);
                if (namespace == null) {
                    throw new TagAttributeException(tag, attr, "No Namespace matched for: " + prefix);
                }
                localName = value.substring(c + 1);
            }
            return new String[]{namespace, localName};
        }
        return new String[]{tag.getNamespace(), tag.getLocalName()};
    }

    private Tag trimJSFCAttribute(Tag tag) {
        TagAttribute attr = tag.getAttributes().get("jsfc");
        if (attr != null) {
            TagAttribute[] oa = tag.getAttributes().getAll();
            TagAttribute[] na = new TagAttribute[oa.length - 1];
            int p = 0;
            for (int i = 0; i < oa.length; ++i) {
                if ("jsfc".equals(oa[i].getLocalName())) continue;
                na[p++] = oa[i];
            }
            return new Tag(tag, new TagAttributesImpl(na));
        }
        return tag;
    }

    private Tag trimNSAttributes(Tag tag) {
        TagAttribute[] attr = tag.getAttributes().getAll();
        int remove = 0;
        for (int i = 0; i < attr.length; ++i) {
            if (!attr[i].getQName().startsWith("xmlns") || !this.tagLibrary.containsNamespace(attr[i].getValue(), null)) continue;
            remove |= 1 << i;
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(attr[i] + " Namespace Bound to TagLibrary");
        }
        if (remove == 0) {
            return tag;
        }
        ArrayList<TagAttribute> attrList = new ArrayList<TagAttribute>(attr.length);
        int p = 0;
        for (int i = 0; i < attr.length; ++i) {
            p = 1 << i;
            if ((p & remove) == p) continue;
            attrList.add(attr[i]);
        }
        attr = attrList.toArray(new TagAttribute[attrList.size()]);
        return new Tag(tag.getLocation(), tag.getNamespace(), tag.getLocalName(), tag.getQName(), new TagAttributesImpl(attr));
    }

    private CompilationUnit getViewRootUnitFromStack(Stack<CompilationUnit> units) {
        TagUnit result = null;
        for (CompilationUnit compilationUnit : units) {
            TagUnit tagUnit;
            String ns;
            if (!(compilationUnit instanceof TagUnit) || !(ns = (tagUnit = (TagUnit)compilationUnit).getTag().getNamespace()).equals("http://java.sun.com/jsf/core") && !ns.equals("http://xmlns.jcp.org/jsf/core") || !tagUnit.getTag().getLocalName().equals("view")) continue;
            result = tagUnit;
            break;
        }
        return result;
    }
}

