/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.ProxyRestriction;

public class ConditionsImpl
extends AbstractXMLObject
implements Conditions {
    @Nonnull
    private final IndexedXMLObjectChildrenList<Condition> conditions = new IndexedXMLObjectChildrenList((XMLObject)this);
    @Nullable
    private Instant notBefore;
    @Nullable
    private Instant notOnOrAfter;

    protected ConditionsImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nonnull
    @Live
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Nonnull
    @Live
    public List<Condition> getConditions(@Nonnull QName typeOrName) {
        return this.conditions.subList(typeOrName);
    }

    @Nonnull
    @Live
    public List<AudienceRestriction> getAudienceRestrictions() {
        QName conditionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AudienceRestriction", "saml2");
        return this.conditions.subList(conditionQName);
    }

    @Nullable
    public OneTimeUse getOneTimeUse() {
        QName conditionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "OneTimeUse", "saml2");
        List list = this.conditions.subList(conditionQName);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (OneTimeUse)list.get(0);
    }

    @Nullable
    public ProxyRestriction getProxyRestriction() {
        QName conditionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction", "saml2");
        List list = this.conditions.subList(conditionQName);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ProxyRestriction)list.get(0);
    }

    @Nullable
    public Instant getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(@Nullable Instant newNotBefore) {
        this.notBefore = (Instant)this.prepareForAssignment(this.notBefore, newNotBefore);
    }

    @Nullable
    public Instant getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(@Nullable Instant newNotOnOrAfter) {
        this.notOnOrAfter = (Instant)this.prepareForAssignment(this.notOnOrAfter, newNotOnOrAfter);
    }

    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        return CollectionSupport.copyToList(this.conditions);
    }
}

