/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.apache.xbean.naming.context.AbstractFederatedContext;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextUtil;
import org.apache.xbean.naming.reference.CachingReference;

public class WritableContext
extends AbstractFederatedContext {
    private final Lock writeLock = new ReentrantLock();
    private final AtomicReference<Map<String, Object>> bindingsRef;
    private final AtomicReference<Map<String, Object>> indexRef;
    private final boolean cacheReferences;
    private final boolean supportReferenceable;
    private final boolean checkDereferenceDifferent;
    private final boolean assumeDereferenceBound;

    public WritableContext() throws NamingException {
        this("", Collections.emptyMap(), ContextAccess.MODIFIABLE, false);
    }

    public WritableContext(String nameInNamespace) throws NamingException {
        this(nameInNamespace, Collections.emptyMap(), ContextAccess.MODIFIABLE, false);
    }

    public WritableContext(String nameInNamespace, Map<String, Object> bindings) throws NamingException {
        this(nameInNamespace, bindings, ContextAccess.MODIFIABLE, false);
    }

    public WritableContext(String nameInNamespace, Map<String, Object> bindings, boolean cacheReferences) throws NamingException {
        this(nameInNamespace, bindings, ContextAccess.MODIFIABLE, cacheReferences);
    }

    public WritableContext(String nameInNamespace, Map<String, Object> bindings, ContextAccess contextAccess) throws NamingException {
        this(nameInNamespace, bindings, contextAccess, false);
    }

    public WritableContext(String nameInNamespace, Map<String, Object> bindings, ContextAccess contextAccess, boolean cacheReferences) throws NamingException {
        this(nameInNamespace, bindings, contextAccess, cacheReferences, true, true, false);
    }

    public WritableContext(String nameInNamespace, Map<String, Object> bindings, ContextAccess contextAccess, boolean cacheReferences, boolean supportReferenceable, boolean checkDereferenceDifferent, boolean assumeDereferenceBound) throws NamingException {
        super(nameInNamespace, contextAccess);
        this.cacheReferences = cacheReferences;
        if (this.cacheReferences) {
            bindings = CachingReference.wrapReferences(bindings, this);
        }
        this.supportReferenceable = supportReferenceable;
        this.checkDereferenceDifferent = checkDereferenceDifferent;
        this.assumeDereferenceBound = assumeDereferenceBound;
        Map<String, Object> localBindings = ContextUtil.createBindings(bindings, this);
        this.bindingsRef = new AtomicReference<Map<String, Object>>(Collections.unmodifiableMap(localBindings));
        this.indexRef = new AtomicReference<Map<String, Object>>(Collections.unmodifiableMap(WritableContext.buildIndex("", localBindings)));
    }

    @Override
    protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
        if (super.addBinding(name, value, rebind)) {
            return true;
        }
        this.addBinding(this.bindingsRef, name, this.getNameInNamespace(name), value, rebind);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBinding(AtomicReference<Map<String, Object>> bindingsRef, String name, String nameInNamespace, Object value, boolean rebind) throws NamingException {
        block11: {
            Reference ref;
            if (this.supportReferenceable && value instanceof Referenceable && (ref = ((Referenceable)value).getReference()) != null) {
                if (this.checkDereferenceDifferent) {
                    try {
                        Object o = NamingManager.getObjectInstance(ref, null, null, new Hashtable());
                        if (!value.equals(o)) {
                            value = ref;
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        if (!this.assumeDereferenceBound) {
                            value = ref;
                        }
                        break block11;
                    }
                }
                value = ref;
            }
        }
        if (this.cacheReferences) {
            value = CachingReference.wrapReference(name, value, this);
        }
        this.writeLock.lock();
        try {
            Map<String, Object> bindings = bindingsRef.get();
            if (!rebind && bindings.containsKey(name)) {
                throw new NameAlreadyBoundException(name);
            }
            HashMap<String, Object> newBindings = new HashMap<String, Object>(bindings);
            newBindings.put(name, value);
            bindingsRef.set(newBindings);
            this.addToIndex(nameInNamespace, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addToIndex(String name, Object value) {
        Map<String, Object> index = this.indexRef.get();
        HashMap<String, Object> newIndex = new HashMap<String, Object>(index);
        newIndex.put(name, value);
        if (value instanceof NestedWritableContext) {
            NestedWritableContext nestedcontext = (NestedWritableContext)value;
            Map<String, Object> newIndexValues = WritableContext.buildIndex(name, (Map)nestedcontext.bindingsRef.get());
            newIndex.putAll(newIndexValues);
        }
        this.indexRef.set(newIndex);
    }

    @Override
    protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
        if (super.removeBinding(name, removeNotEmptyContext)) {
            return true;
        }
        this.removeBinding(this.bindingsRef, name, this.getNameInNamespace(name), removeNotEmptyContext);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBinding(AtomicReference<Map<String, Object>> bindingsRef, String name, String nameInNamespace, boolean removeNotEmptyContext) throws NamingException {
        this.writeLock.lock();
        try {
            Map<String, Object> bindings = bindingsRef.get();
            if (!bindings.containsKey(name)) {
                boolean bl = false;
                return bl;
            }
            HashMap<String, Object> newBindings = new HashMap<String, Object>(bindings);
            Object oldValue = newBindings.remove(name);
            if (!removeNotEmptyContext && oldValue instanceof Context && !WritableContext.isEmpty((Context)oldValue)) {
                throw new ContextNotEmptyException(name);
            }
            bindingsRef.set(newBindings);
            Map<String, Object> newIndex = this.removeFromIndex(nameInNamespace);
            this.indexRef.set(newIndex);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<String, Object> removeFromIndex(String name) {
        Map<String, Object> index = this.indexRef.get();
        HashMap<String, Object> newIndex = new HashMap<String, Object>(index);
        Object oldValue = newIndex.remove(name);
        if (oldValue instanceof NestedWritableContext) {
            NestedWritableContext nestedcontext = (NestedWritableContext)oldValue;
            Map<String, Object> removedIndexValues = WritableContext.buildIndex(name, (Map)nestedcontext.bindingsRef.get());
            for (String key : removedIndexValues.keySet()) {
                newIndex.remove(key);
            }
        }
        return newIndex;
    }

    @Override
    public Context createNestedSubcontext(String path, Map<String, Object> bindings) throws NamingException {
        if (this.getNameInNamespace().length() > 0) {
            path = this.getNameInNamespace() + "/" + path;
        }
        return new NestedWritableContext(path, bindings);
    }

    private static Map<String, Object> buildIndex(String nameInNamespace, Map<String, Object> bindings) {
        String path = nameInNamespace;
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        HashMap<String, Object> absoluteIndex = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof NestedWritableContext) {
                NestedWritableContext nestedContext = (NestedWritableContext)value;
                absoluteIndex.putAll(WritableContext.buildIndex(nestedContext.pathWithSlash, (Map)nestedContext.bindingsRef.get()));
            }
            absoluteIndex.put(path + name, value);
        }
        return absoluteIndex;
    }

    @Override
    protected Object getDeepBinding(String name) {
        Map<String, Object> index = this.indexRef.get();
        return index.get(name);
    }

    @Override
    protected Map<String, Object> getWrapperBindings() throws NamingException {
        return this.bindingsRef.get();
    }

    public class NestedWritableContext
    extends AbstractFederatedContext {
        private final AtomicReference<Map<String, Object>> bindingsRef;
        private final String pathWithSlash;

        public NestedWritableContext(String path, Map<String, Object> bindings) throws NamingException {
            super(WritableContext.this, path);
            path = this.getNameInNamespace();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.pathWithSlash = path;
            this.bindingsRef = new AtomicReference<Map<String, Object>>(Collections.unmodifiableMap(bindings));
        }

        @Override
        public Context createNestedSubcontext(String path, Map<String, Object> bindings) throws NamingException {
            return new NestedWritableContext(this.getNameInNamespace(path), bindings);
        }

        @Override
        protected Object getDeepBinding(String name) {
            String absoluteName = this.pathWithSlash + name;
            return WritableContext.this.getDeepBinding(absoluteName);
        }

        @Override
        protected Map<String, Object> getWrapperBindings() throws NamingException {
            return this.bindingsRef.get();
        }

        @Override
        protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
            if (super.addBinding(name, value, rebind)) {
                return true;
            }
            WritableContext.this.addBinding(this.bindingsRef, name, this.getNameInNamespace(name), value, rebind);
            return true;
        }

        @Override
        protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
            if (WritableContext.this.removeBinding(this.bindingsRef, name, this.getNameInNamespace(name), removeNotEmptyContext)) {
                return true;
            }
            return super.removeBinding(name, false);
        }
    }
}

