/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces.core;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.AjaxBehaviorListener;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.BehaviorHolderAttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.ClientBehaviorRedirectEventComponentWrapper;
import org.apache.myfaces.view.facelets.tag.composite.InsertChildrenHandler;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.faces.core.AjaxBehaviorListenerImpl;
import org.apache.myfaces.view.facelets.tag.ui.DecorateHandler;
import org.apache.myfaces.view.facelets.tag.ui.IncludeHandler;
import org.apache.myfaces.view.facelets.tag.ui.InsertHandler;

public class AjaxHandler
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    public static final Class<?>[] AJAX_BEHAVIOR_LISTENER_SIG = new Class[]{AjaxBehaviorEvent.class};
    public static final String FACES_JS_DYNAMICALLY_ADDED = "org.apache.myfaces.FACES_JS_DYNAMICALLY_ADDED";
    private final TagAttribute disabled = this.getAttribute("disabled");
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute immediate = this.getAttribute("immediate");
    private final TagAttribute listener = this.getAttribute("listener");
    private final TagAttribute onevent;
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute render;
    private final TagAttribute delay;
    private final TagAttribute resetValues;
    private final boolean wrappingMode;

    public AjaxHandler(TagConfig config) {
        super(config);
        this.onevent = this.getAttribute("onevent");
        this.render = this.getAttribute("render");
        this.delay = this.getAttribute("delay");
        this.resetValues = this.getAttribute("resetValues");
        ArrayList<FaceletHandler> compHandlerList = TagHandlerUtils.findNextByType(this.nextHandler, ComponentHandler.class, InsertChildrenHandler.class, InsertHandler.class, DecorateHandler.class, IncludeHandler.class);
        this.wrappingMode = !compHandlerList.isEmpty();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (this.wrappingMode) {
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            actx.pushAjaxHandlerToStack(this);
            this.nextHandler.apply(ctx, parent);
            actx.popAjaxHandlerToStack();
            AjaxHandler.registerFacesJsResource(ctx, parent);
        } else {
            if (!ComponentHandler.isNew((UIComponent)parent)) {
                return;
            }
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(ctx.getFacesContext(), parent);
            } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
                FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
                mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this);
            } else {
                throw new TagException(this.tag, "Parent is not composite component or of type ClientBehaviorHolder; Type is: " + parent);
            }
            AjaxHandler.registerFacesJsResource(ctx, parent);
        }
    }

    public static void registerFacesJsResource(FaceletContext ctx, UIComponent parent) {
        FacesContext facesContext = ctx.getFacesContext();
        if (!facesContext.getAttributes().containsKey(FACES_JS_DYNAMICALLY_ADDED)) {
            UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, "jakarta.faces.Output", "jakarta.faces.resource.Script");
            outputScript.getAttributes().put("name", "faces.js");
            outputScript.getAttributes().put("library", "jakarta.faces");
            outputScript.getAttributes().put("target", "head");
            UIViewRoot uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
            String uid = uniqueIdVendor.createUniqueId(ctx.getFacesContext(), null);
            outputScript.setId(uid);
            parent.getChildren().add(outputScript);
            if (FaceletCompositionContext.getCurrentInstance(ctx).isMarkInitialState()) {
                outputScript.markInitialState();
            }
            facesContext.getAttributes().put(FACES_JS_DYNAMICALLY_ADDED, Boolean.TRUE);
        }
    }

    public String getEventName() {
        if (this.event == null) {
            return null;
        }
        if (this.event.isLiteral()) {
            return this.event.getValue();
        }
        FaceletContext faceletContext = (FaceletContext)FacesContext.getCurrentInstance().getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        return (String)this.event.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ClientBehaviorHolder cvh = (ClientBehaviorHolder)parent;
        String eventName = null;
        if (this.event != null) {
            eventName = this.event.isLiteral() ? this.event.getValue() : (String)this.event.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
        }
        if (eventName == null) {
            eventName = cvh.getDefaultEventName();
            if (eventName == null) {
                if (this.wrappingMode) {
                    return;
                }
                throw new TagAttributeException(this.event, "eventName could not be defined for f:ajax tag with no wrap mode.");
            }
        } else if (!cvh.getEventNames().contains(eventName)) {
            if (this.wrappingMode) {
                return;
            }
            throw new TagAttributeException(this.event, "event it is not a valid eventName defined for this component");
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)context.getApplication().createBehavior("jakarta.faces.behavior.Ajax");
        this.setAttribute(faceletContext, ajaxBehavior, this.disabled, Boolean.class, v -> ajaxBehavior.setDisabled(v.booleanValue()));
        this.setAttribute(faceletContext, ajaxBehavior, this.execute, Object.class);
        this.setAttribute(faceletContext, ajaxBehavior, this.immediate, Boolean.class, v -> ajaxBehavior.setImmediate(v.booleanValue()));
        this.setAttribute(faceletContext, ajaxBehavior, this.onerror, String.class, v -> ajaxBehavior.setOnerror(v));
        this.setAttribute(faceletContext, ajaxBehavior, this.onevent, String.class, v -> ajaxBehavior.setOnevent(v));
        this.setAttribute(faceletContext, ajaxBehavior, this.render, Object.class);
        this.setAttribute(faceletContext, ajaxBehavior, this.delay, String.class, v -> ajaxBehavior.setDelay(v));
        this.setAttribute(faceletContext, ajaxBehavior, this.resetValues, Boolean.class, v -> ajaxBehavior.setResetValues(v.booleanValue()));
        if (this.listener != null) {
            MethodExpression expr = this.listener.getMethodExpression(faceletContext, Void.TYPE, (Class[])AJAX_BEHAVIOR_LISTENER_SIG);
            AjaxBehaviorListenerImpl abl = new AjaxBehaviorListenerImpl(expr);
            ajaxBehavior.addAjaxBehaviorListener((AjaxBehaviorListener)abl);
        }
        if (parent instanceof ClientBehaviorRedirectEventComponentWrapper) {
            String[] targetsArray;
            ValueExpression targets = ((ClientBehaviorRedirectEventComponentWrapper)parent).getTargets();
            String targetsString = targets == null ? null : (String)targets.getValue(context.getELContext());
            String[] stringArray = targetsArray = targetsString == null ? null : targetsString.trim().split(" +");
            if (targetsArray != null && targetsArray.length > 0) {
                Collection render;
                String separatorChar = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
                Collection execute = ajaxBehavior.getExecute();
                if (execute.isEmpty() || execute.contains("@this")) {
                    ArrayList<CallSite> newExecute = new ArrayList<CallSite>(execute);
                    newExecute.remove("@this");
                    for (String target : targetsArray) {
                        newExecute.add((CallSite)((Object)("@this" + separatorChar + target)));
                    }
                    ajaxBehavior.setExecute(newExecute);
                }
                if ((render = ajaxBehavior.getRender()).contains("@this")) {
                    ArrayList<CallSite> newRender = new ArrayList<CallSite>(render);
                    newRender.remove("@this");
                    for (String target : targetsArray) {
                        newRender.add((CallSite)((Object)("@this" + separatorChar + target)));
                    }
                    ajaxBehavior.setRender(newRender);
                }
            }
        }
        cvh.addClientBehavior(eventName, (ClientBehavior)ajaxBehavior);
    }

    protected <T> void setAttribute(FaceletContext faceletContext, AjaxBehavior behavior, TagAttribute attr, Class<T> type) {
        this.setAttribute(faceletContext, behavior, attr, type, null);
    }

    protected <T> void setAttribute(FaceletContext faceletContext, AjaxBehavior behavior, TagAttribute attr, Class<T> type, Consumer<T> setter) {
        if (attr != null) {
            if (!attr.isLiteral() || setter == null) {
                behavior.setValueExpression(attr.getLocalName(), attr.getValueExpression(faceletContext, type));
            } else if (type == Boolean.class) {
                setter.accept(attr.getBoolean(faceletContext));
            } else {
                setter.accept((Boolean)((Object)attr.getValue(faceletContext)));
            }
        }
    }

    public String getFor() {
        return null;
    }
}

