/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.MessageFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DateTimeConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "jakarta.faces.DateTime";
    public static final String DATE_ID = "jakarta.faces.converter.DateTimeConverter.DATE";
    public static final String TIME_ID = "jakarta.faces.converter.DateTimeConverter.TIME";
    public static final String DATETIME_ID = "jakarta.faces.converter.DateTimeConverter.DATETIME";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final Map<String, TemporalQuery<Object>> JAVA_TIME_TYPES = Map.of("localDate", LocalDate::from, "localDateTime", LocalDateTime::from, "localTime", LocalTime::from, "offsetTime", OffsetTime::from, "offsetDateTime", OffsetDateTime::from, "zonedDateTime", ZonedDateTime::from);
    private static final Pattern ESCAPED_DATE_TIME_PATTERN = Pattern.compile("'[^']*+'");
    private String dateStyle = "default";
    private Locale locale;
    private String pattern;
    private String timeStyle = "default";
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private String type = "date";
    private boolean transientFlag;
    private boolean initialState;

    public String getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(String dateStyle) {
        this.clearInitialState();
        this.dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.clearInitialState();
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.clearInitialState();
        this.pattern = pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.clearInitialState();
        this.timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.clearInitialState();
        this.timeZone = timeZone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.clearInitialState();
        this.type = type;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Object returnValue = null;
        FormatWrapper parser = null;
        try {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(context);
            parser = this.getDateFormat(locale);
            if (this.timeZone != null) {
                parser.setTimeZone(this.timeZone);
            }
            returnValue = parser.parse(value);
        }
        catch (ParseException | DateTimeParseException e) {
            if (this.type != null) {
                switch (this.type) {
                    case "date": 
                    case "localDate": {
                        throw new ConverterException(MessageFactory.getMessage(context, DATE_ID, value, parser.formatNow(), MessageFactory.getLabel(context, component)), (Throwable)e);
                    }
                    case "time": 
                    case "localTime": 
                    case "offsetTime": {
                        throw new ConverterException(MessageFactory.getMessage(context, TIME_ID, value, parser.formatNow(), MessageFactory.getLabel(context, component)), (Throwable)e);
                    }
                    case "both": 
                    case "localDateTime": 
                    case "offsetDateTime": 
                    case "zonedDateTime": {
                        throw new ConverterException(MessageFactory.getMessage(context, DATETIME_ID, value, parser.formatNow(), MessageFactory.getLabel(context, component)), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        return returnValue;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        try {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Locale locale = this.getLocale(context);
            FormatWrapper formatter = this.getDateFormat(locale);
            if (null != this.timeZone) {
                formatter.setTimeZone(this.timeZone);
            }
            return formatter.format(value);
        }
        catch (ConverterException e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }

    private FormatWrapper getDateFormat(Locale locale) {
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        DateFormat df = null;
        DateTimeFormatterBuilder dtfBuilder = null;
        DateTimeFormatter dtf = null;
        TemporalQuery<Object> fromJavaTime = JAVA_TIME_TYPES.get(this.type);
        if (this.pattern != null) {
            if (fromJavaTime == null) {
                df = new SimpleDateFormat(this.pattern, locale);
            } else {
                dtfBuilder = new DateTimeFormatterBuilder().appendPattern(this.pattern);
            }
        } else if (this.type.equals("both")) {
            df = DateFormat.getDateTimeInstance(DateTimeConverter.getStyle(this.dateStyle), DateTimeConverter.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("date")) {
            df = DateFormat.getDateInstance(DateTimeConverter.getStyle(this.dateStyle), locale);
        } else if (this.type.equals("time")) {
            df = DateFormat.getTimeInstance(DateTimeConverter.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("localDate")) {
            dtfBuilder = new DateTimeFormatterBuilder().appendLocalized(DateTimeConverter.getFormatStyle(this.dateStyle), null);
        } else if (this.type.equals("localDateTime")) {
            dtfBuilder = new DateTimeFormatterBuilder().appendLocalized(DateTimeConverter.getFormatStyle(this.dateStyle), DateTimeConverter.getFormatStyle(this.timeStyle));
        } else if (this.type.equals("localTime")) {
            dtfBuilder = new DateTimeFormatterBuilder().appendLocalized(null, DateTimeConverter.getFormatStyle(this.timeStyle));
        } else if (this.type.equals("offsetTime")) {
            dtf = DateTimeFormatter.ISO_OFFSET_TIME.withLocale(locale);
        } else if (this.type.equals("offsetDateTime")) {
            dtf = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(locale);
        } else if (this.type.equals("zonedDateTime")) {
            dtf = DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(locale);
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.type);
        }
        if (df != null) {
            df.setLenient(false);
            return new FormatWrapper(df);
        }
        if (dtfBuilder != null) {
            if (this.pattern == null || !ESCAPED_DATE_TIME_PATTERN.matcher(this.pattern).replaceAll("").contains("uu")) {
                dtfBuilder.parseDefaulting(ChronoField.ERA, 1L);
            }
            dtf = dtfBuilder.toFormatter(locale).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
        }
        if (dtf != null) {
            return new FormatWrapper(dtf, fromJavaTime);
        }
        throw new IllegalArgumentException("Invalid type: " + this.type);
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private static int getStyle(String name) {
        if (null != name) {
            switch (name) {
                case "default": {
                    return 2;
                }
                case "short": {
                    return 3;
                }
                case "medium": {
                    return 2;
                }
                case "long": {
                    return 1;
                }
                case "full": {
                    return 0;
                }
            }
        }
        throw new ConverterException("Invalid style '" + name + "'");
    }

    private static FormatStyle getFormatStyle(String name) {
        if (null != name) {
            switch (name) {
                case "default": 
                case "medium": {
                    return FormatStyle.MEDIUM;
                }
                case "short": {
                    return FormatStyle.SHORT;
                }
                case "long": {
                    return FormatStyle.LONG;
                }
                case "full": {
                    return FormatStyle.FULL;
                }
            }
        }
        throw new ConverterException("Invalid style '" + name + "'");
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.dateStyle, this.locale, this.pattern, this.timeStyle, this.timeZone, this.type};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.dateStyle = (String)values[0];
            this.locale = (Locale)values[1];
            this.pattern = (String)values[2];
            this.timeStyle = (String)values[3];
            this.timeZone = (TimeZone)values[4];
            this.type = (String)values[5];
        }
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    private static class FormatWrapper {
        private final DateFormat dateFormat;
        private final DateTimeFormatter dateTimeFormatter;
        private final TemporalQuery<Object> from;

        private FormatWrapper(DateFormat dataFormat) {
            this.dateFormat = dataFormat;
            this.dateTimeFormatter = null;
            this.from = null;
        }

        private FormatWrapper(DateTimeFormatter dateTimeFormatter, TemporalQuery<Object> from) {
            this.dateFormat = null;
            this.dateTimeFormatter = dateTimeFormatter;
            this.from = from;
        }

        private Object parse(CharSequence text) throws ParseException {
            return this.dateFormat != null ? this.dateFormat.parse((String)text) : this.dateTimeFormatter.parse(text, this.from);
        }

        private String format(Object obj) {
            return this.dateFormat != null ? this.dateFormat.format(obj) : this.dateTimeFormatter.format((TemporalAccessor)obj);
        }

        private String formatNow() {
            return this.dateFormat != null ? this.dateFormat.format(new Date()) : this.dateTimeFormatter.format(ZonedDateTime.now());
        }

        private void setTimeZone(TimeZone zone) {
            if (this.dateFormat != null) {
                this.dateFormat.setTimeZone(zone);
            }
        }
    }
}

