/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ModuleProperties;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SuperProperties;

public class BeanProperties
implements DynamicDeployer {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, ModuleProperties.class);
    private final Map<String, Properties> additionalProperties = new HashMap<String, Properties>();
    private final Properties globalProperties = new Properties();

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        Properties base = new Properties();
        base.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        base.putAll((Map<?, ?>)appModule.getProperties());
        for (EjbModule module : appModule.getEjbModules()) {
            SuperProperties overrides = new SuperProperties().caseInsensitive(true);
            ((Properties)overrides).putAll((Map<?, ?>)base);
            ((Properties)overrides).putAll((Map<?, ?>)module.getProperties());
            if (module.getOpenejbJar() == null) {
                module.setOpenejbJar(new OpenejbJar());
            }
            OpenejbJar openejbJar = module.getOpenejbJar();
            Map deploymentMap = openejbJar.getDeploymentsByEjbName();
            for (EnterpriseBean bean : module.getEjbJar().getEnterpriseBeans()) {
                EjbDeployment deployment;
                SuperProperties properties = new SuperProperties().caseInsensitive(true);
                properties.putAll((Map<?, ?>)this.globalProperties);
                String additionalKey = bean.getEjbName();
                if (this.additionalProperties.containsKey(additionalKey)) {
                    for (Map.Entry<Object, Object> entry : this.additionalProperties.get(additionalKey).entrySet()) {
                        properties.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                }
                if ((deployment = (EjbDeployment)deploymentMap.get(bean.getEjbName())) != null) {
                    properties.putAll((Map<?, ?>)deployment.getProperties());
                    deployment.getProperties().clear();
                }
                String id = bean.getEjbName() + ".";
                for (Map.Entry<Object, Object> entry : ((Properties)overrides).entrySet()) {
                    String key = entry.getKey().toString();
                    if (!key.startsWith(id)) continue;
                    String property = key.substring(id.length());
                    if (properties.containsKey(property)) {
                        log.debug("Overriding ejb " + bean.getEjbName() + " property " + property + "=" + String.valueOf(entry.getValue()));
                    } else {
                        log.debug("Adding ejb " + bean.getEjbName() + " property " + property + "=" + String.valueOf(entry.getValue()));
                    }
                    properties.put(property, entry.getValue());
                }
                if (properties.size() <= 0) continue;
                if (deployment == null) {
                    EjbDeployment ejbDeployment = openejbJar.addEjbDeployment(bean);
                    ejbDeployment.getProperties().putAll((Map<?, ?>)properties);
                    continue;
                }
                deployment.getProperties().putAll((Map<?, ?>)properties);
            }
        }
        this.additionalProperties.clear();
        this.globalProperties.clear();
        return appModule;
    }

    public void addProperties(String id, Properties properties) {
        if (this.additionalProperties.containsKey(id)) {
            this.additionalProperties.get(id).putAll((Map<?, ?>)properties);
        } else {
            this.additionalProperties.put(id, properties);
        }
    }

    public void addGlobalProperties(Properties properties) {
        this.globalProperties.putAll((Map<?, ?>)properties);
    }

    public void addGlobalProperties(String prefix, Properties properties) {
        if (prefix == null || prefix.isEmpty()) {
            this.addGlobalProperties(properties);
        } else {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.globalProperties.put(prefix + "." + String.valueOf(entry.getKey()), entry.getValue());
            }
        }
    }
}

