/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValidator;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.DotEnvConfigSourceProvider;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.LoggingConfigSourceInterceptor;
import io.smallrye.config.NameIterator;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSourceLoader;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SecretKeysConfigSourceInterceptor;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config._private.ConfigMessages;
import jakarta.annotation.Priority;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfigBuilder
implements ConfigBuilder {
    private final List<SmallRyeConfigBuilderCustomizer> customizers = new ArrayList<SmallRyeConfigBuilderCustomizer>();
    private final List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private final List<ConfigSourceProvider> sourceProviders = new ArrayList<ConfigSourceProvider>();
    private final Map<Type, ConverterWithPriority> converters = new HashMap<Type, ConverterWithPriority>();
    private final List<String> profiles = new ArrayList<String>();
    private final Set<String> secretKeys = new HashSet<String>();
    private final List<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
    private final List<SecretKeysHandlerWithName> secretKeysHandlers = new ArrayList<SecretKeysHandlerWithName>();
    private ConfigValidator validator = ConfigValidator.EMPTY;
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final MappingBuilder mappingsBuilder = new MappingBuilder();
    private ClassLoader classLoader = SecuritySupport.getContextClassLoader();
    private boolean addDiscoveredCustomizers = false;
    private boolean addDefaultSources = false;
    private boolean addSystemSources = false;
    private boolean addPropertiesSources = false;
    private boolean addDefaultInterceptors = false;
    private boolean addDiscoveredSources = false;
    private boolean addDiscoveredConverters = false;
    private boolean addDiscoveredInterceptors = false;
    private boolean addDiscoveredSecretKeysHandlers = false;
    private boolean addDiscoveredValidator = false;

    public SmallRyeConfigBuilder addDiscoveredCustomizers() {
        this.addDiscoveredCustomizers = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredSources() {
        this.addDiscoveredSources = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredConverters() {
        this.addDiscoveredConverters = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredInterceptors() {
        this.addDiscoveredInterceptors = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredSecretKeysHandlers() {
        this.addDiscoveredSecretKeysHandlers = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredValidator() {
        this.addDiscoveredValidator = true;
        return this;
    }

    List<ConfigSource> discoverSources() {
        ArrayList<ConfigSource> discoveredSources = new ArrayList<ConfigSource>();
        ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.classLoader);
        for (ConfigSource configSource : configSourceLoader) {
            discoveredSources.add(configSource);
        }
        ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.classLoader);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderLoader) {
            for (ConfigSource configSource : configSourceProvider.getConfigSources(this.classLoader)) {
                discoveredSources.add(configSource);
            }
        }
        ServiceLoader<ConfigSourceFactory> serviceLoader = ServiceLoader.load(ConfigSourceFactory.class, this.classLoader);
        for (ConfigSourceFactory factory : serviceLoader) {
            discoveredSources.add(new ConfigurableConfigSource(factory));
        }
        return discoveredSources;
    }

    List<Converter<?>> discoverConverters() {
        ArrayList discoveredConverters = new ArrayList();
        for (Converter converter : ServiceLoader.load(Converter.class, this.classLoader)) {
            discoveredConverters.add(converter);
        }
        return discoveredConverters;
    }

    List<InterceptorWithPriority> discoverInterceptors() {
        ArrayList<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
        ServiceLoader<ConfigSourceInterceptor> interceptorLoader = ServiceLoader.load(ConfigSourceInterceptor.class, this.classLoader);
        for (ConfigSourceInterceptor configSourceInterceptor : interceptorLoader) {
            interceptors.add(new InterceptorWithPriority(configSourceInterceptor));
        }
        ServiceLoader<ConfigSourceInterceptorFactory> interceptorFactoryLoader = ServiceLoader.load(ConfigSourceInterceptorFactory.class, this.classLoader);
        for (ConfigSourceInterceptorFactory interceptor : interceptorFactoryLoader) {
            interceptors.add(new InterceptorWithPriority(interceptor));
        }
        return interceptors;
    }

    ConfigValidator discoverValidator() {
        ServiceLoader<ConfigValidator> validatorLoader = ServiceLoader.load(ConfigValidator.class, this.classLoader);
        Iterator<ConfigValidator> iterator = validatorLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return ConfigValidator.EMPTY;
    }

    public SmallRyeConfigBuilder addDefaultSources() {
        this.addDefaultSources = true;
        return this;
    }

    public SmallRyeConfigBuilder addSystemSources() {
        this.addSystemSources = true;
        return this;
    }

    public SmallRyeConfigBuilder addPropertiesSources() {
        this.addPropertiesSources = true;
        return this;
    }

    protected List<ConfigSource> getDefaultSources() {
        ArrayList<ConfigSource> defaultSources = new ArrayList<ConfigSource>();
        defaultSources.addAll(this.getSystemSources());
        defaultSources.addAll(this.getPropertiesSources());
        return defaultSources;
    }

    protected List<ConfigSource> getSystemSources() {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        sources.add((ConfigSource)new SysPropConfigSource());
        sources.add((ConfigSource)new EnvConfigSource());
        sources.addAll((Collection<ConfigSource>)new DotEnvConfigSourceProvider().getConfigSources(this.classLoader));
        return sources;
    }

    protected List<ConfigSource> getPropertiesSources() {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        sources.addAll(PropertiesConfigSourceLoader.inFileSystem(Paths.get(System.getProperty("user.dir"), "config", "application.properties").toUri().toString(), 260, this.classLoader));
        sources.addAll(PropertiesConfigSourceLoader.inClassPath("application.properties", 250, this.classLoader));
        sources.addAll(PropertiesConfigSourceLoader.inClassPath("META-INF/microprofile-config.properties", 100, this.classLoader));
        return sources;
    }

    public SmallRyeConfigBuilder addDefaultInterceptors() {
        this.addDefaultInterceptors = true;
        return this;
    }

    List<InterceptorWithPriority> getDefaultInterceptors() {
        ArrayList<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                if (SmallRyeConfigBuilder.this.profiles.isEmpty()) {
                    SmallRyeConfigBuilder.this.profiles.addAll(this.getProfile(context));
                }
                return new ProfileConfigSourceInterceptor(SmallRyeConfigBuilder.this.profiles);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3200);
            }

            private List<String> getProfile(ConfigSourceInterceptorContext context) {
                LinkedHashSet<String> profiles = new LinkedHashSet<String>();
                profiles.addAll(this.getProfiles(context, "smallrye.config.profile.parent"));
                profiles.addAll(this.getProfiles(context, "smallrye.config.profile"));
                return new ArrayList<String>(profiles);
            }

            private List<String> getProfiles(ConfigSourceInterceptorContext context, String propertyName) {
                ArrayList<String> profiles = new ArrayList<String>();
                ConfigValue profileValue = context.proceed(propertyName);
                if (profileValue != null) {
                    List<String> convertProfiles = ProfileConfigSourceInterceptor.convertProfile(profileValue.getValue());
                    for (String profile : convertProfiles) {
                        profiles.addAll(this.getProfiles(context, "%" + profile + ".smallrye.config.profile.parent"));
                        profiles.add(profile);
                    }
                }
                return profiles;
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> relocations = new HashMap<String, String>();
                relocations.put("smallrye.config.profile", "mp.config.profile");
                ArrayList<MultipleProfileProperty> multipleProfileProperties = new ArrayList<MultipleProfileProperty>();
                Iterator<String> names = context.iterateNames();
                while (names.hasNext()) {
                    NameIterator ni;
                    String profileSegment;
                    List<String> profiles;
                    String name = names.next();
                    if (name.isEmpty() || name.charAt(0) != '%' || (profiles = ProfileConfigSourceInterceptor.convertProfile((profileSegment = (ni = new NameIterator(name)).getNextSegment()).substring(1))).size() <= 1) continue;
                    multipleProfileProperties.add(new MultipleProfileProperty(name, name.substring(profileSegment.length()), profiles));
                }
                for (MultipleProfileProperty multipleProfileProperty : multipleProfileProperties) {
                    for (String profile : multipleProfileProperty.getProfiles()) {
                        relocations.putIfAbsent("%" + profile + multipleProfileProperty.getRelocateName(), multipleProfileProperty.getName());
                    }
                }
                return new RelocateConfigSourceInterceptor(relocations);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3199);
            }

            class MultipleProfileProperty
            implements Comparable<MultipleProfileProperty> {
                private final String name;
                private final String relocateName;
                private final List<String> profiles;

                public MultipleProfileProperty(String name, String relocateName, List<String> profiles) {
                    this.name = name;
                    this.relocateName = relocateName;
                    this.profiles = profiles;
                }

                public String getName() {
                    return this.name;
                }

                public String getRelocateName() {
                    return this.relocateName;
                }

                public List<String> getProfiles() {
                    return this.profiles;
                }

                @Override
                public int compareTo(MultipleProfileProperty o) {
                    return Integer.compare(this.getProfiles().size(), o.getProfiles().size());
                }
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(final ConfigSourceInterceptorContext context) {
                boolean expressions = true;
                ConfigValue expressionsValue = context.proceed("mp.config.property.expressions.enabled");
                if (expressionsValue != null) {
                    expressions = Boolean.parseBoolean(expressionsValue.getValue());
                }
                ArrayList<SecretKeysHandler> secretKeysHandlers = new ArrayList<SecretKeysHandler>();
                for (SecretKeysHandlerWithName secretKeysHandler : SmallRyeConfigBuilder.this.secretKeysHandlers) {
                    secretKeysHandlers.add(secretKeysHandler.getSecretKeysHandler(new ConfigSourceContext(){

                        @Override
                        public ConfigValue getValue(String name) {
                            return new ExpressionConfigSourceInterceptor().getValue(context, name);
                        }

                        @Override
                        public Iterator<String> iterateNames() {
                            return context.iterateNames();
                        }
                    }));
                }
                if (SmallRyeConfigBuilder.this.isAddDiscoveredSecretKeysHandlers()) {
                    secretKeysHandlers.addAll(this.discoverSecretKeysHandlers(context));
                }
                return new ExpressionConfigSourceInterceptor(expressions, secretKeysHandlers);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3300);
            }

            private List<String> getEnabledHandlers(ConfigSourceInterceptorContext context) {
                ConfigValue enabledHandlers = context.proceed("smallrye.config.secret-handlers");
                if (enabledHandlers == null || enabledHandlers.getValue().equals("all")) {
                    return List.of();
                }
                List<String> handlers = (List<String>)Converters.newCollectionConverter(Converters.newTrimmingConverter(Converters.STRING_CONVERTER), ArrayList::new).convert(enabledHandlers.getValue());
                return handlers != null ? handlers : List.of();
            }

            private List<SecretKeysHandler> discoverSecretKeysHandlers(final ConfigSourceInterceptorContext context) {
                List<String> enabledHandlers = this.getEnabledHandlers(context);
                ArrayList<SecretKeysHandler> discoveredHandlers = new ArrayList<SecretKeysHandler>();
                ServiceLoader<SecretKeysHandler> secretKeysHandlers = ServiceLoader.load(SecretKeysHandler.class, SmallRyeConfigBuilder.this.classLoader);
                for (SecretKeysHandler secretKeysHandler : secretKeysHandlers) {
                    if (!enabledHandlers.isEmpty() && !enabledHandlers.contains(secretKeysHandler.getName())) continue;
                    discoveredHandlers.add(secretKeysHandler);
                }
                ServiceLoader<SecretKeysHandlerFactory> secretKeysHandlerFactories = ServiceLoader.load(SecretKeysHandlerFactory.class, SmallRyeConfigBuilder.this.classLoader);
                for (SecretKeysHandlerFactory secretKeysHandlerFactory : secretKeysHandlerFactories) {
                    if (!enabledHandlers.isEmpty() && !enabledHandlers.contains(secretKeysHandlerFactory.getName())) continue;
                    discoveredHandlers.add(secretKeysHandlerFactory.getSecretKeysHandler(new ConfigSourceContext(){

                        @Override
                        public ConfigValue getValue(String name) {
                            return context.proceed(name);
                        }

                        @Override
                        public Iterator<String> iterateNames() {
                            return context.iterateNames();
                        }
                    }));
                }
                return discoveredHandlers;
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new SecretKeysConfigSourceInterceptor(SmallRyeConfigBuilder.this.secretKeys);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3100);
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                boolean enabled = false;
                ConfigValue enabledValue = context.proceed("smallrye.config.log.values");
                if (enabledValue != null) {
                    enabled = Boolean.parseBoolean(enabledValue.getValue());
                }
                return new LoggingConfigSourceInterceptor(enabled);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3250);
            }
        }));
        return interceptors;
    }

    public SmallRyeConfigBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SmallRyeConfigBuilder withCustomizers(SmallRyeConfigBuilderCustomizer ... customizers) {
        Collections.addAll(this.customizers, customizers);
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSource ... configSources) {
        Collections.addAll(this.sources, configSources);
        return this;
    }

    public SmallRyeConfigBuilder withSources(Collection<ConfigSource> configSources) {
        this.sources.addAll(configSources);
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSourceProvider provider) {
        this.sourceProviders.add(provider);
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSourceFactory ... configSourceFactories) {
        for (ConfigSourceFactory configSourceFactory : configSourceFactories) {
            this.sources.add(new ConfigurableConfigSource(configSourceFactory));
        }
        return this;
    }

    public SmallRyeConfigBuilder withInterceptors(ConfigSourceInterceptor ... interceptors) {
        for (ConfigSourceInterceptor interceptor : interceptors) {
            this.interceptors.add(new InterceptorWithPriority(interceptor));
        }
        return this;
    }

    public SmallRyeConfigBuilder withInterceptorFactories(ConfigSourceInterceptorFactory ... interceptorFactories) {
        for (ConfigSourceInterceptorFactory interceptorFactory : interceptorFactories) {
            this.interceptors.add(new InterceptorWithPriority(interceptorFactory));
        }
        return this;
    }

    public SmallRyeConfigBuilder withSecretKeysHandlers(SecretKeysHandler ... secretKeysHandlers) {
        for (SecretKeysHandler secretKeysHandler : secretKeysHandlers) {
            this.secretKeysHandlers.add(new SecretKeysHandlerWithName(secretKeysHandler));
        }
        return this;
    }

    public SmallRyeConfigBuilder withSecretKeyHandlerFactories(SecretKeysHandlerFactory ... secretKeyHandlerFactories) {
        for (SecretKeysHandlerFactory secretKeyHandlerFactory : secretKeyHandlerFactories) {
            this.secretKeysHandlers.add(new SecretKeysHandlerWithName(secretKeyHandlerFactory));
        }
        return this;
    }

    public SmallRyeConfigBuilder withProfile(String profile) {
        this.addDefaultInterceptors();
        this.profiles.addAll(ProfileConfigSourceInterceptor.convertProfile(profile));
        return this;
    }

    public SmallRyeConfigBuilder withProfiles(List<String> profiles) {
        this.addDefaultInterceptors();
        this.profiles.addAll(profiles);
        return this;
    }

    public SmallRyeConfigBuilder withSecretKeys(String ... keys) {
        this.secretKeys.addAll(Stream.of(keys).collect(Collectors.toSet()));
        return this;
    }

    public SmallRyeConfigBuilder withDefaultValue(String name, String value) {
        this.defaultValues.put(name, value);
        return this;
    }

    public SmallRyeConfigBuilder withDefaultValues(Map<String, String> defaultValues) {
        this.defaultValues.putAll(defaultValues);
        return this;
    }

    public SmallRyeConfigBuilder withMapping(Class<?> klass) {
        return this.withMapping(ConfigMappings.ConfigClass.configClass(klass));
    }

    public SmallRyeConfigBuilder withMapping(ConfigMappings.ConfigClass configClass) {
        this.mappingsBuilder.mapping(configClass);
        return this;
    }

    public SmallRyeConfigBuilder withMapping(Class<?> klass, String prefix) {
        this.mappingsBuilder.mapping(klass, prefix);
        return this;
    }

    public SmallRyeConfigBuilder withMappingIgnore(String path) {
        this.mappingsBuilder.ignoredPath(path);
        return this;
    }

    public SmallRyeConfigBuilder withValidateUnknown(boolean validateUnknown) {
        this.withDefaultValue("smallrye.config.mapping.validate-unknown", Boolean.toString(validateUnknown));
        return this;
    }

    public SmallRyeConfigBuilder withValidator(ConfigValidator validator) {
        this.validator = validator;
        return this;
    }

    public SmallRyeConfigBuilder withConverters(Converter<?>[] converters) {
        for (Converter<?> converter : converters) {
            Type type = Converters.getConverterType(converter.getClass());
            if (type == null) {
                throw ConfigMessages.msg.unableToAddConverter(converter);
            }
            SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, this.converters);
        }
        return this;
    }

    public <T> SmallRyeConfigBuilder withConverter(Class<T> type, int priority, Converter<T> converter) {
        SmallRyeConfigBuilder.addConverter(type, priority, converter, this.converters);
        return this;
    }

    static void addConverter(Type type, Converter<?> converter, Map<Type, ConverterWithPriority> converters) {
        SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, converters);
    }

    static void addConverter(Type type, int priority, Converter<?> converter, Map<Type, ConverterWithPriority> converters) {
        ConverterWithPriority oldConverter = converters.get(type);
        if (oldConverter == null || priority > oldConverter.priority) {
            converters.put(type, new ConverterWithPriority(converter, priority));
        }
    }

    private static int getPriority(Converter<?> converter) {
        int priority = 100;
        Priority priorityAnnotation = converter.getClass().getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            priority = priorityAnnotation.value();
        }
        return priority;
    }

    public List<ConfigSource> getSources() {
        return this.sources;
    }

    public List<ConfigSourceProvider> getSourceProviders() {
        return this.sourceProviders;
    }

    public Map<Type, ConverterWithPriority> getConverters() {
        return this.converters;
    }

    public List<InterceptorWithPriority> getInterceptors() {
        return this.interceptors;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public ConfigValidator getValidator() {
        if (this.isAddDiscoveredValidator()) {
            this.validator = this.discoverValidator();
        }
        return this.validator;
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    public MappingBuilder getMappingsBuilder() {
        return this.mappingsBuilder;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isAddDiscoveredCustomizers() {
        return this.addDiscoveredCustomizers;
    }

    public boolean isAddDefaultSources() {
        return this.addDefaultSources;
    }

    public boolean isAddSystemSources() {
        return this.addSystemSources;
    }

    public boolean isAddPropertiesSources() {
        return this.addPropertiesSources;
    }

    public boolean isAddDefaultInterceptors() {
        return this.addDefaultInterceptors;
    }

    public boolean isAddDiscoveredSources() {
        return this.addDiscoveredSources;
    }

    public boolean isAddDiscoveredConverters() {
        return this.addDiscoveredConverters;
    }

    public boolean isAddDiscoveredInterceptors() {
        return this.addDiscoveredInterceptors;
    }

    public boolean isAddDiscoveredSecretKeysHandlers() {
        return this.addDiscoveredSecretKeysHandlers;
    }

    public boolean isAddDiscoveredValidator() {
        return this.addDiscoveredValidator;
    }

    public SmallRyeConfigBuilder setAddDefaultSources(boolean addDefaultSources) {
        this.addDefaultSources = addDefaultSources;
        return this;
    }

    public SmallRyeConfigBuilder setAddSystemSources(boolean addSystemSources) {
        this.addSystemSources = addSystemSources;
        return this;
    }

    public SmallRyeConfigBuilder setAddPropertiesSources(boolean addPropertiesSources) {
        this.addPropertiesSources = addPropertiesSources;
        return this;
    }

    public SmallRyeConfigBuilder setAddDefaultInterceptors(boolean addDefaultInterceptors) {
        this.addDefaultInterceptors = addDefaultInterceptors;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredSources(boolean addDiscoveredSources) {
        this.addDiscoveredSources = addDiscoveredSources;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredConverters(boolean addDiscoveredConverters) {
        this.addDiscoveredConverters = addDiscoveredConverters;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredInterceptors(boolean addDiscoveredInterceptors) {
        this.addDiscoveredInterceptors = addDiscoveredInterceptors;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredSecretKeysHandlers(boolean addDiscoveredSecretKeysHandlers) {
        this.addDiscoveredSecretKeysHandlers = addDiscoveredSecretKeysHandlers;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredValidator(boolean addDiscoveredValidator) {
        this.addDiscoveredValidator = addDiscoveredValidator;
        return this;
    }

    public SmallRyeConfig build() {
        if (this.addDiscoveredCustomizers) {
            for (SmallRyeConfigBuilderCustomizer customizer2 : ServiceLoader.load(SmallRyeConfigBuilderCustomizer.class, this.classLoader)) {
                this.customizers.add(customizer2);
            }
        }
        this.customizers.stream().sorted(Comparator.comparingInt(SmallRyeConfigBuilderCustomizer::priority)).forEach(customizer -> customizer.configBuilder(this));
        return new SmallRyeConfig(this);
    }

    public final class MappingBuilder {
        private final Map<Class<?>, Set<String>> mappings = new HashMap();
        private final List<String> ignoredPaths = new ArrayList<String>();
        private final StringBuilder sb = new StringBuilder();

        public void mapping(ConfigMappings.ConfigClass configClass) {
            this.validateAnnotations(configClass.getKlass());
            this.mapping(configClass.getKlass(), configClass.getPrefix());
        }

        public void mapping(Class<?> type, String prefix) {
            Assert.checkNotNullParam((String)"type", type);
            Assert.checkNotNullParam((String)"path", (Object)prefix);
            Class<?> mappingClass = ConfigMappingLoader.getConfigMappingClass(type);
            if (ConfigMappingLoader.ConfigMappingClass.getConfigurationClass(type) != null) {
                this.ignoredPaths.add((String)(prefix.isEmpty() ? "*" : prefix + ".**"));
            }
            this.mappings.computeIfAbsent(mappingClass, k -> new HashSet(4)).add(prefix);
            this.sb.setLength(0);
            this.sb.append(prefix);
            for (Map.Entry<String, String> defaultEntry : ConfigMappingLoader.configMappingDefaults(mappingClass).entrySet()) {
                String path = defaultEntry.getKey();
                String name = prefix.isEmpty() ? path : (path.isEmpty() ? prefix : (path.charAt(0) == '[' ? this.sb.append(path).toString() : this.sb.append(".").append(path).toString()));
                this.sb.setLength(prefix.length());
                SmallRyeConfigBuilder.this.defaultValues.putIfAbsent(name, defaultEntry.getValue());
            }
        }

        public void ignoredPath(String ignoredPath) {
            Assert.checkNotNullParam((String)"ignoredPath", (Object)ignoredPath);
            this.ignoredPaths.add(ignoredPath);
        }

        public Map<Class<?>, Set<String>> getMappings() {
            return this.mappings;
        }

        public List<String> getIgnoredPaths() {
            return this.ignoredPaths;
        }

        private void validateAnnotations(Class<?> type) {
            if (!type.isInterface() && type.isAnnotationPresent(ConfigMapping.class)) {
                throw ConfigMessages.msg.mappingAnnotationNotSupportedInClass(type);
            }
            if (type.isInterface() && type.isAnnotationPresent(ConfigProperties.class)) {
                throw ConfigMessages.msg.propertiesAnnotationNotSupportedInInterface(type);
            }
        }
    }

    static class InterceptorWithPriority
    implements Comparable<InterceptorWithPriority> {
        private final ConfigSourceInterceptorFactory factory;
        private final int priority;

        InterceptorWithPriority(final ConfigSourceInterceptor interceptor) {
            this(new ConfigSourceInterceptorFactory(){

                @Override
                public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                    return interceptor;
                }

                @Override
                public OptionalInt getPriority() {
                    OptionalInt priority = ConfigSourceInterceptorFactory.super.getPriority();
                    if (priority.isPresent()) {
                        return priority;
                    }
                    return OptionalInt.of(InterceptorWithPriority.getPriority(interceptor.getClass()));
                }
            });
        }

        InterceptorWithPriority(ConfigSourceInterceptorFactory factory) {
            this.factory = factory;
            this.priority = factory.getPriority().orElse(5000);
        }

        ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
            return this.factory.getInterceptor(context);
        }

        int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(InterceptorWithPriority other) {
            return Integer.compare(this.priority, other.priority);
        }

        private static int getPriority(Class<? extends ConfigSourceInterceptor> klass) {
            Priority priorityAnnotation = klass.getAnnotation(Priority.class);
            if (priorityAnnotation != null) {
                return priorityAnnotation.value();
            }
            Class<? extends ConfigSourceInterceptor> parentClass = klass.getSuperclass();
            if (ConfigSourceInterceptor.class.isAssignableFrom(parentClass)) {
                return InterceptorWithPriority.getPriority(parentClass);
            }
            return 5000;
        }
    }

    static class SecretKeysHandlerWithName {
        private final SecretKeysHandlerFactory factory;

        SecretKeysHandlerWithName(final SecretKeysHandler secretKeysHandler) {
            this(new SecretKeysHandlerFactory(){

                @Override
                public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
                    return secretKeysHandler;
                }

                @Override
                public String getName() {
                    return secretKeysHandler.getName();
                }
            });
        }

        SecretKeysHandlerWithName(SecretKeysHandlerFactory factory) {
            this.factory = factory;
        }

        SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
            return this.factory.getSecretKeysHandler(context);
        }

        String getName() {
            return this.factory.getName();
        }
    }

    static class ConverterWithPriority {
        private final Converter<?> converter;
        private final int priority;

        private ConverterWithPriority(Converter<?> converter, int priority) {
            this.converter = converter;
            this.priority = priority;
        }

        Converter<?> getConverter() {
            return this.converter;
        }
    }
}

