/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.opentracing;

import io.smallrye.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.util.EnumSet;
import org.apache.openejb.loader.SystemInstance;

@WebListener
public class MicroProfileOpenTracingFinishingFilterInstaller
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if ("none".equals(SystemInstance.get().getOptions().get("tomee.mp.scan", "none"))) {
            return;
        }
        ServletContext servletContext = servletContextEvent.getServletContext();
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter("tracingFilter", (Filter)new SpanFinishingFilter());
        filterRegistration.setAsyncSupported(true);
        filterRegistration.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"*"});
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

