/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import java.io.Serializable;
import java.util.Optional;

public class ConfigValidationException
extends RuntimeException {
    private static final long serialVersionUID = -2637730579475070264L;
    private final Problem[] problems;

    public ConfigValidationException(Problem[] problems) {
        super(ConfigValidationException.list(problems));
        this.problems = problems;
    }

    private static String list(Problem[] problems) {
        StringBuilder b = new StringBuilder();
        b.append("Configuration validation failed").append(':');
        for (int i = 0; i < problems.length; ++i) {
            Problem problem = problems[i];
            Assert.checkNotNullArrayParam((String)"problems", (int)i, (Object)problem);
            b.append(System.lineSeparator());
            b.append("\t");
            b.append(problem.getMessage());
        }
        return b.toString();
    }

    public int getProblemCount() {
        return this.problems.length;
    }

    public Problem getProblem(int index) {
        return this.problems[index];
    }

    public static final class Problem
    implements Serializable {
        public static final Problem[] NO_PROBLEMS = new Problem[0];
        private static final long serialVersionUID = 5984436393578154541L;
        private final String message;
        private final transient RuntimeException exception;

        public Problem(String message) {
            this.message = message;
            this.exception = null;
        }

        Problem(RuntimeException exception) {
            this.message = exception.getMessage();
            this.exception = exception;
        }

        public String getMessage() {
            return this.message;
        }

        Optional<RuntimeException> getException() {
            return Optional.ofNullable(this.exception);
        }
    }
}

