/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.NoSuchProviderException;
import org.apache.openejb.config.provider.ID;
import org.apache.openejb.config.provider.ProviderManager;
import org.apache.openejb.config.provider.ServiceJarXmlLoader;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

public class ServiceUtils {
    public static final String ANY = ServiceUtils.class.getName() + "@ANY";
    public static final String NONE = ServiceUtils.class.getName() + "@NONE";
    public static final String DEFAULT_PROVIDER_URL;
    public static Logger logger;

    private static String currentDefaultProviderUrl(String defaultValue) {
        return SystemInstance.get().getProperty("openejb.provider.default", defaultValue);
    }

    public static ProviderManager getManager() {
        ProviderManager manager = SystemInstance.get().getComponent(ProviderManager.class);
        if (manager != null) {
            return manager;
        }
        SystemInstance.get().setComponent(ProviderManager.class, new ProviderManager(new ServiceJarXmlLoader()));
        return ServiceUtils.getManager();
    }

    public static boolean hasServiceProvider(String id) {
        try {
            ProviderInfo info = ServiceUtils.getProviderInfo(id);
            List<ServiceProvider> services = ServiceUtils.getServiceProviders(info.getPackageName());
            for (ServiceProvider service : services) {
                if (!service.getId().equals(id)) continue;
                return true;
            }
        }
        catch (IllegalStateException | OpenEJBException exception) {
            // empty catch block
        }
        return false;
    }

    public static ServiceProvider getServiceProvider(String idString) throws OpenEJBException {
        ID id = ID.parse(idString, ServiceUtils.currentDefaultProviderUrl(DEFAULT_PROVIDER_URL));
        ServiceProvider provider = ServiceUtils.getManager().get(id.getNamespace(), id.getName());
        if (provider != null) {
            return provider;
        }
        throw new NoSuchProviderException(new Messages("org.apache.openejb.util.resources").format("conf.4901", id.getName(), id.getNamespace()));
    }

    public static String getServiceProviderId(String type) throws OpenEJBException {
        return ServiceUtils.getServiceProviderId(type, null);
    }

    public static String getServiceProviderId(String type, Properties required) throws OpenEJBException {
        ServiceProvider provider = ServiceUtils.getServiceProviderByType(type, required);
        return provider != null ? provider.getId() : null;
    }

    public static List<ServiceProvider> getServiceProvidersByServiceType(String type) throws OpenEJBException {
        ArrayList<ServiceProvider> providers = new ArrayList<ServiceProvider>();
        if (type == null) {
            return providers;
        }
        List<ServiceProvider> services = ServiceUtils.getServiceProviders(ServiceUtils.currentDefaultProviderUrl(DEFAULT_PROVIDER_URL));
        for (ServiceProvider service : services) {
            if (!service.getService().equals(type)) continue;
            providers.add(service);
        }
        return providers;
    }

    public static ServiceProvider getServiceProviderByType(String type, Properties required) throws OpenEJBException {
        if (type == null) {
            return null;
        }
        if (required == null) {
            required = new Properties();
        }
        List<ServiceProvider> services = ServiceUtils.getServiceProviders(ServiceUtils.currentDefaultProviderUrl(DEFAULT_PROVIDER_URL));
        for (ServiceProvider service : services) {
            if (!service.getTypes().contains(type) || !ServiceUtils.implies(required, service.getProperties())) continue;
            return service;
        }
        return null;
    }

    public static boolean implies(Properties required, Properties available) {
        if (available.containsKey("openejb.connector")) {
            return true;
        }
        for (Map.Entry<Object, Object> entry : required.entrySet()) {
            Object value = available.get(entry.getKey());
            Object expected = entry.getValue();
            if (expected.equals(NONE)) {
                if (value == null) continue;
                return false;
            }
            if (expected.equals(ANY)) {
                if (value != null) continue;
                return false;
            }
            if (value instanceof String) {
                value = ((String)value).toLowerCase();
            }
            if (expected instanceof String) {
                expected = ((String)expected).toLowerCase();
            }
            if (expected.equals(value)) continue;
            return false;
        }
        return true;
    }

    public static ServiceProvider getServiceProviderByType(String providerType, String serviceType) throws OpenEJBException {
        if (serviceType == null) {
            return null;
        }
        List<ServiceProvider> services = ServiceUtils.getServiceProvidersByServiceType(providerType);
        for (ServiceProvider service : services) {
            if (!service.getTypes().contains(serviceType)) continue;
            return service;
        }
        return null;
    }

    public static List<ServiceProvider> getServiceProviders() throws OpenEJBException {
        return ServiceUtils.getServiceProviders(ServiceUtils.currentDefaultProviderUrl(DEFAULT_PROVIDER_URL));
    }

    public static List<ServiceProvider> getServiceProviders(String packageName) throws OpenEJBException {
        return ServiceUtils.getManager().load(packageName);
    }

    public static void registerServiceProvider(String packageName, ServiceProvider provider) {
        ServiceUtils.getManager().register(packageName, provider);
    }

    private static ProviderInfo getProviderInfo(String id) {
        String providerName = null;
        String serviceName = null;
        if (id.indexOf(35) != -1) {
            providerName = id.substring(0, id.indexOf(35));
            serviceName = id.substring(id.indexOf(35) + 1);
        } else if (id.indexOf(58) != -1) {
            providerName = id.substring(0, id.indexOf(58));
            serviceName = id.substring(id.indexOf(58) + 1);
        } else {
            providerName = ServiceUtils.currentDefaultProviderUrl(DEFAULT_PROVIDER_URL);
            serviceName = id;
        }
        return new ProviderInfo(providerName, serviceName);
    }

    static {
        String defaultValue = "org.apache.openejb";
        try {
            SystemInstance system = SystemInstance.get();
            if (system.getProperty("openejb.embedded") != null) {
                defaultValue = "org.apache.openejb.embedded";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PROVIDER_URL = defaultValue;
        logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    }

    public static class ProviderInfo {
        private final String packageName;
        private final String serviceName;

        public ProviderInfo(String providerName, String serviceName) {
            this.packageName = providerName;
            this.serviceName = serviceName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }
}

