/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence.jpa.provider;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Map;
import java.util.Properties;
import org.apache.batchee.container.services.persistence.jpa.EntityManagerProvider;

public class DefaultEntityManagerProvider
implements EntityManagerProvider {
    private static final String PERSISTENCE_JPA_PREFIX = "persistence.jpa.property.";
    private EntityManagerFactory emf;
    private Properties config;

    @Override
    public EntityManager newEntityManager() {
        return this.emf.createEntityManager((Map)this.config);
    }

    @Override
    public void release(EntityManager entityManager) {
        entityManager.close();
    }

    @Override
    public void init(Properties batchConfig) {
        this.emf = Persistence.createEntityManagerFactory((String)batchConfig.getProperty("persistence.jpa.unit-name", "batchee"));
        this.config = new Properties();
        for (String key : batchConfig.stringPropertyNames()) {
            if (!key.startsWith(PERSISTENCE_JPA_PREFIX)) continue;
            String realKey = key.substring(PERSISTENCE_JPA_PREFIX.length());
            this.config.setProperty(realKey, batchConfig.getProperty(key));
        }
    }
}

