/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.util.Map;
import org.apache.openejb.core.ThreadContext;

public class ApplicationThreadContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        return new ApplicationThreadContextSnapshot(ThreadContext.getThreadContext());
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return new ApplicationThreadContextSnapshot(null);
    }

    public String getThreadContextType() {
        return "Application";
    }

    public class ApplicationThreadContextSnapshot
    implements ThreadContextSnapshot {
        private final ThreadContext threadContext;

        public ApplicationThreadContextSnapshot(ThreadContext threadContext) {
            this.threadContext = threadContext;
        }

        public ThreadContextRestorer begin() {
            ThreadContext restoreContext = this.threadContext == null ? ThreadContext.clear() : ThreadContext.enter(this.threadContext);
            return new ApplicationThreadContextRestorer(restoreContext);
        }
    }

    public class ApplicationThreadContextRestorer
    implements ThreadContextRestorer {
        private final ThreadContext restoreContext;

        public ApplicationThreadContextRestorer(ThreadContext restoreContext) {
            this.restoreContext = restoreContext;
        }

        public void endContext() throws IllegalStateException {
            if (this.restoreContext != null) {
                ThreadContext.exit(this.restoreContext);
            }
        }
    }
}

