/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class RemoteDescriptor
extends TypeDescriptor {
    private Map method_map;
    private Map refl_method_map;
    private MethodDescriptor[] operations;
    private Class[] remote_interfaces;
    protected List super_descriptors;
    static final Class REMOTE_CLASS = Remote.class;
    static final Class OBJECT_CLASS = Object.class;
    static final Class REMOTE_EXCEPTION = RemoteException.class;
    String[] _ids;

    public RemoteInterfaceDescriptor getRemoteInterface() {
        RemoteInterfaceDescriptor result = super.getRemoteInterface();
        if (result != null) {
            return result;
        }
        if (this instanceof RemoteInterfaceDescriptor) {
            result = (RemoteInterfaceDescriptor)this;
        } else {
            Class[] remotes = this.collect_remote_interfaces(this.getJavaClass());
            if (remotes.length == 0) {
                throw new RuntimeException(this.getJavaClass().getName() + " has no remote interfaces");
            }
            Class most_specific_interface = remotes[0];
            result = (RemoteInterfaceDescriptor)this.repository.getDescriptor(most_specific_interface);
        }
        this.setRemoteInterface(result);
        return result;
    }

    public String[] all_interfaces() {
        if (this._ids == null) {
            Class[] ifaces = this.collect_remote_interfaces(this.getJavaClass());
            int len = ifaces.length;
            String[] ids = new String[len];
            for (int i = 0; i < len; ++i) {
                TypeDescriptor desc = this.repository.getDescriptor(ifaces[i]);
                ids[i] = desc.getRepositoryID();
            }
            this._ids = ids;
        }
        return this._ids;
    }

    public MethodDescriptor getMethod(String idl_name) {
        if (this.operations == null) {
            this.init_methods();
        }
        if (this.method_map == null) {
            this.method_map = new HashMap();
            for (int i = 0; i < this.operations.length; ++i) {
                this.method_map.put(this.operations[i].getIDLName(), this.operations[i]);
            }
        }
        return (MethodDescriptor)this.method_map.get(idl_name);
    }

    void debugMethodMap() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("METHOD MAP FOR " + this.getJavaClass().getName());
            for (String idl_name : this.method_map.keySet()) {
                MethodDescriptor desc = (MethodDescriptor)this.method_map.get(idl_name);
                logger.finer("IDL " + idl_name + " -> " + desc.reflected_method);
            }
        }
    }

    public MethodDescriptor getMethod(Method refl_method) {
        if (this.operations == null) {
            this.init_methods();
        }
        if (this.refl_method_map == null) {
            this.refl_method_map = new HashMap();
            for (int i = 0; i < this.operations.length; ++i) {
                this.refl_method_map.put(this.operations[i].getReflectedMethod(), this.operations[i]);
            }
        }
        return (MethodDescriptor)this.refl_method_map.get(refl_method);
    }

    RemoteDescriptor(Class type, TypeRepository repository) {
        super(type, repository);
    }

    public void init() {
    }

    public MethodDescriptor[] getMethods() {
        if (this.operations == null) {
            this.init_methods();
        }
        return this.operations;
    }

    public synchronized void init_methods() {
        if (this.operations != null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                RemoteDescriptor.this.init_methods0();
                return null;
            }
        });
    }

    private void init_methods0() {
        int i;
        ArrayList<MethodDescriptor> method_list = new ArrayList<MethodDescriptor>();
        Class<?>[] supers = this.getJavaClass().getInterfaces();
        this.super_descriptors = new ArrayList();
        HashMap all_methods = new HashMap();
        HashMap lower_case_names = new HashMap();
        for (int i2 = 0; i2 < supers.length; ++i2) {
            Class<?> iface = supers[i2];
            if (REMOTE_CLASS.equals(iface) || OBJECT_CLASS.equals(iface) || !REMOTE_CLASS.isAssignableFrom(iface) || !iface.isInterface()) continue;
            RemoteDescriptor superHelper = (RemoteDescriptor)this.repository.getDescriptor(iface);
            this.super_descriptors.add(superHelper);
            MethodDescriptor[] superOps = superHelper.getMethods();
            for (int j = 0; j < superOps.length; ++j) {
                MethodDescriptor op = superOps[j];
                method_list.add(op);
                this.addMethodOverloading(all_methods, op.getReflectedMethod());
                this.addMethodCaseSensitive(lower_case_names, op.getReflectedMethod());
            }
        }
        Method[] methods = this.getLocalMethods();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            this.addMethodOverloading(all_methods, methods[i3]);
            this.addMethodCaseSensitive(lower_case_names, methods[i3]);
        }
        HashSet<String> overloaded_names = new HashSet<String>();
        for (Map.Entry entry : all_methods.entrySet()) {
            String mname = (String)entry.getKey();
            Set s = (Set)entry.getValue();
            if (s.size() <= 1) continue;
            overloaded_names.add(mname);
        }
        for (i = 0; i < methods.length; ++i) {
            Set overload_names;
            MethodDescriptor op = new MethodDescriptor(methods[i], this.repository);
            String mname = op.getJavaName();
            Set same_case_names = (Set)lower_case_names.get(mname.toLowerCase());
            if (same_case_names.size() > 1) {
                op.setCaseSensitive(true);
            }
            if ((overload_names = (Set)all_methods.get(mname)).size() > 1) {
                op.setOverloaded(true);
            }
            op.init();
            method_list.add(op);
        }
        this.method_map = new HashMap();
        for (i = 0; i < method_list.size(); ++i) {
            MethodDescriptor desc = (MethodDescriptor)method_list.get(i);
            logger.finer("Adding method " + desc.getJavaName() + " to method map under " + desc.getIDLName());
            this.method_map.put(desc.getIDLName(), desc);
        }
        this.operations = this.method_map.values().toArray(new MethodDescriptor[0]);
        this.debugMethodMap();
    }

    private void addMethodOverloading(Map map, Method m) {
        String mname = m.getName();
        HashSet<String> entry = (HashSet<String>)map.get(mname);
        if (entry == null) {
            entry = new HashSet<String>();
            map.put(mname, entry);
        }
        entry.add(RemoteDescriptor.createMethodSelector(m));
    }

    Method[] getLocalMethods() {
        ArrayList result = new ArrayList();
        this.addNonRemoteInterfaceMethods(this.getJavaClass(), result);
        Method[] out = new Method[result.size()];
        result.toArray(out);
        return out;
    }

    void addNonRemoteInterfaceMethods(Class clz, ArrayList result) {
        Method[] methods;
        try {
            methods = clz.getDeclaredMethods();
        }
        catch (NoClassDefFoundError e) {
            ClassLoader clzClassLoader = clz.getClassLoader();
            logger.log(Level.FINER, "cannot find class " + e.getMessage() + " from " + clz.getName() + " (classloader " + clzClassLoader + "): " + e.getMessage(), e);
            throw e;
        }
        for (int j = 0; j < methods.length; ++j) {
            result.add(methods[j]);
        }
        Class<?>[] ifaces = clz.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (REMOTE_CLASS.isAssignableFrom(ifaces[i])) continue;
            this.addNonRemoteInterfaceMethods(ifaces[i], result);
        }
    }

    boolean isRemoteMethod(Method m) {
        Class<?>[] ex = m.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            if (!REMOTE_EXCEPTION.isAssignableFrom(ex[i])) continue;
            return true;
        }
        return false;
    }

    private static String createMethodSelector(Method m) {
        StringBuffer sb = new StringBuffer(m.getName());
        sb.append('(');
        Class<?>[] parameterTypes = m.getParameterTypes();
        for (int n = 0; n < parameterTypes.length; ++n) {
            sb.append(parameterTypes[n].getName());
            if (n >= parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString().intern();
    }

    private void addMethodCaseSensitive(Map map, Method m) {
        String mname = m.getName();
        String lowname = mname.toLowerCase();
        HashSet<String> entry = (HashSet<String>)map.get(lowname);
        if (entry == null) {
            entry = new HashSet<String>();
            map.put(lowname, entry);
        }
        entry.add(mname);
    }

    private void collect_interfaces(Set s, Class c) {
        Class sup;
        if (c.isInterface() && !REMOTE_CLASS.equals(c)) {
            s.add(c);
        }
        if ((sup = c.getSuperclass()) != null && !OBJECT_CLASS.equals(sup)) {
            this.collect_interfaces(s, sup);
        }
        Class<?>[] supers = c.getInterfaces();
        for (int i = 0; i < supers.length; ++i) {
            Class<?> iface = supers[i];
            if (REMOTE_CLASS.equals(iface) || !REMOTE_CLASS.isAssignableFrom(iface)) continue;
            this.collect_interfaces(s, iface);
        }
    }

    protected Class[] collect_remote_interfaces(Class c) {
        if (this.remote_interfaces != null) {
            return this.remote_interfaces;
        }
        TreeSet s = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                Class c1 = (Class)o1;
                Class c2 = (Class)o2;
                if (c1.equals(c2)) {
                    return 0;
                }
                if (c1.isAssignableFrom(c2)) {
                    return 1;
                }
                if (c2.isAssignableFrom(c1)) {
                    return -1;
                }
                return c1.getName().compareTo(c2.getName());
            }
        });
        this.collect_interfaces(s, c);
        this.remote_interfaces = new Class[s.size()];
        s.toArray(this.remote_interfaces);
        return this.remote_interfaces;
    }

    public Object read(InputStream in) {
        return PortableRemoteObject.narrow((Object)in.read_Object(), (Class)this.getJavaClass());
    }

    public void write(OutputStream out, Object val) {
        Util.writeRemoteObject((OutputStream)out, (Object)val);
    }

    TypeCode getTypeCode() {
        if (this._type_code == null) {
            ORB orb = ORB.init();
            return orb.create_interface_tc(this.getRepositoryID(), this.getJavaClass().getName());
        }
        return this._type_code;
    }

    void writeMarshalValue(PrintWriter pw, String outName, String paramName) {
        pw.print("javax.rmi.CORBA.Util.writeRemoteObject(");
        pw.print(outName);
        pw.print(',');
        pw.print(paramName);
        pw.print(')');
    }

    void writeUnmarshalValue(PrintWriter pw, String inName) {
        pw.print('(');
        pw.print(this.getJavaClass().getName());
        pw.print(')');
        pw.print(PortableRemoteObject.class.getName());
        pw.print(".narrow(");
        pw.print(inName);
        pw.print('.');
        pw.print("read_Object(),");
        pw.print(this.getJavaClass().getName());
        pw.print(".class)");
    }

    static String classNameFromStub(String name) {
        int idx;
        if (name.startsWith("org.omg.stub.")) {
            name = name.substring("org.omg.stub.".length());
        }
        if (name.charAt((idx = name.lastIndexOf(46)) + 1) == '_' && name.endsWith("_Stub")) {
            if (idx == -1) {
                return name.substring(1, name.length() - 5);
            }
            return name.substring(0, idx + 1) + name.substring(idx + 2, name.length() - 5);
        }
        return null;
    }

    static String stubClassName(Class c) {
        String cname = c.getName();
        String pkgname = null;
        int idx = cname.lastIndexOf(46);
        pkgname = idx == -1 ? "org.omg.stub" : "org.omg.stub." + cname.substring(0, idx);
        String cplain = cname.substring(idx + 1);
        return pkgname + "._" + cplain + "_Stub";
    }

    void writeStubClass(PrintWriter pw) {
        Class c = this.getJavaClass();
        String cname = c.getName();
        String fullname = RemoteDescriptor.stubClassName(c);
        String pkgname = fullname.substring(0, fullname.lastIndexOf(46));
        String cplain = cname.substring(cname.lastIndexOf(46) + 1);
        pw.println("/** ");
        pw.println(" *  RMI/IIOP stub for " + cname);
        pw.println(" *  Generated using Apache Yoko stub generator.");
        pw.println(" */");
        pw.println("package " + pkgname + ";\n");
        pw.println("public class _" + cplain + "_Stub");
        pw.println("\textends javax.rmi.CORBA.Stub");
        pw.println("\timplements " + cname);
        pw.println("{");
        String[] all_interfaces = this.all_interfaces();
        pw.println("\tprivate static final String[] _ids = {");
        for (int i = 0; i < all_interfaces.length; ++i) {
            pw.println("\t\t\"" + all_interfaces[i] + "\",");
        }
        pw.println("\t};\n");
        pw.println("\tpublic String[] _ids() {");
        pw.println("\t\treturn _ids;");
        pw.println("\t}");
        MethodDescriptor[] meths = this.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            meths[i].writeStubMethod(pw);
        }
        pw.println("}");
    }

    String getStubClassName() {
        Class c = this.getJavaClass();
        String cname = c.getName();
        String pkgname = null;
        int idx = cname.lastIndexOf(46);
        pkgname = idx == -1 ? "org.omg.stub" : "org.omg.stub." + cname.substring(0, idx);
        String cplain = cname.substring(idx + 1);
        return pkgname + "." + "_" + cplain + "_Stub";
    }

    void addDependencies(Set classes) {
        Class c = this.getJavaClass();
        if (c == Remote.class || classes.contains(c)) {
            return;
        }
        classes.add(c);
        if (c.getSuperclass() != null) {
            TypeDescriptor desc = this.getTypeRepository().getDescriptor(c.getSuperclass());
            desc.addDependencies(classes);
        }
        Class<?>[] ifaces = c.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            TypeDescriptor desc = this.getTypeRepository().getDescriptor(ifaces[i]);
            desc.addDependencies(classes);
        }
        MethodDescriptor[] mths = this.getMethods();
        for (int i = 0; i < mths.length; ++i) {
            mths[i].addDependencies(classes);
        }
    }

    boolean copyInStub() {
        return false;
    }
}

