/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.threads.task.CUTask;

public class ContextServiceImpl
implements ContextService {
    private static final HashMap<String, String> EMPTY_PROPS = new HashMap();
    private final List<ThreadContextProvider> propagated = new ArrayList<ThreadContextProvider>();
    private final List<ThreadContextProvider> cleared = new ArrayList<ThreadContextProvider>();
    private final List<ThreadContextProvider> unchanged = new ArrayList<ThreadContextProvider>();

    public List<ThreadContextProvider> getPropagated() {
        return this.propagated;
    }

    public List<ThreadContextProvider> getCleared() {
        return this.cleared;
    }

    public List<ThreadContextProvider> getUnchanged() {
        return this.unchanged;
    }

    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        return this.createContextualProxy((T)callable, (Class<T>)Callable.class);
    }

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> biConsumer) {
        return this.createContextualProxy((T)biConsumer, (Class<T>)BiConsumer.class);
    }

    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        return this.createContextualProxy((T)consumer, (Class<T>)Consumer.class);
    }

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> biFunction) {
        return this.createContextualProxy((T)biFunction, (Class<T>)BiFunction.class);
    }

    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        return this.createContextualProxy((T)function, (Class<T>)Function.class);
    }

    public Runnable contextualRunnable(Runnable runnable) {
        return this.createContextualProxy((T)runnable, (Class<T>)Runnable.class);
    }

    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        return this.createContextualProxy((T)supplier, (Class<T>)Supplier.class);
    }

    public <T> T createContextualProxy(T instance, Class<T> intf) {
        return intf.cast(this.createContextualProxy(instance, new Class[]{intf}));
    }

    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        return this.createContextualProxy(instance, EMPTY_PROPS, interfaces);
    }

    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        return intf.cast(this.createContextualProxy(instance, executionProperties, new Class[]{intf}));
    }

    public Object createContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)new CUHandler(instance, executionProperties));
    }

    public Executor currentContextExecutor() {
        return command -> this.contextualRunnable(command).run();
    }

    public Map<String, String> getExecutionProperties(Object contextualProxy) {
        return ((CUHandler)CUHandler.class.cast((Object)Proxy.getInvocationHandler((Object)contextualProxy))).properties;
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> completableFuture) {
        return this.createContextualProxy((T)completableFuture, (Class<T>)CompletableFuture.class);
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> completionStage) {
        return this.createContextualProxy((T)completionStage, (Class<T>)CompletionStage.class);
    }

    public Snapshot snapshot(Map<String, String> props) {
        ThreadContextSnapshot snapshot;
        boolean appContextPropagated;
        ArrayList<ThreadContextSnapshot> snapshots = new ArrayList<ThreadContextSnapshot>();
        ThreadContextProvider appContext = this.find("Application", this.propagated);
        if (appContext != null) {
            appContextPropagated = true;
        } else {
            appContext = this.find("Application", this.cleared);
            appContextPropagated = false;
        }
        if (appContext != null) {
            if (appContextPropagated) {
                snapshots.add(appContext.currentContext(props));
            } else {
                snapshots.add(appContext.clearedContext(props));
            }
        }
        for (ThreadContextProvider threadContextProvider : this.propagated) {
            if ("Application".equals(threadContextProvider.getThreadContextType())) continue;
            snapshot = threadContextProvider.currentContext(props);
            snapshots.add(snapshot);
        }
        for (ThreadContextProvider threadContextProvider : this.cleared) {
            if ("Application".equals(threadContextProvider.getThreadContextType())) continue;
            snapshot = threadContextProvider.clearedContext(props);
            snapshots.add(snapshot);
        }
        return new Snapshot(snapshots);
    }

    private ThreadContextProvider find(String name, List<ThreadContextProvider> threadContextProviders) {
        for (ThreadContextProvider threadContextProvider : threadContextProviders) {
            if (!name.equals(threadContextProvider.getThreadContextType())) continue;
            return threadContextProvider;
        }
        return null;
    }

    public State enter(Snapshot snapshot) {
        ArrayList<ThreadContextRestorer> restorers = new ArrayList<ThreadContextRestorer>();
        for (ThreadContextSnapshot tcs : snapshot.getSnapshots()) {
            try {
                restorers.add(0, tcs.begin());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return new State(restorers);
    }

    public void exit(State state) {
        if (state != null) {
            List<ThreadContextRestorer> restorers = state.getRestorers();
            for (ThreadContextRestorer restorer : restorers) {
                restorer.endContext();
            }
        }
    }

    private final class CUHandler
    extends CUTask<Object>
    implements InvocationHandler,
    Serializable {
        private final Object instance;
        private final Map<String, String> properties;
        private final boolean suspendTx;

        private CUHandler(Object instance, Map<String, String> props) {
            super(instance, ContextServiceImpl.this);
            this.instance = instance;
            this.properties = props;
            this.suspendTx = "SUSPEND".equals(props.get("jakarta.enterprise.concurrent.TRANSACTION"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            Transaction suspendedTx = this.suspendTx ? OpenEJB.getTransactionManager().suspend() : null;
            try {
                Object object = this.invoke(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return method.invoke(CUHandler.this.instance, args);
                    }
                });
                return object;
            }
            finally {
                if (suspendedTx != null) {
                    OpenEJB.getTransactionManager().resume(suspendedTx);
                }
            }
        }
    }

    public class Snapshot {
        private final List<ThreadContextSnapshot> snapshots;

        public Snapshot(List<ThreadContextSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        public List<ThreadContextSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }

    public class State {
        private final List<ThreadContextRestorer> restorers;

        public State(List<ThreadContextRestorer> restorers) {
            this.restorers = restorers;
        }

        public List<ThreadContextRestorer> getRestorers() {
            return this.restorers;
        }
    }
}

