/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.thread;

import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.thread.ThreadFactories;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.impl.ContextServiceImplFactory;
import org.apache.openejb.threads.impl.ManagedScheduledExecutorServiceImpl;
import org.apache.openejb.threads.impl.ManagedThreadFactoryImpl;
import org.apache.openejb.threads.reject.CURejectHandler;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ManagedScheduledExecutorServiceImplFactory {
    private int core = 5;
    private String threadFactory = ManagedThreadFactoryImpl.class.getName();
    private String context;

    public ManagedScheduledExecutorServiceImpl create(ContextServiceImpl contextService) {
        return new ManagedScheduledExecutorServiceImpl(this.createScheduledExecutorService(), contextService);
    }

    public ManagedScheduledExecutorServiceImpl create() {
        Object context = this.context == null || this.context.isBlank() ? "java:comp/DefaultContextService" : "openejb/Resource/" + this.context;
        ContextServiceImpl contextService = this.findContextService((String)context);
        if (contextService == null) {
            contextService = ContextServiceImplFactory.newPropagateEverythingContextService();
        }
        return new ManagedScheduledExecutorServiceImpl(this.createScheduledExecutorService(), contextService);
    }

    private ContextServiceImpl findContextService(String contextName) {
        try {
            ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
            if (containerSystem == null) {
                return null;
            }
            Context context = containerSystem.getJNDIContext();
            Object obj = context.lookup(contextName);
            if (!(obj instanceof ContextServiceImpl)) {
                throw new IllegalArgumentException("Resource with id " + context + " is not a ContextService, but is " + obj.getClass().getName());
            }
            return (ContextServiceImpl)obj;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Unknown context service " + contextName);
        }
    }

    private ScheduledExecutorService createScheduledExecutorService() {
        ManagedThreadFactory managedThreadFactory;
        try {
            managedThreadFactory = ThreadFactories.findThreadFactory(this.threadFactory);
        }
        catch (Exception e) {
            Logger.getInstance(LogCategory.OPENEJB, ManagedScheduledExecutorServiceImplFactory.class).warning("Unable to create configured thread factory: " + this.threadFactory, e);
            managedThreadFactory = new ManagedThreadFactoryImpl();
        }
        return new ScheduledThreadPoolExecutor(this.core, (ThreadFactory)managedThreadFactory, CURejectHandler.INSTANCE);
    }

    public void setCore(int core) {
        this.core = core;
    }

    public void setThreadFactory(String threadFactory) {
        this.threadFactory = threadFactory;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}

