/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.AppContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.AppFinder;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class TomEEConfigSource
implements ConfigSource {
    private final Map<String, String> configuration = new HashMap<String, String>();

    public TomEEConfigSource() {
        String mpScan;
        List<String> mpIgnoredApps;
        AppContext appContextOrWeb = (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE);
        if (appContextOrWeb != null && (mpIgnoredApps = Arrays.asList(SystemInstance.get().getProperty("mp.ignored.apps", "ROOT,docs,host-manager,manager").split(","))).stream().anyMatch(s -> s.equalsIgnoreCase(appContextOrWeb.getId()))) {
            this.openTracingFilterActive(false);
            this.metricsJaxRsActive(false);
        }
        if ((mpScan = SystemInstance.get().getOptions().get("tomee.mp.scan", "none")).equals("none")) {
            this.openTracingFilterActive(false);
            this.metricsJaxRsActive(false);
        }
    }

    public Map<String, String> getProperties() {
        return this.configuration;
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.getProperties().keySet());
    }

    public int getOrdinal() {
        return 150;
    }

    public String getValue(String propertyName) {
        return this.configuration.get(propertyName);
    }

    public String getName() {
        return TomEEConfigSource.class.getSimpleName();
    }

    public void openTracingFilterActive(boolean active) {
        this.configuration.put("geronimo.opentracing.filter.active", Boolean.toString(active));
    }

    public void metricsJaxRsActive(boolean active) {
        this.configuration.put("geronimo.metrics.jaxrs.activated", Boolean.toString(active));
    }
}

