/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.ValidatorMapping;
import org.apache.bval.jsr.metadata.ValidatorMappingProvider;
import org.apache.bval.util.Validate;

public class CompositeValidatorMappingProvider
extends ValidatorMappingProvider {
    private final List<ValidatorMappingProvider> delegates;

    public CompositeValidatorMappingProvider(List<ValidatorMappingProvider> delegates) {
        this.delegates = Validate.notNull(delegates, "delegates", new Object[0]);
        Validate.isTrue(!delegates.isEmpty(), "no delegates specified", new Object[0]);
        Validate.isTrue(delegates.stream().noneMatch(Objects::isNull), "One or more supplied delegates was null", new Object[0]);
    }

    @Override
    protected <A extends Annotation> ValidatorMapping<A> doGetValidatorMapping(Class<A> constraintType) {
        return ValidatorMapping.merge(this.delegates.stream().map(d -> d.doGetValidatorMapping(constraintType)).filter(Objects::nonNull).collect(Collectors.toList()), AnnotationBehaviorMergeStrategy.consensus());
    }
}

