/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;

public class SecurityThreadContextProvider
implements ThreadContextProvider {
    private static final SecurityService SECURITY_SERVICE = SystemInstance.get().getComponent(SecurityService.class);

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        boolean associate = false;
        Object state = SECURITY_SERVICE.currentState();
        if (state == null) {
            state = ClientSecurity.getIdentity();
            associate = state != null;
        }
        Object securityServiceState = state;
        AbstractSecurityService.SecurityContext sc = this.getSecurityContext();
        return new SecurityThreadContextSnapshot(associate, securityServiceState, sc);
    }

    private AbstractSecurityService.SecurityContext getSecurityContext() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        if (threadContext == null) {
            return null;
        }
        if (threadContext.getBeanContext() == null) {
            return threadContext.get(AbstractSecurityService.SecurityContext.class);
        }
        BeanContext beanContext = threadContext.getBeanContext();
        if (beanContext.getRunAs() == null && beanContext.getRunAsUser() == null) {
            return threadContext.get(AbstractSecurityService.SecurityContext.class);
        }
        AbstractSecurityService securityService = (AbstractSecurityService)AbstractSecurityService.class.cast(SECURITY_SERVICE);
        return new AbstractSecurityService.SecurityContext(securityService.getRunAsSubject(beanContext));
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return new SecurityThreadContextSnapshot(false, null, null);
    }

    public String getThreadContextType() {
        return "Security";
    }

    public class SecurityThreadContextSnapshot
    implements ThreadContextSnapshot {
        private final boolean associate;
        private final Object securityServiceState;
        private final AbstractSecurityService.SecurityContext sc;

        public SecurityThreadContextSnapshot(boolean associate, Object securityServiceState, AbstractSecurityService.SecurityContext sc) {
            this.associate = associate;
            this.securityServiceState = securityServiceState;
            this.sc = sc;
        }

        public ThreadContextRestorer begin() {
            ThreadContext oldCtx;
            Object threadState;
            if (this.associate) {
                try {
                    SECURITY_SERVICE.associate(this.securityServiceState);
                }
                catch (LoginException e) {
                    throw new IllegalStateException(e);
                }
                threadState = null;
            } else {
                threadState = SECURITY_SERVICE.currentState();
                SECURITY_SERVICE.setState(this.securityServiceState);
            }
            ThreadContext threadContext = ThreadContext.getThreadContext();
            if (threadContext != null) {
                ThreadContext newContext = new ThreadContext(threadContext);
                oldCtx = ThreadContext.enter(newContext);
                if (this.sc != null) {
                    newContext.set(AbstractSecurityService.SecurityContext.class, this.sc);
                }
            } else {
                oldCtx = null;
            }
            return new SecurityThreadContextRestorer(this.associate, oldCtx, threadState);
        }
    }

    public class SecurityThreadContextRestorer
    implements ThreadContextRestorer {
        private final boolean associate;
        private final ThreadContext oldCtx;
        private final Object threadState;

        public SecurityThreadContextRestorer(boolean associate, ThreadContext oldCtx, Object threadState) {
            this.associate = associate;
            this.oldCtx = oldCtx;
            this.threadState = threadState;
        }

        public void endContext() throws IllegalStateException {
            if (this.oldCtx != null) {
                ThreadContext.exit(this.oldCtx);
            }
            if (!this.associate) {
                SECURITY_SERVICE.setState(this.threadState);
            } else {
                SECURITY_SERVICE.disassociate();
            }
        }
    }
}

