/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.openejb.threads.impl.ApplicationThreadContextProvider;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.impl.SecurityThreadContextProvider;
import org.apache.openejb.threads.impl.TxThreadContextProvider;
import org.apache.openejb.util.Join;

public class ContextServiceImplFactory {
    private final List<String> propagated = new ArrayList<String>();
    private final List<String> cleared = new ArrayList<String>();
    private final List<String> unchanged = new ArrayList<String>();

    public String getPropagated() {
        return Join.join(",", this.propagated);
    }

    public void setPropagated(String propagated) {
        this.propagated.clear();
        if (propagated != null && propagated.length() > 0) {
            this.propagated.addAll(Arrays.asList(propagated.split(" *, *")));
        }
    }

    public String getCleared() {
        return Join.join(",", this.cleared);
    }

    public void setCleared(String cleared) {
        this.cleared.clear();
        if (cleared != null && cleared.length() > 0) {
            this.cleared.addAll(Arrays.asList(cleared.split(" *, *")));
        }
    }

    public String getUnchanged() {
        return Join.join(",", this.unchanged);
    }

    public void setUnchanged(String unchanged) {
        this.unchanged.clear();
        if (unchanged != null && unchanged.length() > 0) {
            this.unchanged.addAll(Arrays.asList(unchanged.split(" *, *")));
        }
    }

    public static ContextServiceImpl newDefaultContextService() {
        return new ContextServiceImplFactory().create();
    }

    public static ContextServiceImpl newPropagateEverythingContextService() {
        ContextServiceImplFactory factory = new ContextServiceImplFactory();
        factory.setPropagated("Remaining");
        return factory.create();
    }

    public ContextServiceImpl create() {
        HashMap<String, ThreadContextProvider> threadContextProviders = new HashMap<String, ThreadContextProvider>();
        threadContextProviders.put("Application", new ApplicationThreadContextProvider());
        threadContextProviders.put("Security", new SecurityThreadContextProvider());
        threadContextProviders.put("Transaction", new TxThreadContextProvider());
        this.getThreadContextProviders().forEach(t -> threadContextProviders.putIfAbsent(t.getThreadContextType(), (ThreadContextProvider)t));
        ArrayList<ThreadContextProvider> resolvedPropagated = new ArrayList<ThreadContextProvider>();
        ArrayList<ThreadContextProvider> resolvedCleared = new ArrayList<ThreadContextProvider>();
        ArrayList<ThreadContextProvider> resolvedUnchanged = new ArrayList<ThreadContextProvider>();
        this.resolve(resolvedPropagated, this.propagated, threadContextProviders);
        this.resolve(resolvedCleared, this.cleared, threadContextProviders);
        this.resolve(resolvedUnchanged, this.unchanged, threadContextProviders);
        if (this.propagated.contains("Remaining")) {
            resolvedPropagated.addAll(threadContextProviders.values());
            threadContextProviders.clear();
        }
        if (this.cleared.contains("Remaining")) {
            resolvedCleared.addAll(threadContextProviders.values());
            threadContextProviders.clear();
        }
        if (this.unchanged.contains("Remaining")) {
            resolvedUnchanged.addAll(threadContextProviders.values());
            threadContextProviders.clear();
        }
        if (threadContextProviders.containsKey("Transaction")) {
            resolvedCleared.add((ThreadContextProvider)threadContextProviders.remove("Transaction"));
        }
        resolvedPropagated.addAll(threadContextProviders.values());
        threadContextProviders.clear();
        ContextServiceImpl contextService = new ContextServiceImpl();
        contextService.getPropagated().addAll(resolvedPropagated);
        contextService.getCleared().addAll(resolvedCleared);
        contextService.getUnchanged().addAll(resolvedUnchanged);
        return contextService;
    }

    protected List<ThreadContextProvider> getThreadContextProviders() {
        ArrayList<ThreadContextProvider> result = new ArrayList<ThreadContextProvider>();
        for (ThreadContextProvider tcp : ServiceLoader.load(ThreadContextProvider.class)) {
            result.add(tcp);
        }
        return result;
    }

    private void resolve(List<ThreadContextProvider> providers, List<String> specified, Map<String, ThreadContextProvider> availableProviders) {
        for (String specifiedProviderName : specified) {
            if (!availableProviders.containsKey(specifiedProviderName)) continue;
            providers.add(availableProviders.remove(specifiedProviderName));
        }
    }
}

