/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openejb.jee.AbsoluteOrdering;
import org.apache.openejb.jee.ContextService;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.Empty;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.ErrorPage;
import org.apache.openejb.jee.Filter;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.JMSConnectionFactory;
import org.apache.openejb.jee.JMSDestination;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.Lifecycle;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.LocaleEncodingMappingList;
import org.apache.openejb.jee.LoginConfig;
import org.apache.openejb.jee.MessageDestination;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.MimeMapping;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SecurityConstraint;
import org.apache.openejb.jee.SecurityRole;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.SessionConfig;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;
import org.apache.openejb.jee.WebCommon;
import org.apache.openejb.jee.WelcomeFileList;

@XmlRootElement(name="web-app")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="web-appType", propOrder={"descriptions", "displayNames", "icon", "distributable", "contextParam", "filter", "filterMapping", "listener", "servlet", "servletMapping", "defaultContextPath", "sessionConfig", "mimeMapping", "welcomeFileList", "errorPage", "taglib", "jspConfig", "securityConstraint", "loginConfig", "securityRole", "localeEncodingMappingList", "envEntry", "ejbRef", "ejbLocalRef", "serviceRef", "resourceRef", "resourceEnvRef", "messageDestinationRef", "persistenceContextRef", "persistenceUnitRef", "postConstruct", "preDestroy", "messageDestination", "absoluteOrdering", "dataSource", "jmsConnectionFactories", "jmsDestinations", "moduleName", "contextService"})
public class WebApp
implements WebCommon,
Lifecycle,
NamedModule {
    @XmlTransient
    private String contextRoot;
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    protected List<Empty> distributable;
    @XmlElement(name="context-param")
    protected List<ParamValue> contextParam;
    protected List<Filter> filter;
    @XmlElement(name="filter-mapping")
    protected List<FilterMapping> filterMapping;
    protected List<Listener> listener;
    protected List<Servlet> servlet;
    @XmlElement(name="servlet-mapping")
    protected List<ServletMapping> servletMapping;
    @XmlElement(name="session-config")
    protected List<SessionConfig> sessionConfig;
    @XmlElement(name="mime-mapping")
    protected List<MimeMapping> mimeMapping;
    @XmlElement(name="welcome-file-list")
    protected List<WelcomeFileList> welcomeFileList;
    @XmlElement(name="error-page")
    protected List<ErrorPage> errorPage;
    @XmlElement(name="jsp-config")
    protected List<JspConfig> jspConfig;
    @XmlElement(name="security-constraint")
    protected List<SecurityConstraint> securityConstraint;
    @XmlElement(name="login-config")
    protected List<LoginConfig> loginConfig;
    @XmlElement(name="security-role")
    protected List<SecurityRole> securityRole;
    @XmlElement(name="locale-encoding-mapping-list")
    protected List<LocaleEncodingMappingList> localeEncodingMappingList;
    @XmlElement(name="env-entry", required=true)
    protected KeyedCollection<String, EnvEntry> envEntry;
    @XmlElement(name="ejb-ref", required=true)
    protected KeyedCollection<String, EjbRef> ejbRef;
    @XmlElement(name="ejb-local-ref", required=true)
    protected KeyedCollection<String, EjbLocalRef> ejbLocalRef;
    @XmlElement(name="service-ref", required=true)
    protected KeyedCollection<String, ServiceRef> serviceRef;
    @XmlElement(name="resource-ref", required=true)
    protected KeyedCollection<String, ResourceRef> resourceRef;
    @XmlElement(name="resource-env-ref", required=true)
    protected KeyedCollection<String, ResourceEnvRef> resourceEnvRef;
    @XmlElement(name="message-destination-ref", required=true)
    protected KeyedCollection<String, MessageDestinationRef> messageDestinationRef;
    @XmlElement(name="persistence-context-ref", required=true)
    protected KeyedCollection<String, PersistenceContextRef> persistenceContextRef;
    @XmlElement(name="persistence-unit-ref", required=true)
    protected KeyedCollection<String, PersistenceUnitRef> persistenceUnitRef;
    @XmlElement(name="data-source", required=true)
    protected KeyedCollection<String, DataSource> dataSource;
    @XmlElement(name="jms-connection-factory", required=true)
    protected KeyedCollection<String, JMSConnectionFactory> jmsConnectionFactories;
    @XmlElement(name="jms-destination")
    protected KeyedCollection<String, JMSDestination> jmsDestinations;
    @XmlElement(name="post-construct", required=true)
    protected List<LifecycleCallback> postConstruct;
    @XmlElement(name="pre-destroy", required=true)
    protected List<LifecycleCallback> preDestroy;
    @XmlElement(name="message-destination", required=true)
    protected List<MessageDestination> messageDestination;
    @XmlElement(name="module-name")
    protected String moduleName;
    @XmlElement(name="default-context-path")
    protected String defaultContextPath;
    @XmlElement(name="absolute-ordering")
    protected AbsoluteOrdering absoluteOrdering;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlAttribute(name="metadata-complete")
    protected Boolean metadataComplete;
    @XmlAttribute(required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String version = "3.0";
    @XmlElement(name="context-service")
    private KeyedCollection<String, ContextService> contextService;

    @Override
    public String getJndiConsumerName() {
        return this.contextRoot;
    }

    @Override
    public String getContextRoot() {
        return this.contextRoot;
    }

    @Override
    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @Override
    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    @Override
    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    @Override
    public String getDescription() {
        return this.description.get();
    }

    @Override
    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    @Override
    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    @Override
    public String getDisplayName() {
        return this.displayName.get();
    }

    public String getDefaultContextPath() {
        return this.defaultContextPath;
    }

    public void setDefaultContextPath(String defaultContextPath) {
        this.defaultContextPath = defaultContextPath;
    }

    @Override
    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    @Override
    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    @Override
    public Icon getIcon() {
        return this.icon.getLocal();
    }

    @Override
    public List<Empty> getDistributable() {
        if (this.distributable == null) {
            this.distributable = new ArrayList<Empty>();
        }
        return this.distributable;
    }

    @Override
    public List<ParamValue> getContextParam() {
        if (this.contextParam == null) {
            this.contextParam = new ArrayList<ParamValue>();
        }
        return this.contextParam;
    }

    @Override
    public List<Filter> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<Filter>();
        }
        return this.filter;
    }

    @Override
    public List<FilterMapping> getFilterMapping() {
        if (this.filterMapping == null) {
            this.filterMapping = new ArrayList<FilterMapping>();
        }
        return this.filterMapping;
    }

    @Override
    public List<Listener> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<Listener>();
        }
        return this.listener;
    }

    @Override
    public List<Servlet> getServlet() {
        if (this.servlet == null) {
            this.servlet = new ArrayList<Servlet>();
        }
        return this.servlet;
    }

    @Override
    public List<ServletMapping> getServletMapping() {
        if (this.servletMapping == null) {
            this.servletMapping = new ArrayList<ServletMapping>();
        }
        return this.servletMapping;
    }

    @Override
    public List<SessionConfig> getSessionConfig() {
        if (this.sessionConfig == null) {
            this.sessionConfig = new ArrayList<SessionConfig>();
        }
        return this.sessionConfig;
    }

    @Override
    public List<MimeMapping> getMimeMapping() {
        if (this.mimeMapping == null) {
            this.mimeMapping = new ArrayList<MimeMapping>();
        }
        return this.mimeMapping;
    }

    @Override
    public List<WelcomeFileList> getWelcomeFileList() {
        if (this.welcomeFileList == null) {
            this.welcomeFileList = new ArrayList<WelcomeFileList>();
        }
        return this.welcomeFileList;
    }

    @Override
    public List<ErrorPage> getErrorPage() {
        if (this.errorPage == null) {
            this.errorPage = new ArrayList<ErrorPage>();
        }
        return this.errorPage;
    }

    @Override
    public List<JspConfig> getJspConfig() {
        if (this.jspConfig == null) {
            this.jspConfig = new ArrayList<JspConfig>();
        }
        return this.jspConfig;
    }

    @Override
    public List<SecurityConstraint> getSecurityConstraint() {
        if (this.securityConstraint == null) {
            this.securityConstraint = new ArrayList<SecurityConstraint>();
        }
        return this.securityConstraint;
    }

    @Override
    public List<LoginConfig> getLoginConfig() {
        if (this.loginConfig == null) {
            this.loginConfig = new ArrayList<LoginConfig>();
        }
        return this.loginConfig;
    }

    @Override
    public List<SecurityRole> getSecurityRole() {
        if (this.securityRole == null) {
            this.securityRole = new ArrayList<SecurityRole>();
        }
        return this.securityRole;
    }

    @Override
    public List<LocaleEncodingMappingList> getLocaleEncodingMappingList() {
        if (this.localeEncodingMappingList == null) {
            this.localeEncodingMappingList = new ArrayList<LocaleEncodingMappingList>();
        }
        return this.localeEncodingMappingList;
    }

    @Override
    public Collection<EnvEntry> getEnvEntry() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry;
    }

    @Override
    public Map<String, EnvEntry> getEnvEntryMap() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry.toMap();
    }

    @Override
    public Collection<EjbRef> getEjbRef() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef;
    }

    @Override
    public Map<String, EjbRef> getEjbRefMap() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef.toMap();
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRef() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef;
    }

    @Override
    public Map<String, EjbLocalRef> getEjbLocalRefMap() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef.toMap();
    }

    @Override
    public Collection<ServiceRef> getServiceRef() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef;
    }

    @Override
    public Map<String, ServiceRef> getServiceRefMap() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef.toMap();
    }

    @Override
    public Collection<ResourceRef> getResourceRef() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef;
    }

    @Override
    public Map<String, ResourceRef> getResourceRefMap() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef.toMap();
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRef() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef;
    }

    @Override
    public Map<String, ResourceEnvRef> getResourceEnvRefMap() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef.toMap();
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRef() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef;
    }

    @Override
    public Map<String, MessageDestinationRef> getMessageDestinationRefMap() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef.toMap();
    }

    @Override
    public Collection<PersistenceContextRef> getPersistenceContextRef() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef;
    }

    @Override
    public Map<String, PersistenceContextRef> getPersistenceContextRefMap() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef.toMap();
    }

    @Override
    public Collection<PersistenceUnitRef> getPersistenceUnitRef() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef;
    }

    @Override
    public Map<String, PersistenceUnitRef> getPersistenceUnitRefMap() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef.toMap();
    }

    @Override
    public void addPostConstruct(String method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LifecycleCallback> getPostConstruct() {
        if (this.postConstruct == null) {
            this.postConstruct = new ArrayList<LifecycleCallback>();
        }
        return this.postConstruct;
    }

    @Override
    public void addPreDestroy(String method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LifecycleCallback> getPreDestroy() {
        if (this.preDestroy == null) {
            this.preDestroy = new ArrayList<LifecycleCallback>();
        }
        return this.preDestroy;
    }

    @Override
    public List<MessageDestination> getMessageDestination() {
        if (this.messageDestination == null) {
            this.messageDestination = new ArrayList<MessageDestination>();
        }
        return this.messageDestination;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    @Override
    public Boolean isMetadataComplete() {
        return this.metadataComplete != null && this.metadataComplete != false;
    }

    @Override
    public void setMetadataComplete(Boolean value) {
        this.metadataComplete = value;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String value) {
        this.version = value;
    }

    public Collection<JMSConnectionFactory> getJMSConnectionFactory() {
        if (this.jmsConnectionFactories == null) {
            this.jmsConnectionFactories = new KeyedCollection();
        }
        return this.jmsConnectionFactories;
    }

    public Map<String, JMSConnectionFactory> getJMSConnectionFactoryMap() {
        if (this.jmsConnectionFactories == null) {
            this.jmsConnectionFactories = new KeyedCollection();
        }
        return this.jmsConnectionFactories.toMap();
    }

    @Override
    public Collection<DataSource> getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource;
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource.toMap();
    }

    public AbsoluteOrdering getAbsoluteOrdering() {
        return this.absoluteOrdering;
    }

    public void setAbsoluteOrdering(AbsoluteOrdering absoluteOrdering) {
        this.absoluteOrdering = absoluteOrdering;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @XmlElement(name="taglib")
    public Taglib getTaglib() {
        return null;
    }

    public void setTaglib(Taglib taglib) {
        List<JspConfig> jspConfigs = this.getJspConfig();
        if (jspConfigs.isEmpty()) {
            jspConfigs.add(new JspConfig());
        }
        jspConfigs.get(0).getTaglib().add(taglib);
    }

    public Map<String, String> contextParamsAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.contextParam != null) {
            for (ParamValue pv : this.contextParam) {
                map.put(pv.getParamName(), pv.getParamValue());
            }
        }
        return map;
    }

    public List<String> getServletMappings(String servletName) {
        if (servletName == null || this.servletMapping == null || this.servletMapping.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> mappings = new ArrayList<String>();
        for (ServletMapping mapping : this.servletMapping) {
            if (!servletName.equals(mapping.getServletName())) continue;
            mappings.addAll(mapping.getUrlPattern());
        }
        return mappings;
    }

    public List<String> getFilterMappings(String filterName) {
        if (filterName == null || this.filterMapping == null || this.filterMapping.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> mappings = new ArrayList<String>();
        for (FilterMapping mapping : this.filterMapping) {
            if (!filterName.equals(mapping.getFilterName())) continue;
            mappings.addAll(mapping.getUrlPattern());
        }
        return mappings;
    }

    private Servlet findServlet(String name) {
        for (Servlet s : this.getServlet()) {
            if (!name.equals(s.getServletName())) continue;
            return s;
        }
        return null;
    }

    public WebApp addServlet(String name, String clazz, String ... mappings) {
        Servlet servletToAdd = new Servlet();
        servletToAdd.setServletName(name);
        servletToAdd.setServletClass(clazz);
        if (mappings != null && mappings.length > 0) {
            ServletMapping sm = new ServletMapping();
            sm.setServletName(name);
            for (String mapping : mappings) {
                if (this.servletMapping == null) {
                    this.servletMapping = new ArrayList<ServletMapping>();
                }
                sm.getUrlPattern().add(mapping);
            }
            this.servletMapping.add(sm);
        }
        this.getServlet().add(servletToAdd);
        return this;
    }

    public WebApp addServletMapping(String servletName, String mapping) {
        for (ServletMapping s : this.getServletMapping()) {
            if (!servletName.equals(s.getServletName())) continue;
            s.getUrlPattern().add(mapping);
            return this;
        }
        ServletMapping sm = new ServletMapping();
        sm.setServletName(servletName);
        sm.getUrlPattern().add(mapping);
        this.getServletMapping().add(sm);
        return this;
    }

    public WebApp addInitParam(String servletName, String name, String value) {
        ParamValue paramValue = new ParamValue();
        paramValue.setParamName(name);
        paramValue.setParamValue(value);
        this.findServlet(servletName).getInitParam().add(paramValue);
        return this;
    }

    public WebApp addFilter(String name, String clazz, String ... mappings) {
        Filter newFilter = new Filter();
        newFilter.setFilterName(name);
        newFilter.setFilterClass(clazz);
        if (mappings != null && mappings.length > 0) {
            FilterMapping sm = new FilterMapping();
            sm.setFilterName(name);
            for (String mapping : mappings) {
                if (this.filterMapping == null) {
                    this.filterMapping = new ArrayList<FilterMapping>();
                }
                sm.getUrlPattern().add(mapping);
            }
            this.filterMapping.add(sm);
        }
        this.getFilter().add(newFilter);
        return this;
    }

    public WebApp addFilterInitParam(String filterName, String name, String value) {
        ParamValue paramValue = new ParamValue();
        paramValue.setParamName(name);
        paramValue.setParamValue(value);
        this.findFilter(filterName).getInitParam().add(paramValue);
        return this;
    }

    private Filter findFilter(String filterName) {
        for (Filter s : this.getFilter()) {
            if (!filterName.equals(s.getFilterName())) continue;
            return s;
        }
        return null;
    }

    public WebApp contextRoot(String root) {
        this.setContextRoot(root);
        return this;
    }

    public WebApp defaultContextPath(String path) {
        this.setDefaultContextPath(path);
        return this;
    }

    public WebApp addListener(String classname) {
        Listener l = new Listener();
        l.setListenerClass(classname);
        this.getListener().add(l);
        return this;
    }

    @Override
    public Collection<JMSConnectionFactory> getJMSConnectionFactories() {
        return this.jmsConnectionFactories == null ? (this.jmsConnectionFactories = new KeyedCollection()) : this.jmsConnectionFactories;
    }

    @Override
    public Map<String, JMSConnectionFactory> getJMSConnectionFactoriesMap() {
        return ((KeyedCollection)KeyedCollection.class.cast(this.getJMSConnectionFactories())).toMap();
    }

    @Override
    public Collection<JMSDestination> getJMSDestination() {
        return this.jmsDestinations == null ? (this.jmsDestinations = new KeyedCollection()) : this.jmsDestinations;
    }

    @Override
    public Map<String, JMSDestination> getJMSDestinationMap() {
        return ((KeyedCollection)KeyedCollection.class.cast(this.getJMSDestination())).toMap();
    }

    @Override
    public Map<String, ContextService> getContextServiceMap() {
        if (this.contextService == null) {
            this.contextService = new KeyedCollection();
        }
        return this.contextService.toMap();
    }
}

