/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.jaxrs.JaxRsLogging;
import io.smallrye.openapi.jaxrs.JaxRsParameter;
import io.smallrye.openapi.jaxrs.JaxRsParameterProcessor;
import io.smallrye.openapi.jaxrs.JaxRsSubResourceLocator;
import io.smallrye.openapi.jaxrs.RestEasyConstants;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JaxRsAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String JAVAX_PACKAGE = "javax.ws.rs";
    private static final String JAKARTA_PACKAGE = "jakarta.ws.rs";
    private final Deque<JaxRsSubResourceLocator> subResourceStack = new LinkedList<JaxRsSubResourceLocator>();

    public String getName() {
        return "JAX-RS";
    }

    public boolean isWrapperType(Type type) {
        return type.name().equals((Object)RestEasyConstants.REACTIVE_REST_RESPONSE) && type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return method.parameterTypes().stream().map(Type::name).anyMatch(JaxRsConstants.ASYNC_RESPONSE::contains);
    }

    public boolean isPostMethod(MethodInfo method) {
        return JandexUtil.hasAnyOneOfAnnotation((MethodInfo)method, JaxRsConstants.POST);
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return JandexUtil.hasAnyOneOfAnnotation((MethodInfo)method, JaxRsConstants.DELETE);
    }

    public boolean isScannerInternalResponse(Type returnType) {
        return JaxRsConstants.RESPONSE.contains(returnType.name());
    }

    public boolean isMultipartOutput(Type returnType) {
        return RestEasyConstants.MULTIPART_OUTPUTS.contains(returnType.name());
    }

    public boolean isMultipartInput(Type inputType) {
        return RestEasyConstants.MULTIPART_INPUTS.contains(inputType.name());
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        if (JaxRsAnnotationScanner.containsJavaxAnnotations(instances) || JaxRsAnnotationScanner.containsJakartaAnnotations(instances)) {
            return true;
        }
        for (AnnotationInstance instance : instances) {
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsJavaxAnnotations(List<AnnotationInstance> instances) {
        return JaxRsAnnotationScanner.containsJaxrsAnnotations(instances, JAVAX_PACKAGE);
    }

    static boolean containsJakartaAnnotations(List<AnnotationInstance> instances) {
        return JaxRsAnnotationScanner.containsJaxrsAnnotations(instances, JAKARTA_PACKAGE);
    }

    private static boolean containsJaxrsAnnotations(List<AnnotationInstance> instances, String packageIndicator) {
        for (AnnotationInstance instance : instances) {
            if (JaxRsParameter.isParameter(instance.name())) {
                return true;
            }
            if (!instance.name().toString().startsWith(packageIndicator)) continue;
            return true;
        }
        return false;
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.processApplicationClasses(context, openApi);
        this.processResourceClasses(context, openApi);
        return openApi;
    }

    private void processApplicationClasses(AnnotationScannerContext context, OpenAPI openApi) {
        ArrayList applications = new ArrayList();
        for (DotName applicationindicator : JaxRsConstants.APPLICATION) {
            applications.addAll(context.getIndex().getAllKnownSubclasses(applicationindicator));
        }
        this.processScannerExtensions(context, applications);
        for (ClassInfo classInfo : applications) {
            OpenAPI applicationOpenApi = this.processApplicationClass(context, classInfo);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processApplicationClass(AnnotationScannerContext context, ClassInfo applicationClass) {
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        AnnotationInstance applicationPathAnnotation = JandexUtil.getClassAnnotation((ClassInfo)applicationClass, JaxRsConstants.APPLICATION_PATH);
        if (applicationPathAnnotation == null || context.getConfig().applicationPathDisable()) {
            applicationPathAnnotation = JandexUtil.getClassAnnotation((ClassInfo)applicationClass, JaxRsConstants.PATH);
        }
        this.currentAppPath = applicationPathAnnotation != null ? applicationPathAnnotation.value().asString() : "/";
        this.processDefinitionAnnotation(context, applicationClass, (OpenAPI)openApi);
        this.processSecuritySchemeAnnotation(context, applicationClass, (OpenAPI)openApi);
        this.processServerAnnotation(applicationClass, (OpenAPI)openApi);
        return openApi;
    }

    private void processResourceClasses(AnnotationScannerContext context, OpenAPI openApi) {
        Collection<ClassInfo> resourceClasses = this.getJaxRsResourceClasses(context);
        for (ClassInfo resourceClass : resourceClasses) {
            TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)context, (ClassInfo)resourceClass, null);
            context.getResolverStack().push(resolver);
            this.processResourceClass(context, openApi, resourceClass, null);
            context.getResolverStack().pop();
        }
    }

    private void processResourceClass(AnnotationScannerContext context, OpenAPI openApi, ClassInfo resourceClass, List<Parameter> locatorPathParameters) {
        JaxRsLogging.log.processingClass(resourceClass.simpleName());
        this.processSecuritySchemeAnnotation(context, resourceClass, openApi);
        this.processJavaSecurity(resourceClass, openApi);
        this.processResourceMethods(context, resourceClass, openApi, locatorPathParameters);
    }

    private void processResourceMethods(AnnotationScannerContext context, ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags(context, (AnnotationTarget)resourceClass, openApi, false);
        Map<DotName, AnnotationInstance> exceptionAnnotationMap = this.processExceptionMappers(context);
        List methods = this.getResourceMethods(context, resourceClass);
        Collections.reverse(methods);
        for (MethodInfo methodInfo : methods) {
            AtomicInteger resourceCount = new AtomicInteger(0);
            JaxRsConstants.HTTP_METHODS.stream().filter(arg_0 -> ((MethodInfo)methodInfo).hasAnnotation(arg_0)).map(DotName::withoutPackagePrefix).map(PathItem.HttpMethod::valueOf).forEach(httpMethod -> {
                resourceCount.incrementAndGet();
                this.processResourceMethod(context, resourceClass, methodInfo, (PathItem.HttpMethod)httpMethod, tagRefs, locatorPathParameters, exceptionAnnotationMap);
            });
            if (resourceCount.get() != 0 || !JandexUtil.hasAnyOneOfAnnotation((MethodInfo)methodInfo, JaxRsConstants.PATH)) continue;
            this.processSubResource(context, resourceClass, methodInfo, openApi, locatorPathParameters);
        }
    }

    private Map<DotName, AnnotationInstance> processExceptionMappers(AnnotationScannerContext context) {
        ArrayList exceptionMappers = new ArrayList();
        for (DotName dn : JaxRsConstants.EXCEPTION_MAPPER) {
            exceptionMappers.addAll(context.getIndex().getKnownDirectImplementors(dn));
        }
        return exceptionMappers.stream().flatMap(this::exceptionResponseAnnotations).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<Map.Entry<DotName, AnnotationInstance>> exceptionResponseAnnotations(ClassInfo classInfo) {
        return classInfo.interfaceTypes().stream().filter(it -> JaxRsConstants.EXCEPTION_MAPPER.contains(it.name())).filter(it -> Type.Kind.PARAMETERIZED_TYPE.equals((Object)it.kind())).map(Type::asParameterizedType).map(type -> (Type)type.arguments().get(0)).map(type -> JaxRsAnnotationScanner.entryOf(type.name(), classInfo.method("toResponse", new Type[]{type}))).filter(entry -> Objects.nonNull(entry.getValue())).filter(entry -> ResponseReader.hasResponseCodeValue((MethodInfo)((MethodInfo)entry.getValue()))).map(entry -> JaxRsAnnotationScanner.entryOf((DotName)entry.getKey(), ResponseReader.getResponseAnnotation((MethodInfo)((MethodInfo)entry.getValue()))));
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    private void processSubResource(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Type methodReturnType = context.getResourceTypeResolver().resolve(method.returnType());
        if (Type.Kind.VOID.equals((Object)methodReturnType.kind())) {
            return;
        }
        JaxRsSubResourceLocator locator = new JaxRsSubResourceLocator(resourceClass, method);
        ClassInfo subResourceClass = context.getIndex().getClassByName(methodReturnType.name());
        if (subResourceClass != null && !this.subResourceStack.contains(locator)) {
            Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
            ResourceParameters params = JaxRsParameterProcessor.process(context, this.currentAppPath, resourceClass, method, reader, context.getExtensions());
            String originalAppPath = this.currentAppPath;
            String subResourcePath = this.subResourceStack.isEmpty() ? params.getFullOperationPath() : params.getOperationPath();
            this.currentAppPath = JaxRsAnnotationScanner.createPathFromSegments((String[])new String[]{this.currentAppPath, subResourcePath});
            this.subResourceStack.push(locator);
            TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)context, (ClassInfo)subResourceClass, (Type)methodReturnType);
            context.getResolverStack().push(resolver);
            this.processResourceClass(context, openApi, subResourceClass, ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters(), params.getOperationParameters()}));
            context.getResolverStack().pop();
            this.subResourceStack.pop();
            this.currentAppPath = originalAppPath;
        }
    }

    private void processResourceMethod(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, Set<String> resourceTags, List<Parameter> locatorPathParameters, Map<DotName, AnnotationInstance> exceptionAnnotationMap) {
        JaxRsLogging.log.processingMethod(method.toString());
        String[] defaultConsumes = (String[])context.getConfig().getDefaultConsumes().orElseGet(OpenApiConstants.DEFAULT_MEDIA_TYPES);
        CurrentScannerInfo.setCurrentConsumes((String[])JaxRsAnnotationScanner.getMediaTypes(context, method, JaxRsConstants.CONSUMES, defaultConsumes));
        String[] defaultProduces = (String[])context.getConfig().getDefaultProduces().orElseGet(OpenApiConstants.DEFAULT_MEDIA_TYPES);
        CurrentScannerInfo.setCurrentProduces((String[])JaxRsAnnotationScanner.getMediaTypes(context, method, JaxRsConstants.PRODUCES, defaultProduces));
        Optional maybeOperation = this.processOperation(context, resourceClass, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(context, method, context.getOpenApi(), resourceTags, operation);
        Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
        ResourceParameters params = JaxRsParameterProcessor.process(context, this.currentAppPath, resourceClass, method, reader, context.getExtensions());
        List operationParams = params.getOperationParameters();
        operation.setParameters(operationParams);
        if (locatorPathParameters != null && operationParams != null) {
            locatorPathParameters = JaxRsAnnotationScanner.excludeOperationParameters(locatorPathParameters, operationParams);
        }
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(context, method, operation, exceptionAnnotationMap);
        this.processSecurityRequirementAnnotation(resourceClass, method, operation);
        this.processCallback(context, method, operation);
        this.processServerAnnotation(method, operation);
        this.processExtensions(context, method, operation);
        JavaSecurityProcessor.processSecurityRoles((MethodInfo)method, (Operation)operation);
        this.setOperationOnPathItem(methodType, (PathItem)pathItem, operation);
        if (!JaxRsAnnotationScanner.processProfiles((OpenApiConfig)context.getConfig(), (Extensible)operation)) {
            return;
        }
        String path = this.subResourceStack.isEmpty() ? super.makePath(params.getFullOperationPath()) : super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)context.getOpenApi()).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)context.getOpenApi()).addPathItem(path, (PathItem)pathItem);
        } else {
            MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
        }
    }

    static List<Parameter> excludeOperationParameters(List<Parameter> locatorParams, List<Parameter> operationParams) {
        return locatorParams.stream().filter(param -> operationParams.stream().noneMatch(oParam -> Objects.equals(param.getName(), oParam.getName()) && Objects.equals(param.getIn(), oParam.getIn()))).collect(Collectors.toList());
    }

    static String[] getMediaTypes(AnnotationScannerContext context, MethodInfo resourceMethod, Set<DotName> annotationName, String[] defaultValue) {
        return JandexUtil.ancestry((MethodInfo)resourceMethod, (AugmentedIndexView)context.getAugmentedIndex()).entrySet().stream().map(e -> JaxRsAnnotationScanner.getMediaTypeAnnotation((ClassInfo)e.getKey(), (MethodInfo)e.getValue(), annotationName)).filter(Objects::nonNull).map(annotation -> JaxRsAnnotationScanner.mediaTypeValue(annotation, defaultValue)).findFirst().orElse(null);
    }

    static AnnotationInstance getMediaTypeAnnotation(ClassInfo clazz, MethodInfo method, Set<DotName> annotationName) {
        AnnotationInstance annotation = null;
        if (method != null) {
            annotation = JandexUtil.getAnnotation((MethodInfo)method, annotationName);
        }
        if (annotation == null) {
            annotation = JandexUtil.getClassAnnotation((ClassInfo)clazz, annotationName);
        }
        return annotation;
    }

    static String[] mediaTypeValue(AnnotationInstance mediaTypeAnnotation, String[] defaultValue) {
        AnnotationValue annotationValue = mediaTypeAnnotation.value();
        if (annotationValue != null) {
            return JaxRsAnnotationScanner.flattenAndTrimMediaTypes(annotationValue.asStringArray());
        }
        return defaultValue;
    }

    static String[] flattenAndTrimMediaTypes(String[] mediaTypes) {
        return (String[])Arrays.stream(mediaTypes).map(mediaType -> mediaType.split(",")).flatMap(Arrays::stream).map(String::trim).toArray(String[]::new);
    }

    private Collection<ClassInfo> getJaxRsResourceClasses(AnnotationScannerContext context) {
        ArrayList pathAnnotations = new ArrayList();
        for (DotName dn : JaxRsConstants.PATH) {
            pathAnnotations.addAll(context.getIndex().getAnnotations(dn));
        }
        return pathAnnotations.stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(classInfo -> this.hasImplementationOrIsIncluded(context, (ClassInfo)classInfo)).distinct().collect(Collectors.toList());
    }

    private boolean hasImplementationOrIsIncluded(AnnotationScannerContext context, ClassInfo clazz) {
        if (this.neitherIterfaceNorSyntheticRestClient(context, clazz)) {
            return true;
        }
        FilteredIndexView filteredIndex = context.getIndex();
        if (filteredIndex.getAllKnownImplementors(clazz.name()).stream().anyMatch(this::neitherAbstractNorSynthetic)) {
            return true;
        }
        return filteredIndex.explicitlyAccepts(clazz.name());
    }

    private boolean neitherIterfaceNorSyntheticRestClient(AnnotationScannerContext context, ClassInfo clazz) {
        if (Modifier.isInterface(clazz.flags())) {
            return false;
        }
        if (!clazz.isSynthetic()) {
            return true;
        }
        AugmentedIndexView index = context.getAugmentedIndex();
        return JandexUtil.inheritanceChain((IndexView)index, (ClassInfo)clazz, (Type)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS)).entrySet().stream().flatMap(e -> JandexUtil.interfaces((AugmentedIndexView)index, (ClassInfo)((ClassInfo)e.getKey())).stream()).map(arg_0 -> ((AugmentedIndexView)index).getClass(arg_0)).filter(Objects::nonNull).noneMatch(iface -> iface.classAnnotation(JaxRsConstants.REGISTER_REST_CLIENT) != null);
    }

    private boolean neitherAbstractNorSynthetic(ClassInfo clazz) {
        return !Modifier.isAbstract(clazz.flags()) && !clazz.isSynthetic();
    }
}

