/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.ivm.naming.JndiUrlReference;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.activemq.ConnectionFactoryWrapper;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PassthroughFactory;
import org.apache.xbean.naming.reference.SimpleReference;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class InjectionProcessor<T> {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, InjectionProcessor.class);
    private final Class<? extends T> beanClass;
    private final Collection<Injection> injections;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final List<Method> postConstructMethods;
    private final List<Method> preDestroyMethods;
    private final Context context;
    private T instance;
    private T suppliedInstance;
    private final Map<String, Object> bindings = new HashMap<String, Object>();

    public InjectionProcessor(T suppliedInstance, Collection<Injection> injections, Context context) {
        this.beanClass = null;
        this.suppliedInstance = suppliedInstance;
        this.injections = injections;
        this.context = context;
        this.postConstructMethods = null;
        this.preDestroyMethods = null;
    }

    public InjectionProcessor(Class<? extends T> beanClass, Collection<Injection> injections, Context context) {
        this.beanClass = beanClass;
        this.injections = injections;
        this.context = context;
        this.postConstructMethods = null;
        this.preDestroyMethods = null;
    }

    public InjectionProcessor(Class<? extends T> beanClass, Collection<Injection> injections, List<Method> postConstructMethods, List<Method> preDestroyMethods, Context context) {
        this.beanClass = beanClass;
        this.injections = injections;
        this.postConstructMethods = postConstructMethods;
        this.preDestroyMethods = preDestroyMethods;
        this.context = context;
    }

    public InjectionProcessor(Class<? extends T> beanClass, Collection<Injection> injections, List<Method> postConstructMethods, List<Method> preDestroyMethods, Context context, Map<String, Object> bindings) {
        this(beanClass, injections, postConstructMethods, preDestroyMethods, context);
        this.bindings.putAll(bindings);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public T createInstance() throws OpenEJBException {
        if (this.instance == null) {
            this.construct();
        }
        return this.instance;
    }

    public T getInstance() {
        return this.instance;
    }

    private void construct() throws OpenEJBException {
        Object object;
        ObjectRecipe objectRecipe;
        if (this.instance != null) {
            throw new IllegalStateException("Instance already constructed");
        }
        Class<Object> clazz = this.beanClass;
        if (this.suppliedInstance != null) {
            clazz = this.suppliedInstance.getClass();
            objectRecipe = PassthroughFactory.recipe(this.suppliedInstance);
        } else {
            objectRecipe = new ObjectRecipe(clazz);
        }
        objectRecipe.allow(Option.FIELD_INJECTION);
        objectRecipe.allow(Option.PRIVATE_PROPERTIES);
        objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        objectRecipe.allow(Option.NAMED_PARAMETERS);
        this.fillInjectionProperties(objectRecipe);
        this.bindings.clear();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            objectRecipe.setProperty(entry.getKey(), entry.getValue());
        }
        try {
            object = objectRecipe.create(clazz.getClassLoader());
        }
        catch (Exception e) {
            throw new OpenEJBException("Error while creating bean " + clazz.getName(), e);
        }
        Map unsetProperties = objectRecipe.getUnsetProperties();
        if (unsetProperties.size() > 0) {
            for (Object property : unsetProperties.keySet()) {
                logger.warning("Injection: No such property '" + property + "' in class " + clazz.getName());
            }
        }
        this.instance = clazz.cast(object);
    }

    public void postConstruct() throws OpenEJBException {
        if (this.instance == null) {
            throw new IllegalStateException("Instance has not been constructed");
        }
        if (this.postConstructMethods == null) {
            return;
        }
        for (Method postConstruct : this.postConstructMethods) {
            try {
                postConstruct.invoke(this.instance, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                    e = (Exception)e.getCause();
                }
                throw new OpenEJBException("Error while calling post construct method", e);
            }
        }
    }

    public void preDestroy() {
        if (this.instance == null) {
            return;
        }
        if (this.preDestroyMethods == null) {
            return;
        }
        for (Method preDestroy : this.preDestroyMethods) {
            try {
                preDestroy.invoke(this.instance, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                    e = (Exception)e.getCause();
                }
                logger.error("Error while calling pre destroy method", e);
            }
        }
    }

    private void fillInjectionProperties(ObjectRecipe objectRecipe) {
        if (this.injections == null) {
            return;
        }
        boolean usePrefix = true;
        try {
            if (this.beanClass != null) {
                this.beanClass.getConstructor(new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            usePrefix = false;
        }
        Class<Object> clazz = this.beanClass;
        if (this.suppliedInstance != null) {
            clazz = this.suppliedInstance.getClass();
        }
        if (null != this.context && null != clazz) {
            for (Injection injection : this.injections) {
                FallbackPropertyInjector fallback;
                Object value;
                block17: {
                    if (injection.getTarget() == null || !injection.getTarget().isAssignableFrom(clazz)) continue;
                    String jndiName = injection.getJndiName();
                    try {
                        value = this.context.lookup(jndiName);
                    }
                    catch (NamingException ne) {
                        value = this.bindings.get(jndiName);
                        if (!(value instanceof SimpleReference)) break block17;
                        try {
                            value = ((SimpleReference)value).getContent();
                        }
                        catch (NamingException e) {
                            if (!(value instanceof JndiUrlReference)) break block17;
                            try {
                                ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
                                if (null == containerSystem) {
                                    throw new IllegalStateException("ContainerSystem has not been initialized");
                                }
                                value = containerSystem.getJNDIContext().lookup(((JndiUrlReference)((Object)value)).getJndiName());
                            }
                            catch (NamingException e1) {
                                value = null;
                            }
                        }
                    }
                }
                if (value == null && (fallback = SystemInstance.get().getComponent(FallbackPropertyInjector.class)) != null) {
                    value = fallback.getValue(injection);
                }
                if (value != null) {
                    String prefix = usePrefix ? injection.getTarget().getName() + "/" : "";
                    String name = prefix + injection.getName();
                    if ("org.apache.activemq.ra.ActiveMQConnectionFactory".equals(value.getClass().getName())) {
                        value = new ConnectionFactoryWrapper(name, value);
                    }
                    objectRecipe.setProperty(name, value);
                    continue;
                }
                logger.warning("Injection data not found in JNDI context: jndiName='" + injection.getJndiName() + "', target=" + injection.getTarget().getName() + "/" + injection.getName());
            }
        }
    }

    public static Context unwrap(Context context) {
        return context;
    }
}

