/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.ProxyMessageStore;
import org.apache.activemq.store.ProxyTopicMessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCMessageStore;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCTopicMessageStore;
import org.apache.activemq.store.memory.MemoryTransactionStore;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;

public class JdbcMemoryTransactionStore
extends MemoryTransactionStore {
    private HashMap<ActiveMQDestination, MessageStore> topicStores = new HashMap();
    private HashMap<ActiveMQDestination, MessageStore> queueStores = new HashMap();

    public JdbcMemoryTransactionStore(JDBCPersistenceAdapter jdbcPersistenceAdapter) {
        super((PersistenceAdapter)jdbcPersistenceAdapter);
    }

    public void prepare(TransactionId txid) throws IOException {
        MemoryTransactionStore.Tx tx = (MemoryTransactionStore.Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        ConnectionContext ctx = new ConnectionContext();
        ctx.setXid((XATransactionId)txid);
        this.persistenceAdapter.beginTransaction(ctx);
        try {
            for (MemoryTransactionStore.AddMessageCommand cmd : tx.messages) {
                cmd.run(ctx);
            }
            for (MemoryTransactionStore.AddMessageCommand cmd : tx.acks) {
                cmd.run(ctx);
            }
        }
        catch (IOException e) {
            this.persistenceAdapter.rollbackTransaction(ctx);
            throw e;
        }
        this.persistenceAdapter.commitTransaction(ctx);
        ctx.setXid(null);
        ArrayList<1> updateFromPreparedStateCommands = new ArrayList<1>();
        for (final MemoryTransactionStore.AddMessageCommand addMessageCommand : tx.messages) {
            updateFromPreparedStateCommands.add(new MemoryTransactionStore.AddMessageCommand(){

                public Message getMessage() {
                    return addMessageCommand.getMessage();
                }

                public MessageStore getMessageStore() {
                    return addMessageCommand.getMessageStore();
                }

                public void run(ConnectionContext context) throws IOException {
                    JDBCPersistenceAdapter jdbcPersistenceAdapter = (JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter;
                    Message message = addMessageCommand.getMessage();
                    jdbcPersistenceAdapter.commitAdd(context, message.getMessageId());
                    ((JDBCMessageStore)addMessageCommand.getMessageStore()).onAdd(message.getMessageId(), (Long)message.getMessageId().getEntryLocator(), message.getPriority());
                }

                public void setMessageStore(MessageStore messageStore) {
                    throw new RuntimeException("MessageStore already known");
                }
            });
        }
        tx.messages = updateFromPreparedStateCommands;
        this.preparedTransactions.put(txid, tx);
    }

    public void rollback(TransactionId txid) throws IOException {
        MemoryTransactionStore.Tx tx = (MemoryTransactionStore.Tx)this.inflightTransactions.remove(txid);
        if (tx == null && (tx = (MemoryTransactionStore.Tx)this.preparedTransactions.remove(txid)) != null) {
            ConnectionContext ctx = new ConnectionContext();
            this.persistenceAdapter.beginTransaction(ctx);
            try {
                Iterator iter = tx.messages.iterator();
                while (iter.hasNext()) {
                    Message message = ((MemoryTransactionStore.AddMessageCommand)iter.next()).getMessage();
                    ((JDBCPersistenceAdapter)this.persistenceAdapter).commitRemove(ctx, new MessageAck(message, 2, 1));
                }
                for (MemoryTransactionStore.RemoveMessageCommand removeMessageCommand : tx.acks) {
                    if (removeMessageCommand instanceof LastAckCommand) {
                        ((LastAckCommand)removeMessageCommand).rollback(ctx);
                        continue;
                    }
                    ((JDBCPersistenceAdapter)this.persistenceAdapter).commitAdd(ctx, removeMessageCommand.getMessageAck().getLastMessageId());
                }
            }
            catch (IOException e) {
                this.persistenceAdapter.rollbackTransaction(ctx);
                throw e;
            }
            this.persistenceAdapter.commitTransaction(ctx);
        }
    }

    public void recover(TransactionRecoveryListener listener) throws IOException {
        ((JDBCPersistenceAdapter)this.persistenceAdapter).recover(this);
        super.recover(listener);
    }

    public void recoverAdd(long id, byte[] messageBytes) throws IOException {
        final Message message = (Message)((JDBCPersistenceAdapter)this.persistenceAdapter).getWireFormat().unmarshal(new ByteSequence(messageBytes));
        message.getMessageId().setEntryLocator((Object)id);
        MemoryTransactionStore.Tx tx = this.getPreparedTx(message.getTransactionId());
        tx.add(new MemoryTransactionStore.AddMessageCommand(){
            MessageStore messageStore;

            public Message getMessage() {
                return message;
            }

            public MessageStore getMessageStore() {
                return this.messageStore;
            }

            public void run(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).commitAdd(null, message.getMessageId());
                ((JDBCMessageStore)this.messageStore).onAdd(message.getMessageId(), (Long)message.getMessageId().getEntryLocator(), message.getPriority());
            }

            public void setMessageStore(MessageStore messageStore) {
                this.messageStore = messageStore;
            }
        });
    }

    public void recoverAck(long id, byte[] xid, byte[] message) throws IOException {
        Message msg = (Message)((JDBCPersistenceAdapter)this.persistenceAdapter).getWireFormat().unmarshal(new ByteSequence(message));
        msg.getMessageId().setEntryLocator((Object)id);
        MemoryTransactionStore.Tx tx = this.getPreparedTx((TransactionId)new XATransactionId(xid));
        final MessageAck ack = new MessageAck(msg, 2, 1);
        tx.add(new MemoryTransactionStore.RemoveMessageCommand(){

            public MessageAck getMessageAck() {
                return ack;
            }

            public void run(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).commitRemove(context, ack);
            }

            public MessageStore getMessageStore() {
                return null;
            }
        });
    }

    public void recoverLastAck(byte[] encodedXid, final ActiveMQDestination destination, final String subName, final String clientId) throws IOException {
        MemoryTransactionStore.Tx tx = this.getPreparedTx((TransactionId)new XATransactionId(encodedXid));
        DataByteArrayInputStream inputStream = new DataByteArrayInputStream(encodedXid);
        inputStream.skipBytes(1);
        final long lastAck = inputStream.readLong();
        final byte priority = inputStream.readByte();
        final MessageAck ack = new MessageAck();
        ack.setDestination(destination);
        tx.add((MemoryTransactionStore.RemoveMessageCommand)new LastAckCommand(){
            JDBCTopicMessageStore jdbcTopicMessageStore;

            public MessageAck getMessageAck() {
                return ack;
            }

            public MessageStore getMessageStore() {
                return this.jdbcTopicMessageStore;
            }

            public void run(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).commitLastAck(context, lastAck, priority, destination, subName, clientId);
                this.jdbcTopicMessageStore.complete(clientId, subName);
            }

            @Override
            public void rollback(ConnectionContext context) throws IOException {
                ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).rollbackLastAck(context, priority, this.jdbcTopicMessageStore.getDestination(), subName, clientId);
                this.jdbcTopicMessageStore.complete(clientId, subName);
            }

            @Override
            public String getClientId() {
                return clientId;
            }

            @Override
            public String getSubName() {
                return subName;
            }

            @Override
            public long getSequence() {
                return lastAck;
            }

            @Override
            public byte getPriority() {
                return priority;
            }

            @Override
            public void setMessageStore(JDBCTopicMessageStore jdbcTopicMessageStore) {
                this.jdbcTopicMessageStore = jdbcTopicMessageStore;
            }
        });
    }

    protected void onProxyTopicStore(ProxyTopicMessageStore proxyTopicMessageStore) {
        this.topicStores.put(proxyTopicMessageStore.getDestination(), proxyTopicMessageStore.getDelegate());
    }

    protected void onProxyQueueStore(ProxyMessageStore proxyQueueMessageStore) {
        this.queueStores.put(proxyQueueMessageStore.getDestination(), proxyQueueMessageStore.getDelegate());
    }

    protected void onRecovered(MemoryTransactionStore.Tx tx) {
        for (MemoryTransactionStore.RemoveMessageCommand removeMessageCommand : tx.acks) {
            if (removeMessageCommand instanceof LastAckCommand) {
                LastAckCommand lastAckCommand = (LastAckCommand)removeMessageCommand;
                JDBCTopicMessageStore jdbcTopicMessageStore = (JDBCTopicMessageStore)this.topicStores.get(lastAckCommand.getMessageAck().getDestination());
                jdbcTopicMessageStore.pendingCompletion(lastAckCommand.getClientId(), lastAckCommand.getSubName(), lastAckCommand.getSequence(), lastAckCommand.getPriority());
                lastAckCommand.setMessageStore(jdbcTopicMessageStore);
                continue;
            }
            ((Destination)((JDBCPersistenceAdapter)this.persistenceAdapter).getBrokerService().getRegionBroker().getDestinationMap().get(removeMessageCommand.getMessageAck().getDestination())).getDestinationStatistics().getMessages().increment();
        }
        Iterator i$ = tx.messages.iterator();
        while (i$.hasNext()) {
            MemoryTransactionStore.AddMessageCommand addMessageCommand;
            ActiveMQDestination destination = (addMessageCommand = (MemoryTransactionStore.AddMessageCommand)i$.next()).getMessage().getDestination();
            addMessageCommand.setMessageStore(destination.isQueue() ? this.queueStores.get(destination) : this.topicStores.get(destination));
        }
    }

    public void acknowledge(final TopicMessageStore topicMessageStore, final String clientId, final String subscriptionName, final MessageId messageId, final MessageAck ack) throws IOException {
        if (ack.isInTransaction()) {
            MemoryTransactionStore.Tx tx = this.getTx(ack.getTransactionId());
            tx.add((MemoryTransactionStore.RemoveMessageCommand)new LastAckCommand(){

                public MessageAck getMessageAck() {
                    return ack;
                }

                public void run(ConnectionContext ctx) throws IOException {
                    topicMessageStore.acknowledge(ctx, clientId, subscriptionName, messageId, ack);
                }

                public MessageStore getMessageStore() {
                    return topicMessageStore;
                }

                @Override
                public void rollback(ConnectionContext context) throws IOException {
                    JDBCTopicMessageStore jdbcTopicMessageStore = (JDBCTopicMessageStore)topicMessageStore;
                    ((JDBCPersistenceAdapter)JdbcMemoryTransactionStore.this.persistenceAdapter).rollbackLastAck(context, jdbcTopicMessageStore, ack, subscriptionName, clientId);
                    jdbcTopicMessageStore.complete(clientId, subscriptionName);
                }

                @Override
                public String getClientId() {
                    return clientId;
                }

                @Override
                public String getSubName() {
                    return subscriptionName;
                }

                @Override
                public long getSequence() {
                    throw new IllegalStateException("Sequence id must be inferred from ack");
                }

                @Override
                public byte getPriority() {
                    throw new IllegalStateException("Priority must be inferred from ack or row");
                }

                @Override
                public void setMessageStore(JDBCTopicMessageStore jdbcTopicMessageStore) {
                    throw new IllegalStateException("message store already known!");
                }
            });
        } else {
            topicMessageStore.acknowledge(null, clientId, subscriptionName, messageId, ack);
        }
    }

    static interface LastAckCommand
    extends MemoryTransactionStore.RemoveMessageCommand {
        public void rollback(ConnectionContext var1) throws IOException;

        public String getClientId();

        public String getSubName();

        public long getSequence();

        public byte getPriority();

        public void setMessageStore(JDBCTopicMessageStore var1);
    }
}

