/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.PortRefMetaData;
import org.w3c.dom.Element;

public class JaxWsProviderWrapper
extends Provider {
    private static final Logger logger = Logger.getLogger("OpenEJB.client");
    private static final ThreadLocal<ProviderWrapperData> threadPortRefs = new ThreadLocal();
    private final Provider delegate = JaxWsProviderWrapper.findProvider();
    private final List<PortRefMetaData> portRefs = ProviderWrapperData.access$100(threadPortRefs.get());
    private static final Method createW3CEndpointReference;
    private static final Method providerGetPort;
    private static final Method readEndpointReference;
    private static final Method createDispatchReferenceJaxB;
    private static final Method createDispatchReferenceClass;
    private static final Method createDispatchInterface;
    private static final Method createDispatchJaxBContext;
    private static final Method serviceGetPortByEndpointReference;
    private static final Method serviceGetPortByQName;
    private static final Method serviceGetPortByInterface;

    public static void beforeCreate(List<PortRefMetaData> portRefMetaDatas) {
        String oldProperty = System.getProperty("javax.xml.ws.spi.Provider");
        if (oldProperty != null && !oldProperty.equals(JaxWsProviderWrapper.class.getName())) {
            System.setProperty("openejb.javax.xml.ws.spi.Provider", oldProperty);
        }
        System.setProperty("javax.xml.ws.spi.Provider", JaxWsProviderWrapper.class.getName());
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        if (oldClassLoader != null) {
            Thread.currentThread().setContextClassLoader(new ProviderClassLoader(oldClassLoader));
        } else {
            Thread.currentThread().setContextClassLoader(new ProviderClassLoader());
        }
        threadPortRefs.set(new ProviderWrapperData(portRefMetaDatas, oldClassLoader));
    }

    public static void afterCreate() {
        Thread.currentThread().setContextClassLoader(threadPortRefs.get().callerClassLoader);
        threadPortRefs.set(null);
    }

    public Provider getDelegate() {
        return this.delegate;
    }

    public ServiceDelegate createServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class serviceClass) {
        ServiceDelegate serviceDelegate = this.delegate.createServiceDelegate(wsdlDocumentLocation, serviceName, serviceClass);
        serviceDelegate = new ServiceDelegateWrapper(serviceDelegate);
        return serviceDelegate;
    }

    public Endpoint createEndpoint(String bindingId, Object implementor) {
        return this.delegate.createEndpoint(bindingId, implementor);
    }

    public Endpoint createAndPublishEndpoint(String address, Object implementor) {
        return this.delegate.createAndPublishEndpoint(address, implementor);
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters) {
        return (W3CEndpointReference)JaxWsProviderWrapper.invoke21Delegate(this.delegate, createW3CEndpointReference, address, serviceName, portName, metadata, wsdlDocumentLocation, referenceParameters);
    }

    public EndpointReference readEndpointReference(Source source) {
        return (EndpointReference)JaxWsProviderWrapper.invoke21Delegate(this.delegate, readEndpointReference, source);
    }

    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        return (T)JaxWsProviderWrapper.invoke21Delegate(this.delegate, providerGetPort, endpointReference, serviceEndpointInterface, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Provider findProvider() {
        Closeable in;
        String providerClass;
        Provider provider;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((provider = JaxWsProviderWrapper.createProviderInstance(providerClass = System.getProperty("openejb.javax.xml.ws.spi.Provider"), classLoader)) != null) {
            return provider;
        }
        try {
            for (URL url : Collections.list(classLoader.getResources("META-INF/services/javax.xml.ws.spi.Provider"))) {
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(url.openStream()));
                    providerClass = ((BufferedReader)in).readLine();
                    provider = JaxWsProviderWrapper.createProviderInstance(providerClass, classLoader);
                    if (provider == null) continue;
                    Provider provider2 = provider;
                    return provider2;
                }
                catch (Exception exception) {}
                continue;
                finally {
                    if (in == null) continue;
                    try {
                        ((BufferedReader)in).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Exception ingored) {
            logger.log(Level.INFO, "No META-INF/services/javax.xml.ws.spi.Provider found");
        }
        String javaHome = System.getProperty("java.home");
        File jaxrpcPropertiesFile = new File(new File(javaHome, "lib"), "jaxrpc.properties");
        if (jaxrpcPropertiesFile.exists()) {
            in = null;
            try {
                in = new FileInputStream(jaxrpcPropertiesFile);
                Properties properties = new Properties();
                properties.load((InputStream)in);
                providerClass = properties.getProperty("javax.xml.ws.spi.Provider");
                provider = JaxWsProviderWrapper.createProviderInstance(providerClass, classLoader);
                if (provider != null) {
                    Provider provider3 = provider;
                    return provider3;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        if ((provider = JaxWsProviderWrapper.createProviderInstance(providerClass = System.getProperty("javax.xml.ws.spi.Provider"), classLoader)) != null) {
            return provider;
        }
        try {
            if (classLoader instanceof ProviderClassLoader) {
                ((ProviderClassLoader)classLoader).enabled = false;
            }
            System.getProperties().remove("javax.xml.ws.spi.Provider");
            provider = Provider.provider();
            if (provider == null) throw new WebServiceException("No javax.xml.ws.spi.Provider implementation found");
            if (provider.getClass().getName().equals(JaxWsProviderWrapper.class.getName())) throw new WebServiceException("No javax.xml.ws.spi.Provider implementation found");
            Provider provider4 = provider;
            return provider4;
        }
        finally {
            System.setProperty("javax.xml.ws.spi.Provider", providerClass);
            if (classLoader instanceof ProviderClassLoader) {
                ((ProviderClassLoader)classLoader).enabled = true;
            }
        }
    }

    private static Provider createProviderInstance(String providerClass, ClassLoader classLoader) {
        if (providerClass != null && providerClass.length() > 0 && !providerClass.equals(JaxWsProviderWrapper.class.getName())) {
            try {
                Class<Provider> clazz = classLoader.loadClass(providerClass).asSubclass(Provider.class);
                return clazz.newInstance();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Unable to construct provider implementation " + providerClass, e);
            }
        }
        return null;
    }

    private static Object invoke21Delegate(Object delegate, Method method, Object ... args) {
        if (method == null) {
            throw new UnsupportedOperationException("JaxWS 2.1 APIs are not supported");
        }
        try {
            return method.invoke(delegate, args);
        }
        catch (IllegalAccessException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new WebServiceException(e.getCause());
            }
            throw new WebServiceException((Throwable)e);
        }
    }

    static {
        Method method = null;
        try {
            method = Provider.class.getMethod("createW3CEndpointReference", String.class, QName.class, QName.class, List.class, String.class, List.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        createW3CEndpointReference = method;
        method = null;
        try {
            method = Provider.class.getMethod("getPort", EndpointReference.class, Class.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        providerGetPort = method;
        method = null;
        try {
            method = Provider.class.getMethod("readEndpointReference", Source.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        readEndpointReference = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("createDispatch", EndpointReference.class, JAXBContext.class, Service.Mode.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        createDispatchReferenceJaxB = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("createDispatch", EndpointReference.class, Class.class, Service.Mode.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        createDispatchReferenceClass = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("createDispatch", QName.class, JAXBContext.class, Service.Mode.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        createDispatchJaxBContext = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("createDispatch", QName.class, Class.class, Service.Mode.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        createDispatchInterface = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("getPort", EndpointReference.class, Class.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        serviceGetPortByEndpointReference = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("getPort", QName.class, Class.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        serviceGetPortByQName = method;
        method = null;
        try {
            method = ServiceDelegate.class.getMethod("getPort", Class.class, WebServiceFeature[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        serviceGetPortByInterface = method;
    }

    private static class ProviderClassLoader
    extends ClassLoader {
        private static final String PROVIDER_RESOURCE = "META-INF/services/javax.xml.ws.spi.Provider";
        private static final URL PROVIDER_URL;
        public boolean enabled = true;

        public ProviderClassLoader() {
        }

        public ProviderClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> resources = super.getResources(name);
            if (this.enabled && PROVIDER_RESOURCE.equals(name)) {
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(PROVIDER_URL);
                list.addAll(Collections.list(resources));
                resources = Collections.enumeration(list);
            }
            return resources;
        }

        @Override
        public URL getResource(String name) {
            if (this.enabled && PROVIDER_RESOURCE.equals(name)) {
                return PROVIDER_URL;
            }
            return super.getResource(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            File tempFile = null;
            try {
                try {
                    tempFile = File.createTempFile("openejb-jaxws-provider", "tmp");
                }
                catch (Throwable e) {
                    File dir = new File("tmp");
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new Exception("Failed to create: " + dir.getAbsolutePath());
                    }
                    tempFile = File.createTempFile("openejb-jaxws-provider", "tmp", dir);
                }
                tempFile.deleteOnExit();
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(tempFile);
                    ((OutputStream)out).write(JaxWsProviderWrapper.class.getName().getBytes());
                }
                finally {
                    if (null != out) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                ((OutputStream)out).close();
                PROVIDER_URL = tempFile.toURI().toURL();
            }
            catch (Throwable e) {
                throw new ClientRuntimeException("Failed to create openejb-jaxws-provider file: " + tempFile, e);
            }
        }
    }

    private class ServiceDelegateWrapper
    extends ServiceDelegate {
        private final ServiceDelegate serviceDelegate;

        public ServiceDelegateWrapper(ServiceDelegate serviceDelegate) {
            this.serviceDelegate = serviceDelegate;
        }

        public <T> T getPort(QName portName, Class<T> serviceEndpointInterface) {
            Object t = this.serviceDelegate.getPort(portName, serviceEndpointInterface);
            this.setProperties((BindingProvider)t, portName);
            return (T)t;
        }

        public <T> T getPort(Class<T> serviceEndpointInterface) {
            Object t = this.serviceDelegate.getPort(serviceEndpointInterface);
            QName qname = null;
            if (serviceEndpointInterface.isAnnotationPresent(WebService.class)) {
                WebService webService = serviceEndpointInterface.getAnnotation(WebService.class);
                String targetNamespace = webService.targetNamespace();
                String name = webService.name();
                if (targetNamespace != null && targetNamespace.length() > 0 && name != null && name.length() > 0) {
                    qname = new QName(targetNamespace, name);
                }
            }
            this.setProperties((BindingProvider)t, qname);
            return (T)t;
        }

        public void addPort(QName portName, String bindingId, String endpointAddress) {
            this.serviceDelegate.addPort(portName, bindingId, endpointAddress);
        }

        public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
            Dispatch dispatch = this.serviceDelegate.createDispatch(portName, type, mode);
            this.setProperties((BindingProvider)dispatch, portName);
            return dispatch;
        }

        public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
            Dispatch dispatch = this.serviceDelegate.createDispatch(portName, context, mode);
            this.setProperties((BindingProvider)dispatch, portName);
            return dispatch;
        }

        public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
            return (Dispatch)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, createDispatchInterface, new Object[]{portName, type, mode, features});
        }

        public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
            return (Dispatch)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, createDispatchJaxBContext, new Object[]{portName, context, mode, features});
        }

        public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
            return (Dispatch)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, createDispatchReferenceJaxB, new Object[]{endpointReference, context, mode, features});
        }

        public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
            return (Dispatch)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, createDispatchReferenceClass, new Object[]{endpointReference, type, mode, features});
        }

        public <T> T getPort(QName portName, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
            return (T)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, serviceGetPortByQName, new Object[]{portName, serviceEndpointInterface, features});
        }

        public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
            return (T)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, serviceGetPortByEndpointReference, new Object[]{endpointReference, serviceEndpointInterface, features});
        }

        public <T> T getPort(Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
            return (T)JaxWsProviderWrapper.invoke21Delegate(this.serviceDelegate, serviceGetPortByInterface, new Object[]{serviceEndpointInterface, features});
        }

        public QName getServiceName() {
            return this.serviceDelegate.getServiceName();
        }

        public Iterator<QName> getPorts() {
            return this.serviceDelegate.getPorts();
        }

        public URL getWSDLDocumentLocation() {
            return this.serviceDelegate.getWSDLDocumentLocation();
        }

        public HandlerResolver getHandlerResolver() {
            return this.serviceDelegate.getHandlerResolver();
        }

        public void setHandlerResolver(HandlerResolver handlerResolver) {
            this.serviceDelegate.setHandlerResolver(handlerResolver);
        }

        public Executor getExecutor() {
            return this.serviceDelegate.getExecutor();
        }

        public void setExecutor(Executor executor) {
            this.serviceDelegate.setExecutor(executor);
        }

        private void setProperties(BindingProvider proxy, QName qname) {
            for (PortRefMetaData portRef : JaxWsProviderWrapper.this.portRefs) {
                boolean enableMTOM;
                Class<?> intf = null;
                if (portRef.getServiceEndpointInterface() != null) {
                    try {
                        intf = proxy.getClass().getClassLoader().loadClass(portRef.getServiceEndpointInterface());
                    }
                    catch (ClassNotFoundException e) {
                        logger.log(Level.INFO, "Not loading: " + portRef.getServiceEndpointInterface());
                    }
                }
                if ((qname == null || !qname.equals(portRef.getQName())) && (intf == null || !intf.isInstance(proxy))) continue;
                if (!portRef.getAddresses().isEmpty()) {
                    proxy.getRequestContext().put("javax.xml.ws.service.endpoint.address", portRef.getAddresses().get(0));
                }
                if ((enableMTOM = portRef.isEnableMtom()) && proxy.getBinding() instanceof SOAPBinding) {
                    ((SOAPBinding)proxy.getBinding()).setMTOMEnabled(enableMTOM);
                }
                for (Map.Entry<Object, Object> entry : portRef.getProperties().entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    proxy.getRequestContext().put(name, value);
                }
                return;
            }
        }
    }

    private static class ProviderWrapperData {
        private final List<PortRefMetaData> portRefMetaData;
        private final ClassLoader callerClassLoader;

        public ProviderWrapperData(List<PortRefMetaData> portRefMetaDatas, ClassLoader callerClassLoader) {
            this.portRefMetaData = portRefMetaDatas;
            this.callerClassLoader = callerClassLoader;
        }

        static /* synthetic */ List access$100(ProviderWrapperData x0) {
            return x0.portRefMetaData;
        }
    }
}

