/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ssh;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ssh.OpenEJBJaasPasswordAuthenticator;
import org.apache.openejb.server.ssh.OpenEJBShellFactory;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;

public class SSHServer
implements ServerService,
SelfManaging {
    private static final String KEY_NAME = SystemInstance.get().getOptions().get("openejb.server.ssh.key", "ssh-key");
    private int port;
    private String bind;
    private String domain;
    private SshServer sshServer;

    public void start() throws ServiceException {
        this.sshServer = SshServer.setUpDefaultServer();
        this.sshServer.setPort(this.port);
        this.sshServer.setHost(this.bind);
        String basePath = SystemInstance.get().getBase().getDirectory().getAbsolutePath();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            this.sshServer.setKeyPairProvider((KeyPairProvider)new PEMGeneratorHostKeyProvider(new File(basePath, KEY_NAME + ".pem").getPath()));
        } else {
            this.sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File(basePath, KEY_NAME + ".ser").getPath()));
        }
        OpenEJBShellFactory sf = new OpenEJBShellFactory(this.bind, this.port);
        this.sshServer.setShellFactory((Factory)sf);
        OpenEJBJaasPasswordAuthenticator authenticator = new OpenEJBJaasPasswordAuthenticator();
        authenticator.setDomain(this.domain);
        this.sshServer.setPasswordAuthenticator((PasswordAuthenticator)authenticator);
        try {
            this.sshServer.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stop() throws ServiceException {
        try {
            this.sshServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getName() {
        return "ssh";
    }

    public String getIP() {
        return this.bind;
    }

    public int getPort() {
        return this.port;
    }

    public void init(Properties props) throws Exception {
        this.bind = props.getProperty("bind");
        this.domain = props.getProperty("domain");
        this.port = Integer.parseInt(props.getProperty("port"));
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }
}

