/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ssh;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.jaas.JaasPasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class OpenEJBJaasPasswordAuthenticator
extends JaasPasswordAuthenticator {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, OpenEJBJaasPasswordAuthenticator.class);
    public static final Session.AttributeKey<String> USERNAME_KEY = new Session.AttributeKey();
    public static final Session.AttributeKey<LoginContext> LOGIN_CONTEXT_KEY = new Session.AttributeKey();

    public boolean authenticate(final String username, final String password, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.getDomain(), subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            session.setAttribute(USERNAME_KEY, (Object)username);
            session.setAttribute(LOGIN_CONTEXT_KEY, (Object)loginContext);
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("can't log using username '" + username + "'", (Throwable)e);
            return false;
        }
    }
}

