/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.handler.rotating;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogManager;
import org.apache.tomee.jul.handler.rotating.Duration;

class BackgroundTaskRunner {
    private static final ExecutorService EXECUTOR_SERVICE;
    private static final boolean SYNCHRONOUS;

    BackgroundTaskRunner() {
    }

    private static String getProperty(LogManager logManager, String key) {
        String val = logManager.getProperty(key);
        return val != null ? val : System.getProperty(key);
    }

    static void push(Runnable runnable) {
        if (SYNCHRONOUS) {
            runnable.run();
        } else {
            EXECUTOR_SERVICE.submit(runnable);
        }
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        SYNCHRONOUS = Boolean.parseBoolean(BackgroundTaskRunner.getProperty(logManager, BackgroundTaskRunner.class.getName() + ".synchronous"));
        if (SYNCHRONOUS) {
            EXECUTOR_SERVICE = null;
        } else {
            String threadCount = BackgroundTaskRunner.getProperty(logManager, BackgroundTaskRunner.class.getName() + ".threads");
            String shutdownTimeoutStr = BackgroundTaskRunner.getProperty(logManager, BackgroundTaskRunner.class.getName() + ".shutdownTimeout");
            final Duration shutdownTimeout = new Duration(shutdownTimeoutStr == null ? "30 seconds" : shutdownTimeoutStr);
            EXECUTOR_SERVICE = Executors.newFixedThreadPool(Integer.parseInt(threadCount == null ? "2" : threadCount), new ThreadFactory(){
                private final ThreadGroup group;
                private final AtomicInteger threadNumber = new AtomicInteger(1);
                private final String namePrefix = "com.tomitribe.logging.jul.handler.BackgroundTaskThread-";
                {
                    SecurityManager s = System.getSecurityManager();
                    this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                }

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(this.group, r, "com.tomitribe.logging.jul.handler.BackgroundTaskThread-" + this.threadNumber.getAndIncrement(), 0L);
                    if (!t.isDaemon()) {
                        t.setDaemon(true);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    EXECUTOR_SERVICE.shutdown();
                    try {
                        EXECUTOR_SERVICE.awaitTermination(shutdownTimeout.asMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            });
        }
    }
}

