/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Constraint;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.jsr303.AnnotationProcessor;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.AppendValidationToMeta;
import org.apache.bval.jsr303.ConstraintAnnotationAttributes;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.util.ClassHelper;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.MetaConstraint;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr303MetaBeanFactory
implements MetaBeanFactory {
    protected static final Logger log = Logger.getLogger(Jsr303MetaBeanFactory.class.getName());
    protected final ApacheFactoryContext factoryContext;
    protected AnnotationProcessor annotationProcessor;

    public Jsr303MetaBeanFactory(ApacheFactoryContext factoryContext) {
        this.factoryContext = factoryContext;
        this.annotationProcessor = new AnnotationProcessor(factoryContext);
    }

    public void buildMetaBean(MetaBean metabean) {
        try {
            Class beanClass = metabean.getBeanClass();
            this.processGroupSequence(beanClass, metabean);
            ArrayList classSequence = new ArrayList();
            ClassHelper.fillFullClassHierarchyAsList(classSequence, beanClass);
            for (int i = classSequence.size() - 1; i >= 0; --i) {
                Class eachClass = (Class)classSequence.get(i);
                this.processClass(eachClass, metabean);
                this.processGroupSequence(eachClass, metabean, "{GroupSequence:" + eachClass.getCanonicalName() + "}");
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException());
        }
    }

    private void processClass(Class<?> beanClass, MetaBean metabean) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Field[] fields;
        if (!this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(beanClass)) {
            this.annotationProcessor.processAnnotations(null, beanClass, beanClass, null, new AppendValidationToMeta((FeaturesCapable)metabean));
        }
        for (Field field : fields = Jsr303MetaBeanFactory.doPrivileged(SecureActions.getDeclaredFields(beanClass))) {
            boolean create;
            MetaProperty metaProperty = metabean.getProperty(field.getName());
            if (this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(field)) continue;
            FieldAccess access = new FieldAccess(field);
            boolean bl = create = metaProperty == null;
            if (create) {
                metaProperty = Jsr303MetaBeanFactory.addMetaProperty(metabean, (AccessStrategy)access);
            }
            if (this.annotationProcessor.processAnnotations(metaProperty, beanClass, field, (AccessStrategy)access, new AppendValidationToMeta((FeaturesCapable)metaProperty)) || !create) continue;
            metabean.putProperty(metaProperty.getName(), null);
        }
        for (Method method : methods = Jsr303MetaBeanFactory.doPrivileged(SecureActions.getDeclaredMethods(beanClass))) {
            String propName = null;
            if (method.getParameterTypes().length == 0) {
                propName = MethodAccess.getPropertyName((Method)method);
            }
            if (propName != null) {
                boolean create;
                if (this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(method)) continue;
                MethodAccess access = new MethodAccess(propName, method);
                MetaProperty metaProperty = metabean.getProperty(propName);
                boolean bl = create = metaProperty == null;
                if (create) {
                    metaProperty = Jsr303MetaBeanFactory.addMetaProperty(metabean, (AccessStrategy)access);
                }
                if (this.annotationProcessor.processAnnotations(metaProperty, beanClass, method, (AccessStrategy)access, new AppendValidationToMeta((FeaturesCapable)metaProperty)) || !create) continue;
                metabean.putProperty(propName, null);
                continue;
            }
            if (!this.hasValidationConstraintsDefined(method)) continue;
            throw new ValidationException("Property " + method.getName() + " does not follow javabean conventions.");
        }
        this.addXmlConstraints(beanClass, metabean);
    }

    protected boolean hasValidationConstraintsDefined(Method method) {
        for (Annotation annot : method.getDeclaredAnnotations()) {
            if (!this.hasValidationConstraintsDefined(annot)) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidationConstraintsDefined(Annotation annot) {
        Annotation[] children;
        if (annot.annotationType().getAnnotation(Constraint.class) != null) {
            return true;
        }
        if (ConstraintAnnotationAttributes.VALUE.isDeclaredOn(annot.annotationType()) && (children = (Annotation[])ConstraintAnnotationAttributes.VALUE.getValue(annot)) != null) {
            for (Annotation child : children) {
                if (!this.hasValidationConstraintsDefined(child)) continue;
                return true;
            }
        }
        return false;
    }

    private void addXmlConstraints(Class<?> beanClass, MetaBean metabean) throws IllegalAccessException, InvocationTargetException {
        MetaProperty metaProperty;
        for (MetaConstraint<?, Annotation> meta : this.factoryContext.getFactory().getMetaConstraints(beanClass)) {
            AccessStrategy access = meta.getAccessStrategy();
            boolean create = false;
            if (access == null) {
                metaProperty = null;
            } else {
                metaProperty = metabean.getProperty(access.getPropertyName());
                boolean bl = create = metaProperty == null;
                if (create) {
                    metaProperty = Jsr303MetaBeanFactory.addMetaProperty(metabean, access);
                }
            }
            if (this.annotationProcessor.processAnnotation(meta.getAnnotation(), metaProperty, beanClass, meta.getAccessStrategy(), new AppendValidationToMeta((FeaturesCapable)(metaProperty == null ? metabean : metaProperty))) || !create) continue;
            metabean.putProperty(access.getPropertyName(), null);
        }
        for (AccessStrategy access : this.factoryContext.getFactory().getValidAccesses(beanClass)) {
            boolean create;
            metaProperty = metabean.getProperty(access.getPropertyName());
            boolean bl = create = metaProperty == null;
            if (create) {
                metaProperty = Jsr303MetaBeanFactory.addMetaProperty(metabean, access);
            }
            if (this.annotationProcessor.addAccessStrategy(metaProperty, access) || !create) continue;
            metabean.putProperty(access.getPropertyName(), null);
        }
    }

    private void processGroupSequence(Class<?> beanClass, MetaBean metabean) {
        this.processGroupSequence(beanClass, metabean, "GroupSequence");
    }

    private void processGroupSequence(Class<?> beanClass, MetaBean metabean, String key) {
        Class<?>[] groupClasses;
        GroupSequence annotation = beanClass.getAnnotation(GroupSequence.class);
        ArrayList<Group> groupSeq = (ArrayList<Group>)metabean.getFeature(key);
        if (groupSeq == null) {
            groupSeq = new ArrayList<Group>(annotation == null ? 1 : annotation.value().length);
            metabean.putFeature(key, groupSeq);
        }
        if ((groupClasses = this.factoryContext.getFactory().getDefaultSequence(beanClass)) == null || groupClasses.length == 0) {
            if (annotation == null) {
                groupSeq.add(Group.DEFAULT);
                return;
            }
            groupClasses = annotation.value();
        }
        boolean containsDefault = false;
        for (Class<?> groupClass : groupClasses) {
            if (groupClass.getName().equals(beanClass.getName())) {
                groupSeq.add(Group.DEFAULT);
                containsDefault = true;
                continue;
            }
            if (groupClass.getName().equals(Default.class.getName())) {
                throw new GroupDefinitionException("'Default.class' must not appear in @GroupSequence! Use '" + beanClass.getSimpleName() + ".class' instead.");
            }
            groupSeq.add(new Group(groupClass));
        }
        if (!containsDefault) {
            throw new GroupDefinitionException("Redefined default group sequence must contain " + beanClass.getName());
        }
        log.log(Level.FINEST, String.format("Default group sequence for bean %s is: %s", beanClass.getName(), groupSeq));
    }

    public static MetaProperty addMetaProperty(MetaBean parentMetaBean, AccessStrategy access) {
        MetaProperty result = new MetaProperty();
        String name = access.getPropertyName();
        result.setName(name);
        result.setType(access.getJavaType());
        parentMetaBean.putProperty(name, result);
        return result;
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }
}

