/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.valve;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Valve;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class LazyValve
implements Valve,
Lifecycle,
Contained {
    private volatile Valve delegate;
    private String info;
    private String delegateClassName;
    private String properties;
    private Container container;
    private volatile boolean init;
    private volatile boolean start;
    private volatile LifecycleState state;
    private final LifecycleSupport lifecycleSupport = new LifecycleSupport((Lifecycle)this);
    private Valve next;

    public void setInfo(String info) {
        this.info = info;
    }

    public void setDelegateClassName(String delegateClassName) {
        this.delegateClassName = delegateClassName;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Valve instance() {
        if (this.delegate == null) {
            LazyValve lazyValve = this;
            synchronized (lazyValve) {
                if (this.delegate == null) {
                    Object instance;
                    Class<?> clazz;
                    ClassLoader cl = null;
                    if (this.container != null && this.container.getLoader() != null && this.container.getLoader().getClassLoader() != null) {
                        cl = this.container.getLoader().getClassLoader();
                    }
                    if (cl == null) {
                        return null;
                    }
                    try {
                        clazz = cl.loadClass(this.delegateClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new TomEERuntimeException(e);
                    }
                    try {
                        ObjectRecipe recipe = new ObjectRecipe(clazz);
                        recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                        recipe.allow(Option.FIELD_INJECTION);
                        recipe.allow(Option.PRIVATE_PROPERTIES);
                        if (this.properties != null) {
                            Properties props = new PropertiesAdapter().unmarshal(this.properties.trim().replaceAll("\\p{Space}*(\\p{Alnum}*)=", "\n$1="));
                            recipe.setAllProperties((Map)props);
                        }
                        instance = recipe.create();
                    }
                    catch (Exception e) {
                        throw new TomEERuntimeException(e);
                    }
                    this.delegate = (Valve)Valve.class.cast(instance);
                    this.delegate.setNext(this.next);
                    if (Contained.class.isInstance(this.delegate)) {
                        ((Contained)Contained.class.cast(this.delegate)).setContainer(this.container);
                    }
                    if (Lifecycle.class.isInstance(this.delegate) && this.init) {
                        try {
                            Lifecycle lifecycle = (Lifecycle)Lifecycle.class.cast(this.delegate);
                            for (LifecycleListener listener : this.lifecycleSupport.findLifecycleListeners()) {
                                lifecycle.addLifecycleListener(listener);
                            }
                            lifecycle.init();
                            if (this.start) {
                                lifecycle.start();
                            }
                        }
                        catch (LifecycleException lifecycleException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this.delegate;
    }

    public String getInfo() {
        return this.info != null ? this.info : this.instance().getInfo();
    }

    public Valve getNext() {
        return this.next;
    }

    public void setNext(Valve valve) {
        this.next = valve;
        if (this.delegate != null) {
            this.delegate.setNext(this.next);
        }
    }

    public void backgroundProcess() {
        if (this.delegate != null) {
            this.delegate.backgroundProcess();
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.instance().invoke(request, response);
    }

    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        this.instance().event(request, response, event);
    }

    public boolean isAsyncSupported() {
        return this.instance().isAsyncSupported();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycleSupport.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycleSupport.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycleSupport.removeLifecycleListener(listener);
    }

    public void init() throws LifecycleException {
        if (this.instance() != null && Lifecycle.class.isInstance(this.delegate)) {
            ((Lifecycle)Lifecycle.class.cast(this.delegate)).init();
        } else {
            this.init = true;
        }
        this.state = LifecycleState.INITIALIZED;
    }

    public void start() throws LifecycleException {
        if (this.instance() != null && Lifecycle.class.isInstance(this.delegate)) {
            ((Lifecycle)Lifecycle.class.cast(this.delegate)).start();
        } else {
            this.start = true;
        }
        this.state = LifecycleState.STARTED;
    }

    public void stop() throws LifecycleException {
        if (this.instance() != null && Lifecycle.class.isInstance(this.delegate)) {
            ((Lifecycle)Lifecycle.class.cast(this.delegate)).stop();
        }
        this.state = LifecycleState.STOPPED;
    }

    public void destroy() throws LifecycleException {
        if (this.instance() != null && Lifecycle.class.isInstance(this.delegate)) {
            ((Lifecycle)Lifecycle.class.cast(this.delegate)).destroy();
        }
        this.state = LifecycleState.DESTROYED;
    }

    public LifecycleState getState() {
        return this.state;
    }

    public String getStateName() {
        return this.state.name();
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
        if (this.delegate != null && Contained.class.isInstance(this.delegate)) {
            ((Contained)Contained.class.cast(this.delegate)).setContainer(container);
        }
    }
}

