/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.Servlet;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.NamingResources;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.common.TomcatVersion;

public class BackportUtil {
    private static API api;

    public static API getAPI() {
        return api;
    }

    public static Servlet getServlet(Wrapper wrapper) {
        return BackportUtil.getAPI().getServlet(wrapper);
    }

    public static NamingContextListener getNamingContextListener(StandardContext standardContext) {
        return BackportUtil.getAPI().getNamingContextListener(standardContext);
    }

    public static String findServiceName(NamingResources naming, String refName) {
        return BackportUtil.getAPI().findServiceName(naming, refName);
    }

    public static void removeService(NamingContextListener namingContextListener, String serviceName) {
        BackportUtil.getAPI().removeService(namingContextListener, serviceName);
    }

    static {
        switch (TomcatVersion.get()) {
            case v7: {
                api = new Tomcat7();
                break;
            }
            case v6: {
                api = new Tomcat6();
                break;
            }
            case v55: {
                api = new Tomcat55();
                break;
            }
            default: {
                api = new Tomcat7();
            }
        }
    }

    public static class Tomcat55
    implements API {
        private final Field namingContextListener = this.getField(StandardContext.class, "namingContextListener");
        private final Field instance = this.getField(StandardWrapper.class, "instance");

        @Override
        public Servlet getServlet(Wrapper wrapper) {
            try {
                return (Servlet)this.instance.get(wrapper);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public NamingContextListener getNamingContextListener(StandardContext standardContext) {
            try {
                return (NamingContextListener)this.namingContextListener.get(standardContext);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String findServiceName(NamingResources naming, String refName) {
            return null;
        }

        @Override
        public void removeService(NamingContextListener namingContextListener, String serviceName) {
        }

        @Override
        public void setConfigFile(StandardContext standardContext, File contextXmlFile) {
            try {
                Method method = StandardContext.class.getMethod("setConfigFile", String.class);
                method.invoke((Object)standardContext, contextXmlFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot setConfigFile", e);
            }
        }

        private Field getField(final Class clazz, final String name) {
            return AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field field = clazz.getDeclaredField(name);
                        field.setAccessible(true);
                        return field;
                    }
                    catch (Exception e2) {
                        throw (IllegalStateException)new IllegalStateException("Unable to find or access the '" + name + "' field in " + clazz.getName()).initCause(e2);
                    }
                }
            });
        }
    }

    public static class Tomcat6
    implements API {
        @Override
        public Servlet getServlet(Wrapper wrapper) {
            return wrapper.getServlet();
        }

        @Override
        public NamingContextListener getNamingContextListener(StandardContext standardContext) {
            return standardContext.getNamingContextListener();
        }

        @Override
        public String findServiceName(NamingResources naming, String referenceName) {
            ContextService service = naming.findService(referenceName);
            return service != null ? service.getName() : null;
        }

        @Override
        public void removeService(NamingContextListener namingContextListener, String serviceName) {
            namingContextListener.removeService(serviceName);
        }

        @Override
        public void setConfigFile(StandardContext standardContext, File contextXmlFile) {
            try {
                Method method = StandardContext.class.getMethod("setConfigFile", String.class);
                method.invoke((Object)standardContext, contextXmlFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot setConfigFile", e);
            }
        }
    }

    public static class Tomcat7
    extends Tomcat6
    implements API {
        @Override
        public void setConfigFile(StandardContext standardContext, File contextXmlFile) {
            try {
                standardContext.setConfigFile(contextXmlFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new TomEERuntimeException(e);
            }
        }
    }

    public static interface API {
        public Servlet getServlet(Wrapper var1);

        public String findServiceName(NamingResources var1, String var2);

        public NamingContextListener getNamingContextListener(StandardContext var1);

        public void removeService(NamingContextListener var1, String var2);

        public void setConfigFile(StandardContext var1, File var2);
    }
}

