/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class NoIndirectionPolicy
extends IndirectionPolicy {
    @Override
    public Object buildIndirectObject(ValueHolderInterface valueHolder) {
        return valueHolder.getValue();
    }

    @Override
    public Object cloneAttribute(Object attributeValue, Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        if (buildDirectlyFromRow) {
            return attributeValue;
        }
        if (!cloningSession.isUnitOfWork()) {
            return this.mapping.buildContainerClone(attributeValue, cloningSession);
        }
        boolean isExisting = !cloningSession.isUnitOfWork() || ((UnitOfWorkImpl)cloningSession).isObjectRegistered(clone) && !((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original);
        return this.getMapping().buildCloneForPartObject(attributeValue, original, cacheKey, clone, cloningSession, refreshCascade, isExisting, isExisting);
    }

    protected boolean collectionTypeIsValid(Class collectionType) {
        return this.getCollectionMapping().getContainerPolicy().isValidContainerType(collectionType);
    }

    @Override
    public AbstractRecord extractReferenceRow(Object referenceObject) {
        return null;
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        this.mapping.fixRealObjectReferences(object, objectDescriptors, processedObjects, query, session);
    }

    @Override
    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        return unitOfWorkIndirectionObject;
    }

    @Override
    public Object getOriginalValueHolder(Object unitOfWorkIndirectionObject, AbstractSession session) {
        return unitOfWorkIndirectionObject;
    }

    @Override
    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        return attribute;
    }

    @Override
    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        throw DescriptorException.invalidIndirectionPolicyOperation(this, "getValueFromRemoteValueHolder");
    }

    @Override
    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        throw DescriptorException.invalidIndirectionPolicyOperation(this, "mergeRemoteValueHolder");
    }

    @Override
    public Object nullValueFromRow() {
        return null;
    }

    @Override
    public boolean objectIsInstantiated(Object object) {
        return true;
    }

    @Override
    public boolean objectIsEasilyInstantiated(Object object) {
        return true;
    }

    protected boolean typeIsValid(Class attributeType) {
        return attributeType != ClassConstants.ValueHolderInterface_Class;
    }

    @Override
    public boolean usesIndirection() {
        return false;
    }

    @Override
    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeType(attributeType, checker);
        if (!this.typeIsValid(attributeType)) {
            checker.handleError(DescriptorException.attributeAndMappingWithoutIndirectionMismatch(this.mapping));
        }
    }

    @Override
    public void validateDeclaredAttributeTypeForCollection(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeTypeForCollection(attributeType, checker);
        if (!this.collectionTypeIsValid(attributeType)) {
            InterfaceContainerPolicy policy = (InterfaceContainerPolicy)this.getCollectionMapping().getContainerPolicy();
            checker.handleError(DescriptorException.attributeTypeNotValid(this.getCollectionMapping(), policy.getInterfaceType()));
        }
    }

    @Override
    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnType(returnType, checker);
        if (!this.typeIsValid(returnType)) {
            checker.handleError(DescriptorException.returnAndMappingWithoutIndirectionMismatch(this.mapping));
        }
    }

    @Override
    public void validateGetMethodReturnTypeForCollection(Class returnType, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnTypeForCollection(returnType, checker);
        if (!this.collectionTypeIsValid(returnType)) {
            checker.handleError(DescriptorException.getMethodReturnTypeNotValid(this.getCollectionMapping()));
        }
    }

    @Override
    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterType(parameterType, checker);
        if (!this.typeIsValid(parameterType)) {
            checker.handleError(DescriptorException.parameterAndMappingWithoutIndirectionMismatch(this.mapping));
        }
    }

    @Override
    public void validateSetMethodParameterTypeForCollection(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterTypeForCollection(parameterType, checker);
        if (!this.collectionTypeIsValid(parameterType)) {
            checker.handleError(DescriptorException.setMethodParameterTypeNotValid(this.getCollectionMapping()));
        }
    }

    @Override
    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery, CacheKey parentCacheKey) {
        return this.getForeignReferenceMapping().extractResultFromBatchQuery(batchQuery, parentCacheKey, row, originalQuery.getSession(), originalQuery);
    }

    @Override
    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        return this.getTransformationMapping().invokeAttributeTransformer(row, object, session);
    }

    @Override
    public Object valueFromQuery(ReadQuery query, AbstractRecord row, Object sourceObject, AbstractSession session) {
        return this.valueFromQuery(query, row, session);
    }

    @Override
    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        return session.executeQuery((DatabaseQuery)query, row);
    }

    @Override
    public Object valueFromRow(Object object) {
        return object;
    }

    @Override
    public void setRealAttributeValueInObject(Object target, Object attributeValue, boolean trackChanges) {
        PropertyChangeListener listener;
        Object oldValue = null;
        if (trackChanges && target instanceof ChangeTracker) {
            oldValue = this.getRealAttributeValueFromObject(target, this.mapping.getAttributeValueFromObject(target));
        }
        this.setRealAttributeValueInObject(target, attributeValue);
        if (trackChanges && target instanceof ChangeTracker && (listener = ((ChangeTracker)target)._persistence_getPropertyChangeListener()) != null && attributeValue != oldValue) {
            listener.propertyChange(new PropertyChangeEvent(target, this.mapping.getAttributeName(), oldValue, attributeValue));
        }
    }
}

