/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.DebugObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class DebugUtil {
    private static final Logger LOGGER = Logger.getLogger(DebugUtil.class.getPackage().getName());
    private static boolean keepWaiting = true;
    private static int curDepth = 0;

    public DebugUtil() {
        this.init();
    }

    protected void init() {
    }

    public static void setKeepWaiting(boolean keepWaiting) {
        DebugUtil.keepWaiting = keepWaiting;
    }

    public static void waitForDebugger() {
        while (keepWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("DebugUtil.waitForDebugger(): Exception: " + e.getMessage());
            }
        }
    }

    private static void indentPrintln(Writer out, String str) {
        block3: {
            try {
                for (int i = 0; i < curDepth; ++i) {
                    out.write("  ");
                }
                out.write(str + "\n");
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                LOGGER.log(Level.FINEST, "Unable to write indent", ioe);
            }
        }
    }

    private static void assertSerializability(StringBuilder builder, Object toPrint) {
        DebugObjectOutputStream doos = null;
        try {
            ByteArrayOutputStream base = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(base);
            doos = new DebugObjectOutputStream(oos);
            doos.writeObject(toPrint);
        }
        catch (IOException ioe) {
            List<Object> pathToBadObject = doos.getStack();
            builder.append("Path to non-Serializable Object: \n");
            for (Object cur : pathToBadObject) {
                builder.append(cur.toString()).append("\n");
            }
        }
    }

    private static void indentPrintln(Logger out, Object toPrint) {
        StringBuilder builder = new StringBuilder();
        String str = null == toPrint ? "null" : toPrint.toString();
        for (int i = 0; i < curDepth; ++i) {
            builder.append("  ");
        }
        builder.append(str + "\n");
        if (!(toPrint instanceof String)) {
            DebugUtil.assertSerializability(builder, toPrint);
        }
        out.severe(builder.toString());
    }

    public static String printTree(UIComponent root) {
        FastStringWriter writer = new FastStringWriter(1024);
        DebugUtil.printTree(root, (Writer)writer);
        return ((Object)writer).toString();
    }

    public static void printTree(UIComponent root, PrintStream out) {
        try {
            PrintWriter writer = new PrintWriter(new PrintStream((OutputStream)out, true, "UTF-8"));
            DebugUtil.printTree(root, (Writer)writer);
            writer.flush();
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void printTree(UIComponent root, Logger logger, Level level) {
        StringWriter sw = new StringWriter();
        DebugUtil.printTree(root, (Writer)sw);
        logger.log(level, sw.toString());
    }

    public static void printTree(UIComponent root, Writer out) {
        if (null == root) {
            return;
        }
        Object value = null;
        DebugUtil.indentPrintln(out, "id:" + root.getId());
        DebugUtil.indentPrintln(out, "type:" + root.getClass().getName());
        if (root instanceof UISelectOne) {
            Iterator<SelectItem> items = null;
            try {
                items = RenderKitUtils.getSelectItems(FacesContext.getCurrentInstance(), root);
            }
            catch (Exception e) {
                DebugUtil.indentPrintln(out, " { SelectItem(s) not resolvable at this point in time }");
            }
            if (items != null) {
                DebugUtil.indentPrintln(out, " {");
                while (items.hasNext()) {
                    SelectItem curItem = items.next();
                    DebugUtil.indentPrintln(out, "\t value = " + curItem.getValue() + ", label = " + curItem.getLabel() + ", description = " + curItem.getDescription());
                }
                DebugUtil.indentPrintln(out, " }");
            }
        } else {
            ValueExpression ve = null;
            if (root instanceof ValueHolder) {
                ve = root.getValueExpression("value");
                try {
                    value = ((ValueHolder)((Object)root)).getValue();
                }
                catch (Exception e) {
                    value = "UNAVAILABLE";
                }
            }
            if (ve != null) {
                DebugUtil.indentPrintln(out, "expression/value = " + ve.getExpressionString() + " : " + value);
            } else {
                DebugUtil.indentPrintln(out, "value = " + value);
            }
            Iterator<String> it = root.getAttributes().keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    String val;
                    String attrName = it.next();
                    ve = root.getValueExpression(attrName);
                    String expr = null;
                    if (ve != null) {
                        expr = ve.getExpressionString();
                    }
                    try {
                        val = root.getAttributes().get(attrName).toString();
                    }
                    catch (Exception e) {
                        val = "UNAVAILABLE";
                    }
                    if (expr != null) {
                        DebugUtil.indentPrintln(out, "attr = " + attrName + " : [" + expr + " : " + val + " ]");
                        continue;
                    }
                    DebugUtil.indentPrintln(out, "attr = " + attrName + " : " + val);
                }
            }
        }
        ++curDepth;
        Iterator<UIComponent> it = root.getChildren().iterator();
        for (UIComponent uiComponent : root.getFacets().values()) {
            DebugUtil.printTree(uiComponent, out);
        }
        while (it.hasNext()) {
            DebugUtil.printTree(it.next(), out);
        }
        --curDepth;
    }

    public static void simplePrintTree(UIComponent root, String duplicateId, Writer out) {
        if (null == root) {
            return;
        }
        if (duplicateId.equals(root.getClientId())) {
            DebugUtil.indentPrintln(out, "+id: " + root.getId() + "  <===============");
        } else {
            DebugUtil.indentPrintln(out, "+id: " + root.getId());
        }
        DebugUtil.indentPrintln(out, " type: " + root.toString());
        ++curDepth;
        for (UIComponent uiComponent : root.getFacets().values()) {
            DebugUtil.simplePrintTree(uiComponent, duplicateId, out);
        }
        for (UIComponent uiComponent : root.getChildren()) {
            DebugUtil.simplePrintTree(uiComponent, duplicateId, out);
        }
        --curDepth;
    }

    public static void printState(Map state, Logger out) {
        Set entrySet = state.entrySet();
        for (Map.Entry cur : entrySet) {
            Object key = cur.getKey();
            Object value = cur.getValue();
            String keyIsSerializable = key instanceof Serializable ? "true" : "+_+_+_+FALSE+_+_+_+_";
            String valueIsSerializable = value instanceof Serializable ? "true" : "+_+_+_+FALSE+_+_+_+_";
            out.severe("key: " + key.toString() + " class:" + key.getClass() + " Serializable: " + keyIsSerializable);
            out.severe("value: " + value.toString() + " class:" + key.getClass() + " Serializable: " + keyIsSerializable);
            if (!(value instanceof Object[])) continue;
            DebugUtil.printTree((Object[])value, out);
        }
    }

    public static void printTree(Object[] root, Writer out) {
        if (null == root) {
            DebugUtil.indentPrintln(out, "null");
            return;
        }
        for (int i = 0; i < root.length; ++i) {
            Object obj = root[i];
            if (null == obj) {
                DebugUtil.indentPrintln(out, "null");
                continue;
            }
            if (obj.getClass().isArray()) {
                ++curDepth;
                DebugUtil.printTree((Object[])obj, out);
                --curDepth;
                continue;
            }
            DebugUtil.indentPrintln(out, obj.toString());
        }
    }

    public static void printTree(Object[] root, Logger out) {
        if (null == root) {
            DebugUtil.indentPrintln(out, (Object)"null");
            return;
        }
        for (int i = 0; i < root.length; ++i) {
            Object obj = root[i];
            if (null == obj) {
                DebugUtil.indentPrintln(out, (Object)"null");
                continue;
            }
            if (obj.getClass().isArray()) {
                ++curDepth;
                DebugUtil.printTree((Object[])obj, out);
                --curDepth;
                continue;
            }
            if (obj instanceof List) {
                DebugUtil.printList((List)obj, out);
                continue;
            }
            DebugUtil.indentPrintln(out, obj);
        }
    }

    public static void printList(List list, Logger out) {
        for (Object cur : list) {
            if (cur instanceof List) {
                ++curDepth;
                DebugUtil.printList((List)cur, out);
                --curDepth;
                continue;
            }
            DebugUtil.indentPrintln(out, cur);
        }
    }
}

