/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.util.Cache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;

public class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private final Compiler compiler;
    private Map<String, URL> relativeLocations;
    private final ResourceResolver resolver;
    private final URL baseUrl;
    private final long refreshPeriod;
    private final FaceletCache<DefaultFacelet> cache;
    Cache<String, IdMapper> idMappers;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        this(compiler, resolver, refreshPeriod, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod, FaceletCache cache) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resolver);
        this.compiler = compiler;
        this.relativeLocations = new ConcurrentHashMap<String, URL>();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        this.idMappers = new Cache<String, IdMapper>(new IdMapperFactory());
        this.refreshPeriod = refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using ResourceResolver: {0}", resolver);
            log.log(Level.FINE, "Using Refresh Period: {0}", refreshPeriod);
        }
        this.cache = cache;
        FaceletCache.MemberFactory<DefaultFacelet> faceletFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            @Override
            public DefaultFacelet newInstance(URL key) throws IOException {
                return DefaultFaceletFactory.this.createFacelet(key);
            }
        };
        FaceletCache.MemberFactory<DefaultFacelet> metadataFaceletFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            @Override
            public DefaultFacelet newInstance(URL key) throws IOException {
                return DefaultFaceletFactory.this.createMetadataFacelet(key);
            }
        };
        try {
            Method m = FaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
            m.setAccessible(true);
            m.invoke(this.cache, faceletFactory, metadataFaceletFactory);
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, null, ex);
            }
            throw new FacesException(ex);
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getFacelet(String uri) throws IOException {
        return this.getFacelet(this.resolveURL(uri));
    }

    public Facelet getMetadataFacelet(String uri) throws IOException {
        return this.getMetadataFacelet(this.resolveURL(uri));
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FacesFileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(URL url) throws IOException {
        DefaultFacelet _facelet = null;
        Facelet result = this.cache.getFacelet(url);
        if (result instanceof DefaultFacelet) {
            String xmlDecl;
            _facelet = (DefaultFacelet)result;
            String docType = _facelet.getSavedDoctype();
            if (null != docType) {
                Util.saveDOCTYPEToFacesContextAttributes(docType);
            }
            if (null != (xmlDecl = _facelet.getSavedXMLDecl())) {
                Util.saveXMLDECLToFacesContextAttributes(xmlDecl);
            }
        }
        return result;
    }

    public Facelet getMetadataFacelet(URL url) throws IOException {
        return this.cache.getViewMetadataFacelet(url);
    }

    public boolean needsToBeRefreshed(URL url) {
        return !this.cache.isFaceletCached(url);
    }

    private URL resolveURL(String uri) throws IOException {
        URL url = this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this.baseUrl, uri);
            if (url != null) {
                this.relativeLocations.put(uri, url);
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return url;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Metadata Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.metadataCompile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdMapperFactory
    implements Cache.Factory<String, IdMapper> {
        private IdMapperFactory() {
        }

        @Override
        public IdMapper newInstance(String arg) throws InterruptedException {
            return new IdMapper();
        }
    }
}

