/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionFactory;
import org.apache.openejb.resource.activemq.ConnectionWrapper;

public class ConnectionFactoryWrapper
implements ConnectionFactory,
TopicConnectionFactory,
QueueConnectionFactory {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final ArrayList<ConnectionWrapper> connections = new ArrayList();
    private final ActiveMQConnectionFactory factory;
    private final String name;

    public ConnectionFactoryWrapper(String name, Object factory) {
        this.name = name;
        this.factory = (ActiveMQConnectionFactory)ActiveMQConnectionFactory.class.cast(factory);
    }

    public Connection createConnection() throws JMSException {
        return ConnectionFactoryWrapper.getConnection(this.name, this.factory.createConnection());
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return ConnectionFactoryWrapper.getConnection(this.name, this.factory.createConnection(userName, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnection(String name, Connection connection) {
        lock.lock();
        try {
            ConnectionWrapper wrapper = new ConnectionWrapper(name, connection);
            connections.add(wrapper);
            ConnectionWrapper connectionWrapper = wrapper;
            return connectionWrapper;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void remove(ConnectionWrapper connectionWrapper) {
        lock.lock();
        try {
            connections.remove(connectionWrapper);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeConnections() {
        lock.lock();
        try {
            Iterator<ConnectionWrapper> iterator = connections.iterator();
            while (iterator.hasNext()) {
                ConnectionWrapper next = iterator.next();
                iterator.remove();
                try {
                    next.close();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    Logger.getLogger(ConnectionFactoryWrapper.class.getName()).log(Level.SEVERE, "Closed a JMS connection. You have an application that fails to close a connection created by this injection path: " + next.getName());
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)QueueConnection.class.cast(ConnectionFactoryWrapper.getConnection(this.name, (Connection)this.factory.createQueueConnection()));
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)QueueConnection.class.cast(ConnectionFactoryWrapper.getConnection(this.name, (Connection)this.factory.createQueueConnection(userName, password)));
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)TopicConnection.class.cast(ConnectionFactoryWrapper.getConnection(this.name, (Connection)this.factory.createTopicConnection()));
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)TopicConnection.class.cast(ConnectionFactoryWrapper.getConnection(this.name, (Connection)this.factory.createTopicConnection(userName, password)));
    }
}

