/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.timer.CalendarTimerData;
import org.apache.openejb.core.timer.DefaultTimerThreadPoolAdapter;
import org.apache.openejb.core.timer.EJBCronTriggerPersistenceDelegate;
import org.apache.openejb.core.timer.EjbTimeoutJob;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.core.timer.TimerType;
import org.apache.openejb.core.timer.quartz.PatchedStdJDBCDelegate;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.quartz.JobBuilder;
import org.apache.openejb.quartz.JobDataMap;
import org.apache.openejb.quartz.JobDetail;
import org.apache.openejb.quartz.Scheduler;
import org.apache.openejb.quartz.SchedulerException;
import org.apache.openejb.quartz.SchedulerListener;
import org.apache.openejb.quartz.Trigger;
import org.apache.openejb.quartz.TriggerKey;
import org.apache.openejb.quartz.impl.StdSchedulerFactory;
import org.apache.openejb.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.apache.openejb.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.apache.openejb.quartz.impl.triggers.AbstractTrigger;
import org.apache.openejb.quartz.listeners.SchedulerListenerSupport;
import org.apache.openejb.quartz.simpl.RAMJobStore;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SetAccessible;

public class EjbTimerServiceImpl
implements EjbTimerService,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    public static final String QUARTZ_JMX = "org.apache.openejb.quartz.scheduler.jmx.export";
    public static final String QUARTZ_MAKE_SCHEDULER_THREAD_DAEMON = "org.apache.openejb.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String OPENEJB_TIMEOUT_JOB_NAME = "OPENEJB_TIMEOUT_JOB";
    public static final String OPENEJB_TIMEOUT_JOB_GROUP_NAME = "OPENEJB_TIMEOUT_GROUP";
    public static final String EJB_TIMER_RETRY_ATTEMPTS = "EjbTimer.RetryAttempts";
    public static final String OPENEJB_QUARTZ_USE_TCCL = "openejb.quartz.use-TCCL";
    private boolean transacted;
    private int retryAttempts;
    private transient TransactionManager transactionManager;
    private transient BeanContext deployment;
    private transient TimerStore timerStore;
    private transient Scheduler scheduler;

    public EjbTimerServiceImpl(BeanContext deployment, TimerStore timerStore) {
        this(deployment, EjbTimerServiceImpl.getDefaultTransactionManager(), timerStore, -1);
    }

    public static TransactionManager getDefaultTransactionManager() {
        return SystemInstance.get().getComponent(TransactionManager.class);
    }

    public EjbTimerServiceImpl(BeanContext deployment, TransactionManager transactionManager, TimerStore timerStore, int retryAttempts) {
        this.deployment = deployment;
        this.transactionManager = transactionManager;
        this.timerStore = timerStore;
        TransactionType transactionType = deployment.getTransactionType(deployment.getEjbTimeout());
        this.transacted = transactionType == TransactionType.Required || transactionType == TransactionType.RequiresNew;
        this.retryAttempts = retryAttempts;
        if (retryAttempts < 0) {
            this.retryAttempts = deployment.getOptions().get(EJB_TIMER_RETRY_ATTEMPTS, 1);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.deployment.getDeploymentID().toString());
        out.writeBoolean(this.transacted);
        out.writeInt(this.retryAttempts);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        String dId = in.readUTF();
        this.transacted = in.readBoolean();
        this.retryAttempts = in.readInt();
        this.deployment = SystemInstance.get().getComponent(ContainerSystem.class).getBeanContext(dId);
        this.transactionManager = EjbTimerServiceImpl.getDefaultTransactionManager();
        this.timerStore = this.deployment.getEjbTimerService().getTimerStore();
        this.scheduler = (Scheduler)Proxy.newProxyInstance(this.deployment.getClassLoader(), new Class[]{Scheduler.class}, (InvocationHandler)new LazyScheduler(this.deployment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Scheduler getDefaultScheduler(BeanContext deployment) {
        Scheduler thisScheduler;
        Scheduler scheduler = deployment.get(Scheduler.class);
        if (scheduler != null) {
            boolean valid;
            try {
                valid = !scheduler.isShutdown();
            }
            catch (Exception ignored) {
                valid = false;
            }
            if (valid) {
                return scheduler;
            }
        }
        String string = deployment.getId();
        synchronized (string) {
            scheduler = deployment.get(Scheduler.class);
            if (scheduler != null) {
                return scheduler;
            }
            Properties properties = new Properties();
            int quartzProps = 0;
            quartzProps += EjbTimerServiceImpl.putAll(properties, SystemInstance.get().getProperties());
            quartzProps += EjbTimerServiceImpl.putAll(properties, deployment.getModuleContext().getAppContext().getProperties());
            quartzProps += EjbTimerServiceImpl.putAll(properties, deployment.getModuleContext().getProperties());
            boolean newInstance = (quartzProps += EjbTimerServiceImpl.putAll(properties, deployment.getProperties())) > 0;
            SystemInstance systemInstance = SystemInstance.get();
            scheduler = systemInstance.getComponent(Scheduler.class);
            if (scheduler == null || newInstance) {
                boolean useTccl = "true".equalsIgnoreCase(properties.getProperty(OPENEJB_QUARTZ_USE_TCCL, "false"));
                EjbTimerServiceImpl.defaultQuartzConfiguration(properties, deployment, newInstance, useTccl);
                try {
                    ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                    if (useTccl) {
                        Thread.currentThread().setContextClassLoader(deployment.getClassLoader());
                    } else {
                        Thread.currentThread().setContextClassLoader(EjbTimerServiceImpl.class.getClassLoader());
                    }
                    try {
                        thisScheduler = new StdSchedulerFactory(properties).getScheduler();
                        thisScheduler.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldCl);
                    }
                    JobDetail job = JobBuilder.newJob(EjbTimeoutJob.class).withIdentity(OPENEJB_TIMEOUT_JOB_NAME, OPENEJB_TIMEOUT_JOB_GROUP_NAME).storeDurably(true).requestRecovery(false).build();
                    thisScheduler.addJob(job, true);
                }
                catch (SchedulerException e) {
                    throw new OpenEJBRuntimeException("Fail to initialize the default scheduler", e);
                }
                if (!newInstance) {
                    systemInstance.setComponent(Scheduler.class, thisScheduler);
                }
            } else {
                thisScheduler = scheduler;
            }
            deployment.set(Scheduler.class, thisScheduler);
        }
        return thisScheduler;
    }

    private static void defaultQuartzConfiguration(Properties properties, BeanContext deployment, boolean newInstance, boolean tccl) {
        String defaultThreadPool = DefaultTimerThreadPoolAdapter.class.getName();
        if (!properties.containsKey("org.apache.openejb.quartz.threadPool.class")) {
            properties.put("org.apache.openejb.quartz.threadPool.class", defaultThreadPool);
        }
        if (!properties.containsKey("org.apache.openejb.quartz.scheduler.instanceName")) {
            properties.put("org.apache.openejb.quartz.scheduler.instanceName", "OpenEJB-TimerService-Scheduler");
        }
        if (!properties.containsKey("org.apache.openejb.quartz.scheduler.skipUpdateCheck")) {
            properties.put("org.apache.openejb.quartz.scheduler.skipUpdateCheck", "true");
        }
        if (!properties.containsKey("org.terracotta.quartz.skipUpdateCheck")) {
            properties.put("org.terracotta.quartz.skipUpdateCheck", "true");
        }
        if (!properties.containsKey("org.apache.openejb.quartz.scheduler.interruptJobsOnShutdown")) {
            properties.put("org.apache.openejb.quartz.scheduler.interruptJobsOnShutdown", "true");
        }
        if (!properties.containsKey("org.apache.openejb.quartz.scheduler.interruptJobsOnShutdownWithWait")) {
            properties.put("org.apache.openejb.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        }
        if (!properties.containsKey(QUARTZ_MAKE_SCHEDULER_THREAD_DAEMON)) {
            properties.put(QUARTZ_MAKE_SCHEDULER_THREAD_DAEMON, "true");
        }
        if (!properties.containsKey(QUARTZ_JMX) && LocalMBeanServer.isJMXActive()) {
            properties.put(QUARTZ_JMX, "true");
        }
        if (!properties.containsKey("org.apache.openejb.quartz.scheduler.instanceId")) {
            if (!newInstance) {
                properties.setProperty("org.apache.openejb.quartz.scheduler.instanceId", "OpenEJB");
            } else {
                properties.setProperty("org.apache.openejb.quartz.scheduler.instanceId", deployment.getDeploymentID().toString());
            }
        }
        if (!tccl) {
            String driverDelegate = properties.getProperty("org.apache.openejb.quartz.jobStore.driverDelegateClass");
            if (driverDelegate != null && StdJDBCDelegate.class.getName().equals(driverDelegate)) {
                properties.put("org.apache.openejb.quartz.jobStore.driverDelegateClass", PatchedStdJDBCDelegate.class.getName());
            } else if (driverDelegate != null) {
                log.info("Using '" + driverDelegate + "' driver delegate with quartz so ensure it does not use ObjectInputStream, else your custom TimerData may encounter issues");
            }
            if (properties.containsKey("org.apache.openejb.quartz.jobStore.class") && !properties.containsKey("org.apache.openejb.quartz.jobStore.driverDelegateInitString")) {
                try {
                    Class<?> clazz = EjbTimerServiceImpl.class.getClassLoader().loadClass(properties.getProperty("org.apache.openejb.quartz.jobStore.class"));
                    if (JobStoreSupport.class.isAssignableFrom(clazz)) {
                        properties.put("org.apache.openejb.quartz.jobStore.driverDelegateInitString", "triggerPersistenceDelegateClasses=" + EJBCronTriggerPersistenceDelegate.class.getName());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (defaultThreadPool.equals(properties.get("org.apache.openejb.quartz.threadPool.class"))) {
            if (properties.containsKey("org.apache.openejb.quartz.threadPool.threadCount") && !properties.containsKey("openejb.timer.pool.size")) {
                log.info("Found property 'org.apache.openejb.quartz.threadPool.threadCount' for default thread pool, please use 'openejb.timer.pool.size' instead");
                properties.put("openejb.timer.pool.size", properties.getProperty("org.apache.openejb.quartz.threadPool.threadCount"));
            }
            if (properties.containsKey("org.quartz.threadPool.threadCount") && !properties.containsKey("openejb.timer.pool.size")) {
                log.info("Found property 'org.quartz.threadPool.threadCount' for default thread pool, please use 'openejb.timer.pool.size' instead");
                properties.put("openejb.timer.pool.size", properties.getProperty("org.quartz.threadPool.threadCount"));
            }
        }
        if (!properties.getProperty("org.apache.openejb.quartz.jobStore.class", RAMJobStore.class.getName()).equals(RAMJobStore.class.getName())) {
            properties.put("org.apache.openejb.quartz.jobStore.makeThreadsDaemons", properties.getProperty("org.apache.openejb.quartz.jobStore.makeThreadsDaemon", "true"));
        }
    }

    private static int putAll(Properties a, Properties b) {
        int number = 0;
        for (Map.Entry<Object, Object> entry : b.entrySet()) {
            Object value;
            String key = entry.getKey().toString();
            if (key.startsWith("org.quartz.") || key.startsWith("org.apache.openejb.quartz.") || key.startsWith("openejb.quartz.") || "openejb.timer.pool.size".equals(key) || "org.terracotta.quartz.skipUpdateCheck".equals(key)) {
                ++number;
            }
            if (!String.class.isInstance(value = entry.getValue())) continue;
            if (!key.startsWith("org.quartz")) {
                a.put(key, value);
                continue;
            }
            a.put("org.apache.openejb.quartz" + key.substring("org.quartz".length()), value);
        }
        return number;
    }

    @Override
    public void stop() {
        this.cleanTimerData();
        this.shutdownMyScheduler();
    }

    private void cleanTimerData() {
        if (this.timerStore == null || this.scheduler == null || this.deployment == null) {
            return;
        }
        Collection<TimerData> timerDatas = this.timerStore.getTimers(this.deployment.getDeploymentID().toString());
        if (timerDatas == null) {
            return;
        }
        for (TimerData data : timerDatas) {
            Trigger trigger = data.getTrigger();
            if (trigger == null) continue;
            TriggerKey key = trigger.getKey();
            try {
                data.stop();
            }
            catch (EJBException ignored) {
                log.warning("An error occured deleting trigger '" + key + "' on bean " + this.deployment.getDeploymentID());
            }
        }
    }

    private void shutdownMyScheduler() {
        if (this.scheduler == null) {
            return;
        }
        boolean defaultScheduler = false;
        Scheduler ds = SystemInstance.get().getComponent(Scheduler.class);
        try {
            defaultScheduler = ds == this.scheduler || this.scheduler.getSchedulerName().equals(ds.getSchedulerName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!defaultScheduler) {
            EjbTimerServiceImpl.shutdown(this.scheduler);
        }
    }

    public static void shutdown() {
        EjbTimerServiceImpl.shutdown(SystemInstance.get().getComponent(Scheduler.class));
    }

    private static void shutdown(final Scheduler s) throws OpenEJBRuntimeException {
        block16: {
            try {
                if (null == s || s.isShutdown() || !s.isStarted()) break block16;
                try {
                    s.pauseAll();
                }
                catch (SchedulerException schedulerException) {
                    // empty catch block
                }
                long timeout = SystemInstance.get().getOptions().get("openejb.quartz.timeout", 10000L);
                if (timeout < 1000L) {
                    timeout = 1000L;
                }
                if (timeout > 60000L) {
                    timeout = 60000L;
                }
                final CountDownLatch shutdownWait = new CountDownLatch(1);
                final AtomicReference<Throwable> ex = new AtomicReference<Throwable>();
                String n = "Unknown";
                try {
                    n = s.getSchedulerName();
                }
                catch (SchedulerException e) {
                    log.warning("EjbTimerService scheduler has no name");
                }
                final String name = n;
                Thread stopThread = new Thread(name + " shutdown wait"){

                    @Override
                    public void run() {
                        try {
                            s.getListenerManager().addSchedulerListener((SchedulerListener)new SchedulerListenerSupport(){

                                public void schedulerShutdown() {
                                    shutdownWait.countDown();
                                }
                            });
                            s.shutdown(true);
                        }
                        catch (Throwable e) {
                            ex.set(e);
                            shutdownWait.countDown();
                        }
                    }
                };
                stopThread.setDaemon(true);
                stopThread.start();
                boolean stopped = false;
                try {
                    stopped = shutdownWait.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    if (!stopped || !s.isShutdown()) {
                        stopThread = new Thread(name + " shutdown forced"){

                            @Override
                            public void run() {
                                try {
                                    s.shutdown(false);
                                    log.warning("Forced " + name + " shutdown - Jobs may be incomplete");
                                }
                                catch (Throwable e) {
                                    ex.set(e);
                                }
                            }
                        };
                        stopThread.setDaemon(true);
                        stopThread.start();
                        try {
                            stopThread.join(timeout);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Throwable e) {
                    ex.set(e);
                }
                Throwable t = (Throwable)ex.get();
                if (null != t) {
                    throw new OpenEJBRuntimeException("Unable to shutdown " + name + " scheduler", t);
                }
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void start() throws TimerStoreException {
        if (this.isStarted()) {
            return;
        }
        this.scheduler = EjbTimerServiceImpl.getDefaultScheduler(this.deployment);
        Collection<TimerData> timerDatas = this.timerStore.loadTimers(this, (String)this.deployment.getDeploymentID());
        for (TimerData timerData : timerDatas) {
            this.initializeNewTimer(timerData);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void schedule(TimerData timerData) throws TimerStoreException {
        this.start();
        if (this.scheduler == null) {
            throw new TimerStoreException("Scheduler is not configured properly");
        }
        timerData.setScheduler(this.scheduler);
        Trigger trigger = timerData.getTrigger();
        if (null == trigger) {
            try {
                if (!this.scheduler.isShutdown()) {
                    log.warning("Failed to schedule: " + timerData.getInfo());
                }
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
        if (!(trigger instanceof AbstractTrigger)) {
            throw new OpenEJBRuntimeException("the trigger was not an AbstractTrigger - Should not be possible: " + trigger);
        }
        AbstractTrigger atrigger = (AbstractTrigger)trigger;
        atrigger.setJobName(OPENEJB_TIMEOUT_JOB_NAME);
        atrigger.setJobGroup(OPENEJB_TIMEOUT_JOB_GROUP_NAME);
        JobDataMap triggerDataMap = trigger.getJobDataMap();
        triggerDataMap.put("EJB_TIMERS_SERVICE", (Object)this);
        triggerDataMap.put("TIMER_DATA", (Object)timerData);
        try {
            TriggerKey triggerKey = new TriggerKey(atrigger.getName(), atrigger.getGroup());
            if (!this.scheduler.checkExists(triggerKey)) {
                this.scheduler.scheduleJob(trigger);
            } else if (Trigger.TriggerState.PAUSED.equals((Object)this.scheduler.getTriggerState(triggerKey))) {
                this.scheduler.unscheduleJob(triggerKey);
                this.scheduler.scheduleJob(trigger);
            }
        }
        catch (Exception e) {
            log.error("Could not schedule timer " + timerData, e);
        }
    }

    public void cancelled(TimerData timerData) {
        this.timerStore.removeTimer(timerData.getId());
    }

    public void addTimerData(TimerData timerData) {
        try {
            this.timerStore.addTimerData(timerData);
        }
        catch (Exception e) {
            log.warning("Could not add timer of type " + timerData.getType().name() + " due to " + e.getMessage());
        }
    }

    @Override
    public Timer getTimer(long timerId) {
        TimerData timerData = this.timerStore.getTimer((String)this.deployment.getDeploymentID(), timerId);
        if (timerData != null) {
            return timerData.getTimer();
        }
        return null;
    }

    @Override
    public Collection<Timer> getTimers(Object primaryKey) throws IllegalStateException {
        this.checkState();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            if (CalendarTimerData.class.isInstance(timerData) && ((CalendarTimerData)CalendarTimerData.class.cast(timerData)).isAutoCreated()) continue;
            timers.add(timerData.getTimer());
        }
        return timers;
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration is negative: " + duration);
        }
        this.checkState();
        Date expiration = new Date(System.currentTimeMillis() + duration);
        try {
            TimerData timerData = this.timerStore.createSingleActionTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, expiration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initialDuration is negative: " + initialDuration);
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        try {
            TimerData timerData = this.timerStore.createIntervalTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, initialExpiration, intervalDuration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration is null");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration is negative: " + expiration.getTime());
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createSingleActionTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, expiration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration is null");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration is negative: " + initialExpiration.getTime());
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createIntervalTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, initialExpiration, intervalDuration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, ScheduleExpression scheduleExpression, TimerConfig timerConfig) {
        if (scheduleExpression == null) {
            throw new IllegalArgumentException("scheduleExpression is null");
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createCalendarTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, scheduleExpression, timerConfig, false);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public TimerStore getTimerStore() {
        return this.timerStore;
    }

    @Override
    public boolean isStarted() {
        return this.scheduler != null;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private void initializeNewTimer(TimerData timerData) {
        timerData.newTimer();
    }

    private void checkState() throws IllegalStateException {
        BaseContext context = (BaseContext)this.deployment.get(EJBContext.class);
        context.check(BaseContext.Call.timerMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void ejbTimeout(TimerData timerData) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            Timer timer = this.getTimer(timerData.getId());
            if (timer == null && this.timerStore instanceof MemoryTimerStore && timerData.getTimer() != null) {
                try {
                    this.timerStore.addTimerData(timerData);
                    timer = timerData.getTimer();
                }
                catch (TimerStoreException timerStoreException) {
                    // empty catch block
                }
            }
            for (int tries = 0; tries < 1 + this.retryAttempts; ++tries) {
                boolean retry;
                block83: {
                    Method ejbTimeout;
                    RpcContainer container;
                    block80: {
                        block82: {
                            block81: {
                                block77: {
                                    block79: {
                                        block78: {
                                            retry = false;
                                            if (this.transacted) {
                                                try {
                                                    this.transactionManager.begin();
                                                }
                                                catch (Exception e) {
                                                    log.warning("Exception occured while starting container transaction", e);
                                                    thread.setContextClassLoader(loader);
                                                    if (timerData.getType() == TimerType.SingleAction) {
                                                        this.timerStore.removeTimer(timerData.getId());
                                                        timerData.setExpired(true);
                                                    } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                                                        this.timerStore.removeTimer(timerData.getId());
                                                        timerData.setExpired(true);
                                                    } else {
                                                        this.timerStore.updateIntervalTimer(timerData);
                                                    }
                                                    return;
                                                }
                                            }
                                            container = (RpcContainer)this.deployment.getContainer();
                                            if (container != null) break block77;
                                            if (this.transacted) break block78;
                                            if (!retry) {
                                                return;
                                            }
                                            break block79;
                                        }
                                        if (this.transactionManager.getStatus() == 0) {
                                            this.transactionManager.commit();
                                            return;
                                        }
                                        try {
                                            this.transactionManager.rollback();
                                        }
                                        catch (Exception e) {
                                            log.warning("Exception occured while completing container transaction", e);
                                        }
                                    }
                                    return;
                                }
                                ejbTimeout = timerData.getTimeoutMethod();
                                if (ejbTimeout != null) break block80;
                                if (this.transacted) break block81;
                                if (!retry) {
                                    return;
                                }
                                break block82;
                            }
                            if (this.transactionManager.getStatus() == 0) {
                                this.transactionManager.commit();
                                return;
                            }
                            try {
                                this.transactionManager.rollback();
                            }
                            catch (Exception e) {
                                log.warning("Exception occured while completing container transaction", e);
                            }
                        }
                        return;
                    }
                    thread.setContextClassLoader(this.deployment.getClassLoader() != null ? this.deployment.getClassLoader() : loader);
                    SetAccessible.on(ejbTimeout);
                    container.invoke(this.deployment.getDeploymentID(), InterfaceType.TIMEOUT, ejbTimeout.getDeclaringClass(), ejbTimeout, new Object[]{timer}, timerData.getPrimaryKey());
                    if (this.transacted) break block83;
                    if (retry) continue;
                    return;
                }
                if (this.transactionManager.getStatus() == 0) {
                    this.transactionManager.commit();
                    return;
                }
                try {
                    this.transactionManager.rollback();
                }
                catch (Exception e) {
                    log.warning("Exception occured while completing container transaction", e);
                }
                continue;
                catch (RuntimeException e) {
                    block84: {
                        retry = true;
                        log.warning("RuntimeException from ejbTimeout on " + this.deployment.getDeploymentID(), e);
                        try {
                            this.transactionManager.setRollbackOnly();
                        }
                        catch (SystemException e1) {
                            log.warning("Exception occured while setting RollbackOnly for container transaction", e1);
                        }
                        if (this.transacted) break block84;
                        if (retry) continue;
                        return;
                    }
                    if (this.transactionManager.getStatus() == 0) {
                        this.transactionManager.commit();
                        return;
                    }
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Exception e2) {
                        log.warning("Exception occured while completing container transaction", e2);
                    }
                    continue;
                }
                catch (OpenEJBException e2) {
                    block86: {
                        block85: {
                            retry = true;
                            if (ApplicationException.class.isInstance(e2)) {
                                log.debug("Exception from ejbTimeout on " + this.deployment.getDeploymentID(), e2);
                            } else {
                                log.warning("Exception from ejbTimeout on " + this.deployment.getDeploymentID(), e2);
                            }
                            if (!this.transacted) break block85;
                            try {
                                this.transactionManager.setRollbackOnly();
                            }
                            catch (SystemException e1) {
                                log.warning("Exception occured while setting RollbackOnly for container transaction", e1);
                            }
                            {
                                catch (Throwable throwable) {
                                    block87: {
                                        if (this.transacted) break block87;
                                        if (!retry) {
                                            return;
                                        }
                                    }
                                    if (this.transactionManager.getStatus() == 0) {
                                        this.transactionManager.commit();
                                        return;
                                    }
                                    try {
                                        this.transactionManager.rollback();
                                    }
                                    catch (Exception e3) {
                                        log.warning("Exception occured while completing container transaction", e3);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        if (this.transacted) break block86;
                        if (retry) continue;
                        return;
                    }
                    if (this.transactionManager.getStatus() == 0) {
                        this.transactionManager.commit();
                        return;
                    }
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Exception e4) {
                        log.warning("Exception occured while completing container transaction", e4);
                    }
                    continue;
                }
            }
            log.warning("Failed to execute ejbTimeout on " + timerData.getDeploymentId() + " successfully within " + this.retryAttempts + " attempts");
        }
        catch (RuntimeException e) {
            log.warning("RuntimeException occured while calling ejbTimeout", e);
            throw e;
        }
        catch (Error e) {
            log.warning("Error occured while calling ejbTimeout", e);
            throw e;
        }
        finally {
            thread.setContextClassLoader(loader);
            if (timerData.getType() == TimerType.SingleAction) {
                this.timerStore.removeTimer(timerData.getId());
                timerData.setExpired(true);
            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                this.timerStore.removeTimer(timerData.getId());
                timerData.setExpired(true);
            } else {
                this.timerStore.updateIntervalTimer(timerData);
            }
        }
    }

    private static class LazyScheduler
    implements InvocationHandler {
        private final BeanContext ejb;

        public LazyScheduler(BeanContext deployment) {
            this.ejb = deployment;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)EjbTimerServiceImpl.getDefaultScheduler(this.ejb), args);
        }
    }
}

